/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.affinity;

import java.util.ArrayList;
import us.ihmc.affinity.Core;

public class Package {
    private final int id;
    private final ArrayList<Core> cores = new ArrayList();

    public Package(int id) {
        this.id = id;
    }

    public void addCore(int cpu) {
        for (Core core : this.cores) {
            if (!core.isThreadSibling(cpu)) continue;
            return;
        }
        this.cores.add(new Core(cpu));
    }

    public Core getCore(int core) {
        return this.cores.get(core);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\tPackage id: ");
        builder.append(this.id);
        builder.append('\n');
        for (Core core : this.cores) {
            builder.append(core.toString());
        }
        return builder.toString();
    }

    public int getNumberOfCores() {
        return this.cores.size();
    }

    public int getNumberOfProcessors() {
        int processors = 0;
        for (Core core : this.cores) {
            processors += core.getNumberOfProcessors();
        }
        return processors;
    }
}

