/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.realtime;

import us.ihmc.realtime.RealtimeNative;

public class MonotonicTime {
    public static final long NANOSECONDS_PER_SECOND = 1000000000L;
    private long seconds;
    private long nanoseconds;

    public static MonotonicTime getCurrentTime() {
        MonotonicTime monotonicTime = new MonotonicTime();
        monotonicTime.setToCurrentTime();
        return monotonicTime;
    }

    public MonotonicTime(long seconds, long nanoseconds) {
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
        this.normalize();
    }

    public MonotonicTime() {
        this.seconds = 0L;
        this.nanoseconds = 0L;
    }

    private void normalize() {
        this.seconds += this.nanoseconds / 1000000000L;
        this.nanoseconds %= 1000000000L;
    }

    public void add(MonotonicTime time) {
        this.seconds += time.seconds;
        this.nanoseconds += time.nanoseconds;
        this.normalize();
    }

    public void sub(MonotonicTime time) {
        this.seconds -= time.seconds;
        this.nanoseconds -= time.nanoseconds;
        this.normalize();
    }

    public void set(long seconds, long nanoseconds) {
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
        this.normalize();
    }

    public void set(MonotonicTime monotonicTime) {
        this.seconds = monotonicTime.seconds;
        this.nanoseconds = monotonicTime.nanoseconds;
    }

    public void setToCurrentTime() {
        this.seconds = 0L;
        this.nanoseconds = RealtimeNative.getCurrentTimeNative();
        this.normalize();
    }

    public void addNanoseconds(long nanoseconds) {
        this.nanoseconds += nanoseconds;
        this.normalize();
    }

    public void subNanoseconds(long nanoseconds) {
        this.nanoseconds -= nanoseconds;
        this.normalize();
    }

    long seconds() {
        return this.seconds;
    }

    long nanoseconds() {
        return this.nanoseconds;
    }

    public double asSeconds() {
        return (double)this.seconds + (double)this.nanoseconds / 1.0E9;
    }

    public long asNanoseconds() {
        return this.seconds * 1000000000L + this.nanoseconds;
    }

    public String toString() {
        return this.seconds + "s " + this.nanoseconds + "ns";
    }
}

