/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSJNI;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantImpl;
import us.ihmc.rtps.impl.fastRTPS.NativeSubscriberListener;
import us.ihmc.rtps.impl.fastRTPS.SampleInfoMarshaller;

public class NativeSubscriberImpl {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected NativeSubscriberImpl(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(NativeSubscriberImpl obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(NativeSubscriberImpl obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                FastRTPSJNI.delete_NativeSubscriberImpl(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public NativeSubscriberImpl(NativeParticipantImpl participant, NativeSubscriberListener listener) throws IOException {
        this(FastRTPSJNI.new_NativeSubscriberImpl(NativeParticipantImpl.getCPtr(participant), participant, NativeSubscriberListener.getCPtr(listener), listener), true);
    }

    public boolean createSubscriber() {
        return FastRTPSJNI.NativeSubscriberImpl_createSubscriber__SWIG_0(this.swigCPtr, this);
    }

    public boolean createSubscriber(String subscriberProfile, String XMLConfigData, long XMLdataLength) {
        return FastRTPSJNI.NativeSubscriberImpl_createSubscriber__SWIG_1(this.swigCPtr, this, subscriberProfile, XMLConfigData, XMLdataLength);
    }

    public long getGuidLow() {
        return FastRTPSJNI.NativeSubscriberImpl_getGuidLow(this.swigCPtr, this);
    }

    public long getGuidHigh() {
        return FastRTPSJNI.NativeSubscriberImpl_getGuidHigh(this.swigCPtr, this);
    }

    public void waitForUnreadMessage() {
        FastRTPSJNI.NativeSubscriberImpl_waitForUnreadMessage(this.swigCPtr, this);
    }

    public boolean readnextData(int maxDataLength, ByteBuffer data, SampleInfoMarshaller marshaller) {
        assert (data.isDirect()) : "Buffer must be allocated direct.";
        return FastRTPSJNI.NativeSubscriberImpl_readnextData(this.swigCPtr, this, maxDataLength, data, SampleInfoMarshaller.getCPtr(marshaller), marshaller);
    }

    public boolean takeNextData(int maxDataLength, ByteBuffer data, SampleInfoMarshaller marshaller) {
        assert (data.isDirect()) : "Buffer must be allocated direct.";
        return FastRTPSJNI.NativeSubscriberImpl_takeNextData(this.swigCPtr, this, maxDataLength, data, SampleInfoMarshaller.getCPtr(marshaller), marshaller);
    }

    public boolean isInCleanState() {
        return FastRTPSJNI.NativeSubscriberImpl_isInCleanState(this.swigCPtr, this);
    }

    public long getUnreadCount() {
        return FastRTPSJNI.NativeSubscriberImpl_getUnreadCount(this.swigCPtr, this);
    }
}

