/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization;

import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.convexOptimization.QpOASESCWrapper;
import us.ihmc.convexOptimization.QpOASESSwigWrapper;
import us.ihmc.convexOptimization.QuadProgWrapper;

public class QPSolversTest {
    @Test
    public void simpleTests() {
        int nin = 1;
        int neq = 1;
        int nv = 2;
        DMatrixRMaj Q = new DMatrixRMaj(nv, nv, true, new double[]{1.0, 0.0, 0.0, 1.0});
        DMatrixRMaj f = new DMatrixRMaj(nv, 1, true, new double[]{1.0, 0.0});
        DMatrixRMaj Aeq = new DMatrixRMaj(neq, nv, true, new double[]{1.0, 1.0});
        DMatrixRMaj beq = new DMatrixRMaj(neq, 1, true, new double[]{0.0});
        DMatrixRMaj Ain = new DMatrixRMaj(nin, nv, true, new double[]{2.0, 1.0});
        DMatrixRMaj bin = new DMatrixRMaj(nin, 1, true, new double[]{0.0});
        DMatrixRMaj x = new DMatrixRMaj(nv, 1, true, new double[]{-1.0, 1.0});
        DMatrixRMaj lb = new DMatrixRMaj(nv, 1, true, new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY});
        DMatrixRMaj ub = new DMatrixRMaj(nv, 1, true, new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        DMatrixRMaj solX = new DMatrixRMaj(nv, 1, true, new double[]{-0.5, 0.5});
        double epsilon = 1.0E-10;
        QpOASESCWrapper solverC = new QpOASESCWrapper();
        x.zero();
        solverC.solve(Q, f, Aeq, beq, Ain, bin, lb, ub, x, true);
        System.out.println("OASES CWrapper xopt=" + x + "iter=" + solverC.getLastWorkingSetChanges() + " optVal=" + solverC.getOptVal() + " cputime:" + solverC.getLastCpuTime());
        Assertions.assertArrayEquals((double[])solX.data, (double[])x.data, (double)epsilon);
        QpOASESSwigWrapper solverSwig = new QpOASESSwigWrapper();
        x.zero();
        solverSwig.solve(Q, f, Aeq, beq, Ain, bin, lb, ub, x, true);
        System.out.println("OASES SwigWrapper xopt=" + x + "iter=" + solverSwig.getLastWorkingSetChanges() + " optVal=" + solverSwig.getOptVal() + " cputime:" + solverSwig.getLastCpuTime());
        Assertions.assertArrayEquals((double[])solX.data, (double[])x.data, (double)epsilon);
        QuadProgWrapper qprog = new QuadProgWrapper();
        DMatrixRMaj AeqNegT = new DMatrixRMaj(Aeq.numCols, Aeq.numRows);
        CommonOps_DDRM.transpose((DMatrixRMaj)Aeq, (DMatrixRMaj)AeqNegT);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)AeqNegT);
        DMatrixRMaj AinNegT = new DMatrixRMaj(Ain.numCols, Ain.numRows);
        CommonOps_DDRM.transpose((DMatrixRMaj)Ain, (DMatrixRMaj)AinNegT);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)AinNegT);
        x.zero();
        int iter = qprog.solve(Q, f, AeqNegT, beq, AinNegT, bin, x, true);
        System.out.println("QuadProg SwigWrapper xopt=" + x + "iter=" + iter + " optVal=" + solverSwig.getOptVal());
        Assertions.assertArrayEquals((double[])solX.data, (double[])x.data, (double)epsilon);
    }

    public static void main(String[] arg) {
        new QPSolversTest().simpleTests();
    }
}

