/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.matrixlib.jni;

import us.ihmc.matrixlib.jni.NativeMatrixLibraryJNI;

public class NativeMatrixImpl {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected NativeMatrixImpl(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(NativeMatrixImpl obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                NativeMatrixLibraryJNI.delete_NativeMatrixImpl(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setNan(double value) {
        NativeMatrixLibraryJNI.NativeMatrixImpl_nan_set(this.swigCPtr, this, value);
    }

    public double getNan() {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_nan_get(this.swigCPtr, this);
    }

    public NativeMatrixImpl(int numRows, int numCols) {
        this(NativeMatrixLibraryJNI.new_NativeMatrixImpl(numRows, numCols), true);
    }

    public void resize(int numRows, int numCols) {
        NativeMatrixLibraryJNI.NativeMatrixImpl_resize(this.swigCPtr, this, numRows, numCols);
    }

    public boolean set(NativeMatrixImpl a) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_set__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a);
    }

    public boolean add(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_add__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean add(NativeMatrixImpl a, double scale, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_add__SWIG_1(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, scale, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean add(double scale1, NativeMatrixImpl a, double scale2, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_add__SWIG_2(this.swigCPtr, this, scale1, NativeMatrixImpl.getCPtr(a), a, scale2, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean addEquals(NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_addEquals__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean addEquals(double scale, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_addEquals__SWIG_1(this.swigCPtr, this, scale, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean add(int row, int col, double value) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_add__SWIG_3(this.swigCPtr, this, row, col, value);
    }

    public boolean subtract(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_subtract(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean mult(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_mult__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean mult(double scale, NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_mult__SWIG_1(this.swigCPtr, this, scale, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multAdd(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAdd__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multAdd(double scale, NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAdd__SWIG_1(this.swigCPtr, this, scale, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multTransA(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multTransA__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multTransA(double scale, NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multTransA__SWIG_1(this.swigCPtr, this, scale, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multAddTransA(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAddTransA__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multAddTransA(double scale, NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAddTransA__SWIG_1(this.swigCPtr, this, scale, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multTransB(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multTransB__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multTransB(double scale, NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multTransB__SWIG_1(this.swigCPtr, this, scale, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multAddTransB(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAddTransB__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multAddTransB(double scale, NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAddTransB__SWIG_1(this.swigCPtr, this, scale, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean addBlock(NativeMatrixImpl a, int destStartRow, int destStartColumn, int srcStartRow, int srcStartColumn, int numberOfRows, int numberOfColumns, double scale) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_addBlock__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, destStartRow, destStartColumn, srcStartRow, srcStartColumn, numberOfRows, numberOfColumns, scale);
    }

    public boolean addBlock(NativeMatrixImpl a, int destStartRow, int destStartColumn, int srcStartRow, int srcStartColumn, int numberOfRows, int numberOfColumns) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_addBlock__SWIG_1(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, destStartRow, destStartColumn, srcStartRow, srcStartColumn, numberOfRows, numberOfColumns);
    }

    public boolean subtractBlock(NativeMatrixImpl a, int destStartRow, int destStartColumn, int srcStartRow, int srcStartColumn, int numberOfRows, int numberOfColumns) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_subtractBlock(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, destStartRow, destStartColumn, srcStartRow, srcStartColumn, numberOfRows, numberOfColumns);
    }

    public boolean multAddBlock(NativeMatrixImpl a, NativeMatrixImpl b, int rowStart, int colStart) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAddBlock__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b, rowStart, colStart);
    }

    public boolean multAddBlock(double scale, NativeMatrixImpl a, NativeMatrixImpl b, int rowStart, int colStart) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAddBlock__SWIG_1(this.swigCPtr, this, scale, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b, rowStart, colStart);
    }

    public boolean multAddBlockTransA(NativeMatrixImpl a, NativeMatrixImpl b, int rowStart, int colStart) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAddBlockTransA__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b, rowStart, colStart);
    }

    public boolean multAddBlockTransA(double scale, NativeMatrixImpl a, NativeMatrixImpl b, int rowStart, int colStart) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAddBlockTransA__SWIG_1(this.swigCPtr, this, scale, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b, rowStart, colStart);
    }

    public boolean multQuad(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multQuad(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multAddQuad(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAddQuad(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean multQuadBlock(NativeMatrixImpl a, NativeMatrixImpl b, int rowStart, int colStart) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multQuadBlock(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b, rowStart, colStart);
    }

    public boolean multAddQuadBlock(NativeMatrixImpl a, NativeMatrixImpl b, int rowStart, int colStart) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_multAddQuadBlock(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b, rowStart, colStart);
    }

    public boolean invert(NativeMatrixImpl a) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_invert(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a);
    }

    public boolean solve(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_solve(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean solveCheck(NativeMatrixImpl a, NativeMatrixImpl b) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_solveCheck(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a, NativeMatrixImpl.getCPtr(b), b);
    }

    public boolean insert(NativeMatrixImpl src, int srcY0, int srcY1, int srcX0, int srcX1, int dstY0, int dstX0) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_insert__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(src), src, srcY0, srcY1, srcX0, srcX1, dstY0, dstX0);
    }

    public boolean insert(double[] src, int rows, int cols, int srcY0, int srcY1, int srcX0, int srcX1, int dstY0, int dstX0) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_insert__SWIG_1(this.swigCPtr, this, src, rows, cols, srcY0, srcY1, srcX0, srcX1, dstY0, dstX0);
    }

    public boolean insert(int startRow, int startCol, double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_insert__SWIG_2(this.swigCPtr, this, startRow, startCol, m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    public boolean insertTupleRow(int startRow, int startCol, double x, double y, double z) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_insertTupleRow(this.swigCPtr, this, startRow, startCol, x, y, z);
    }

    public boolean insertScaled(NativeMatrixImpl src, int srcY0, int srcY1, int srcX0, int srcX1, int dstY0, int dstX0, double scale) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_insertScaled__SWIG_0(this.swigCPtr, this, NativeMatrixImpl.getCPtr(src), src, srcY0, srcY1, srcX0, srcX1, dstY0, dstX0, scale);
    }

    public boolean insertScaled(double[] src, int srcRows, int srcCols, int srcY0, int srcY1, int srcX0, int srcX1, int dstY0, int dstX0, double scale) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_insertScaled__SWIG_1(this.swigCPtr, this, src, srcRows, srcCols, srcY0, srcY1, srcX0, srcX1, dstY0, dstX0, scale);
    }

    public boolean extract(int srcY0, int srcY1, int srcX0, int srcX1, double[] dst, int dstRows, int dstCols, int dstY0, int dstX0) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_extract(this.swigCPtr, this, srcY0, srcY1, srcX0, srcX1, dst, dstRows, dstCols, dstY0, dstX0);
    }

    public boolean transpose(NativeMatrixImpl a) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_transpose(this.swigCPtr, this, NativeMatrixImpl.getCPtr(a), a);
    }

    public boolean removeRow(int indexToRemove) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_removeRow(this.swigCPtr, this, indexToRemove);
    }

    public boolean removeColumn(int indexToRemove) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_removeColumn(this.swigCPtr, this, indexToRemove);
    }

    public void zero() {
        NativeMatrixLibraryJNI.NativeMatrixImpl_zero(this.swigCPtr, this);
    }

    public boolean containsNaN() {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_containsNaN(this.swigCPtr, this);
    }

    public boolean scale(double scale, NativeMatrixImpl src) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_scale__SWIG_0(this.swigCPtr, this, scale, NativeMatrixImpl.getCPtr(src), src);
    }

    public boolean isAprrox(NativeMatrixImpl other, double precision) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_isAprrox(this.swigCPtr, this, NativeMatrixImpl.getCPtr(other), other, precision);
    }

    public boolean set(double[] data, int rows, int cols) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_set__SWIG_1(this.swigCPtr, this, data, rows, cols);
    }

    public boolean get(double[] data, int rows, int cols) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_get__SWIG_0(this.swigCPtr, this, data, rows, cols);
    }

    public boolean addDiagonal(int startRow, int startCol, int rows, int cols, double value) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_addDiagonal__SWIG_0(this.swigCPtr, this, startRow, startCol, rows, cols, value);
    }

    public boolean fillDiagonal(int startRow, int startCol, int rows, int cols, double value) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_fillDiagonal__SWIG_0(this.swigCPtr, this, startRow, startCol, rows, cols, value);
    }

    public boolean fillBlock(int startRow, int startCol, int numberOfRows, int numberOfCols, double value) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_fillBlock(this.swigCPtr, this, startRow, startCol, numberOfRows, numberOfCols, value);
    }

    public boolean addDiagonal(int startRow, int startCol, int size, double value) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_addDiagonal__SWIG_1(this.swigCPtr, this, startRow, startCol, size, value);
    }

    public boolean addDiagonal(double value) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_addDiagonal__SWIG_2(this.swigCPtr, this, value);
    }

    public boolean fillDiagonal(int startRow, int startCol, int size, double value) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_fillDiagonal__SWIG_1(this.swigCPtr, this, startRow, startCol, size, value);
    }

    public boolean fillDiagonal(double value) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_fillDiagonal__SWIG_2(this.swigCPtr, this, value);
    }

    public double min() {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_min(this.swigCPtr, this);
    }

    public double max() {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_max(this.swigCPtr, this);
    }

    public double sum() {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_sum(this.swigCPtr, this);
    }

    public double prod() {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_prod(this.swigCPtr, this);
    }

    public void scale(double scale) {
        NativeMatrixLibraryJNI.NativeMatrixImpl_scale__SWIG_1(this.swigCPtr, this, scale);
    }

    public boolean set(int row, int col, double value) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_set__SWIG_2(this.swigCPtr, this, row, col, value);
    }

    public double get(int row, int col) {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_get__SWIG_1(this.swigCPtr, this, row, col);
    }

    public int rows() {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_rows(this.swigCPtr, this);
    }

    public int cols() {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_cols(this.swigCPtr, this);
    }

    public int size() {
        return NativeMatrixLibraryJNI.NativeMatrixImpl_size(this.swigCPtr, this);
    }

    public void print() {
        NativeMatrixLibraryJNI.NativeMatrixImpl_print(this.swigCPtr, this);
    }
}

