/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.handler;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.fun.ChoiceFetchHandler;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.cache.CaffeineEruptCache;
import xyz.erupt.upms.model.EruptDictItem;

@Component
public class DictChoiceFetchHandler
implements ChoiceFetchHandler {
    @Resource
    private EruptDao eruptDao;
    private final String CACHE_SPACE = DictChoiceFetchHandler.class.getName() + ":";
    private final CaffeineEruptCache<List<VLModel>> dictCache = new CaffeineEruptCache();

    public List<VLModel> fetch(String[] params) {
        if (null == params || params.length == 0) {
            throw new RuntimeException("DictChoiceFetchHandler \u2192 params[0] must dict \u2192 code");
        }
        long timeout = 3000L;
        if (params.length == 2) {
            timeout = Long.parseLong(params[1]);
        }
        this.dictCache.init(timeout);
        String dictCode = params[0];
        return this.dictCache.get(this.CACHE_SPACE + params[0], key -> {
            ArrayList<VLModel> list = new ArrayList<VLModel>();
            List eruptDictItem = this.eruptDao.queryEntityList(EruptDictItem.class, "eruptDict.code = '" + dictCode + "'", null);
            for (EruptDictItem item : eruptDictItem) {
                list.add(new VLModel(item.getId().toString(), item.getName()));
            }
            return list;
        });
    }
}

