/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.model;

import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.service.I18NTranslateService;
import xyz.erupt.core.util.MD5Util;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptUserService;

@Component
public class EruptUserDataProxy
implements DataProxy<EruptUser> {
    @Resource
    private EruptUserService eruptUserService;
    @Resource
    private I18NTranslateService i18NTranslateService;

    public void beforeAdd(EruptUser eruptUser) {
        this.checkDataLegal(eruptUser);
        if (StringUtils.isBlank((CharSequence)eruptUser.getPasswordA())) {
            throw new EruptApiErrorTip(EruptApiModel.Status.WARNING, "\u5bc6\u7801\u5fc5\u586b", EruptApiModel.PromptWay.MESSAGE);
        }
        if (eruptUser.getPasswordA().equals(eruptUser.getPasswordB())) {
            if (eruptUser.getIsMd5().booleanValue()) {
                eruptUser.setPassword(MD5Util.digest((String)eruptUser.getPasswordA()));
            } else {
                eruptUser.setPassword(eruptUser.getPasswordA());
            }
        } else {
            throw new EruptWebApiRuntimeException(this.i18NTranslateService.translate("\u4e24\u6b21\u5bc6\u7801\u8f93\u5165\u4e0d\u4e00\u81f4", new Object[0]));
        }
    }

    public void beforeUpdate(EruptUser eruptUser) {
        this.checkDataLegal(eruptUser);
    }

    private void checkDataLegal(EruptUser eruptUser) {
        if (eruptUser.getEruptPost() != null && eruptUser.getEruptOrg() == null) {
            throw new EruptWebApiRuntimeException("\u9009\u62e9\u5c97\u4f4d\u65f6\uff0c\u6240\u5c5e\u7ec4\u7ec7\u5fc5\u586b");
        }
        EruptUser curr = this.eruptUserService.getCurrentEruptUser();
        if (eruptUser.getIsAdmin().booleanValue() && (null == curr.getIsAdmin() || !curr.getIsAdmin().booleanValue())) {
            throw new EruptWebApiRuntimeException(this.i18NTranslateService.translate("\u5f53\u524d\u7528\u6237\u975e\u8d85\u7ba1\uff0c\u65e0\u6cd5\u521b\u5efa\u8d85\u7ba1\u7528\u6237\uff01", new Object[0]));
        }
    }
}

