/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.ekf.filter.state.State;

public class ComposedState
extends State {
    private final List<State> subStates = new ArrayList<State>();
    private final Map<State, MutableInt> stateIndexMap = new HashMap<State, MutableInt>();
    private final String name;
    private final DMatrixRMaj tempMatrix = new DMatrixRMaj(0, 0);

    public ComposedState(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addState(State stateToAdd) {
        if (stateToAdd == null) {
            return;
        }
        if (this.stateIndexMap.containsKey(stateToAdd)) {
            throw new RuntimeException("Trying to add a state with name " + stateToAdd.getName() + " twice.");
        }
        if (stateToAdd instanceof ComposedState) {
            ((ComposedState)stateToAdd).subStates.forEach(this::addState);
            return;
        }
        int oldSize = this.getSize();
        this.stateIndexMap.put(stateToAdd, new MutableInt(oldSize));
        this.subStates.add(stateToAdd);
    }

    public int getStartIndex(State state) {
        MutableInt startIndex = this.stateIndexMap.get(state);
        if (startIndex == null) {
            throw new RuntimeException("Do not have sub state " + state.getName());
        }
        return startIndex.intValue();
    }

    @Override
    public void getStateVector(DMatrix1Row vectorToPack) {
        vectorToPack.reshape(this.getSize(), 1);
        for (int i = 0; i < this.subStates.size(); ++i) {
            State subState = this.subStates.get(i);
            int startIndex = this.getStartIndex(subState);
            subState.getStateVector((DMatrix1Row)this.tempMatrix);
            System.arraycopy(this.tempMatrix.data, 0, vectorToPack.data, startIndex, subState.getSize());
        }
    }

    @Override
    public void setStateVector(DMatrix1Row newState) {
        for (int i = 0; i < this.subStates.size(); ++i) {
            State subState = this.subStates.get(i);
            int startIndex = this.getStartIndex(subState);
            this.tempMatrix.reshape(subState.getSize(), 1);
            System.arraycopy(newState.data, startIndex, this.tempMatrix.data, 0, subState.getSize());
            subState.setStateVector((DMatrix1Row)this.tempMatrix);
        }
    }

    @Override
    public int getSize() {
        if (this.subStates.isEmpty()) {
            return 0;
        }
        State lastSubState = this.subStates.get(this.subStates.size() - 1);
        return this.getStartIndex(lastSubState) + lastSubState.getSize();
    }

    @Override
    public void predict() {
        for (int i = 0; i < this.subStates.size(); ++i) {
            this.subStates.get(i).predict();
        }
    }

    @Override
    public void getFMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(this.getSize(), this.getSize());
        CommonOps_DDRM.fill((DMatrixD1)matrixToPack, (double)0.0);
        for (int i = 0; i < this.subStates.size(); ++i) {
            State subState = this.subStates.get(i);
            int startIndex = this.getStartIndex(subState);
            subState.getFMatrix((DMatrix1Row)this.tempMatrix);
            CommonOps_DDRM.insert((DMatrix)this.tempMatrix, (DMatrix)matrixToPack, (int)startIndex, (int)startIndex);
        }
    }

    @Override
    public void getQMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(this.getSize(), this.getSize());
        CommonOps_DDRM.fill((DMatrixD1)matrixToPack, (double)0.0);
        for (int i = 0; i < this.subStates.size(); ++i) {
            State subState = this.subStates.get(i);
            int startIndex = this.getStartIndex(subState);
            subState.getQMatrix((DMatrix1Row)this.tempMatrix);
            CommonOps_DDRM.insert((DMatrix)this.tempMatrix, (DMatrix)matrixToPack, (int)startIndex, (int)startIndex);
        }
    }
}

