/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.rpc.model.ConsumerMethodModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class ConsumerModel {
    private final String serviceKey;
    private final ServiceDescriptor serviceModel;
    private final ReferenceConfigBase<?> referenceConfig;
    private Object proxyObject;
    private final Map<String, AsyncMethodInfo> methodConfigs = new HashMap<String, AsyncMethodInfo>();
    private ServiceMetadata serviceMetadata;
    private Map<Method, ConsumerMethodModel> methodModels = new IdentityHashMap<Method, ConsumerMethodModel>();

    public ConsumerModel(String serviceKey, Object proxyObject, ServiceDescriptor serviceModel, ReferenceConfigBase<?> referenceConfig, Map<String, Object> attributes) {
        Assert.notEmptyString(serviceKey, "Service name can't be null or blank");
        this.serviceKey = serviceKey;
        this.proxyObject = proxyObject;
        this.serviceModel = serviceModel;
        this.referenceConfig = referenceConfig;
        if (CollectionUtils.isNotEmptyMap(attributes)) {
            attributes.forEach((method, object) -> this.methodConfigs.put((String)method, (AsyncMethodInfo)object));
        }
    }

    public Object getProxyObject() {
        return this.proxyObject;
    }

    public void setProxyObject(Object proxyObject) {
        this.proxyObject = proxyObject;
    }

    public Set<MethodDescriptor> getAllMethods() {
        return this.serviceModel.getAllMethods();
    }

    public Class<?> getServiceInterfaceClass() {
        return this.serviceModel.getServiceInterfaceClass();
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public AsyncMethodInfo getMethodConfig(String methodName) {
        return this.methodConfigs.get(methodName);
    }

    public ServiceDescriptor getServiceModel() {
        return this.serviceModel;
    }

    public ReferenceConfigBase getReferenceConfig() {
        return this.referenceConfig;
    }

    public ConsumerModel(String serviceKey, Object proxyObject, ServiceDescriptor serviceModel, ReferenceConfigBase<?> referenceConfig, Map<String, Object> attributes, ServiceMetadata metadata) {
        this(serviceKey, proxyObject, serviceModel, referenceConfig, attributes);
        this.serviceMetadata = metadata;
        for (Method method : metadata.getServiceType().getMethods()) {
            this.methodModels.put(method, new ConsumerMethodModel(method, attributes));
        }
    }

    public ClassLoader getClassLoader() {
        return this.serviceMetadata.getServiceType().getClassLoader();
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    public ConsumerMethodModel getMethodModel(Method method) {
        return this.methodModels.get(method);
    }

    public ConsumerMethodModel getMethodModel(String method) {
        Optional<Map.Entry> consumerMethodModelEntry = this.methodModels.entrySet().stream().filter(entry -> ((Method)entry.getKey()).getName().equals(method)).findFirst();
        return consumerMethodModelEntry.map(Map.Entry::getValue).orElse(null);
    }

    public ConsumerMethodModel getMethodModel(String method, String[] argsType) {
        Optional<ConsumerMethodModel> consumerMethodModel = this.methodModels.entrySet().stream().filter(entry -> ((Method)entry.getKey()).getName().equals(method)).map(Map.Entry::getValue).filter(methodModel -> Arrays.equals(argsType, methodModel.getParameterTypes())).findFirst();
        return consumerMethodModel.orElse(null);
    }

    public List<ConsumerMethodModel> getAllMethodModels() {
        return new ArrayList<ConsumerMethodModel>(this.methodModels.values());
    }

    public String getServiceName() {
        return this.serviceMetadata.getServiceKey();
    }

    public static class AsyncMethodInfo {
        private Object oninvokeInstance;
        private Method oninvokeMethod;
        private Object onreturnInstance;
        private Method onreturnMethod;
        private Object onthrowInstance;
        private Method onthrowMethod;

        public Object getOninvokeInstance() {
            return this.oninvokeInstance;
        }

        public void setOninvokeInstance(Object oninvokeInstance) {
            this.oninvokeInstance = oninvokeInstance;
        }

        public Method getOninvokeMethod() {
            return this.oninvokeMethod;
        }

        public void setOninvokeMethod(Method oninvokeMethod) {
            this.oninvokeMethod = oninvokeMethod;
        }

        public Object getOnreturnInstance() {
            return this.onreturnInstance;
        }

        public void setOnreturnInstance(Object onreturnInstance) {
            this.onreturnInstance = onreturnInstance;
        }

        public Method getOnreturnMethod() {
            return this.onreturnMethod;
        }

        public void setOnreturnMethod(Method onreturnMethod) {
            this.onreturnMethod = onreturnMethod;
        }

        public Object getOnthrowInstance() {
            return this.onthrowInstance;
        }

        public void setOnthrowInstance(Object onthrowInstance) {
            this.onthrowInstance = onthrowInstance;
        }

        public Method getOnthrowMethod() {
            return this.onthrowMethod;
        }

        public void setOnthrowMethod(Method onthrowMethod) {
            this.onthrowMethod = onthrowMethod;
        }
    }
}

