/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata.proxy;

import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.report.MetadataReport;
import org.apache.dubbo.metadata.report.MetadataReportInstance;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;

public class RemoteMetadataServiceProxy
implements MetadataService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String serviceName;
    private String revision;

    public RemoteMetadataServiceProxy(ServiceInstance serviceInstance) {
        this.serviceName = serviceInstance.getServiceName();
        this.revision = serviceInstance.getMetadata().getOrDefault(ServiceInstanceMetadataUtils.EXPORTED_SERVICES_REVISION_PROPERTY_NAME, "N/A");
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version, String protocol) {
        return RemoteMetadataServiceProxy.toSortedStrings(this.getMetadataReport().getExportedURLs(new ServiceMetadataIdentifier(serviceInterface, group, version, "provider", this.revision, protocol)));
    }

    private static SortedSet<String> toSortedStrings(Collection<String> values) {
        return Collections.unmodifiableSortedSet(new TreeSet<String>(values));
    }

    @Override
    public String getServiceDefinition(String interfaceName, String version, String group) {
        return this.getMetadataReport().getServiceDefinition(new MetadataIdentifier(interfaceName, version, group, "provider", this.serviceName));
    }

    @Override
    public String getServiceDefinition(String serviceKey) {
        String[] services = UrlUtils.parseServiceKey(serviceKey);
        String serviceInterface = services[0];
        String version = null;
        if (services.length > 1) {
            version = services[1];
        }
        String group = null;
        if (services.length > 2) {
            group = services[2];
        }
        return this.getMetadataReport().getServiceDefinition(new MetadataIdentifier(serviceInterface, version, group, "provider", this.serviceName));
    }

    MetadataReport getMetadataReport() {
        return MetadataReportInstance.getMetadataReport(true);
    }
}

