/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata.proxy;

import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;
import org.apache.dubbo.registry.client.metadata.proxy.BaseMetadataServiceProxyFactory;
import org.apache.dubbo.registry.client.metadata.proxy.MetadataServiceProxyFactory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;

public class DefaultMetadataServiceProxyFactory
extends BaseMetadataServiceProxyFactory
implements MetadataServiceProxyFactory {
    private ProxyFactory proxyFactory;
    private Protocol protocol;

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    protected MetadataService createProxy(ServiceInstance serviceInstance) {
        MetadataServiceURLBuilder builder = null;
        ExtensionLoader<MetadataServiceURLBuilder> loader = ExtensionLoader.getExtensionLoader(MetadataServiceURLBuilder.class);
        Map<String, String> metadata = serviceInstance.getMetadata();
        String dubboURLsJSON = metadata.get("dubbo.metadata-service.urls");
        builder = StringUtils.isNotEmpty(dubboURLsJSON) ? loader.getExtension("spring-cloud") : loader.getExtension("standard");
        List<URL> urls = builder.build(serviceInstance);
        if (CollectionUtils.isEmpty(urls)) {
            throw new IllegalStateException("You have enabled introspection service discovery mode for instance " + serviceInstance + ", but no metadata service can build from it.");
        }
        Invoker<MetadataService> invoker = this.protocol.refer(MetadataService.class, urls.get(0));
        return this.proxyFactory.getProxy(invoker);
    }
}

