/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition;

import com.google.gson.Gson;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.FullServiceDefinition;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;
import org.apache.dubbo.metadata.definition.model.ServiceDefinition;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;
import org.apache.dubbo.metadata.definition.util.ClassUtils;

public final class ServiceDefinitionBuilder {
    public static ServiceDefinition build(Class<?> interfaceClass) {
        ServiceDefinition sd = new ServiceDefinition();
        ServiceDefinitionBuilder.build(sd, interfaceClass);
        return sd;
    }

    public static FullServiceDefinition buildFullDefinition(Class<?> interfaceClass) {
        FullServiceDefinition sd = new FullServiceDefinition();
        ServiceDefinitionBuilder.build(sd, interfaceClass);
        return sd;
    }

    public static FullServiceDefinition buildFullDefinition(Class<?> interfaceClass, Map<String, String> params) {
        FullServiceDefinition sd = new FullServiceDefinition();
        ServiceDefinitionBuilder.build(sd, interfaceClass);
        sd.setParameters(params);
        return sd;
    }

    public static <T extends ServiceDefinition> void build(T sd, Class<?> interfaceClass) {
        sd.setCanonicalName(interfaceClass.getCanonicalName());
        sd.setCodeSource(ClassUtils.getCodeSource(interfaceClass));
        TypeDefinitionBuilder builder = new TypeDefinitionBuilder();
        List<Method> methods = ClassUtils.getPublicNonStaticMethods(interfaceClass);
        for (Method method : methods) {
            MethodDefinition md = new MethodDefinition();
            md.setName(method.getName());
            Class<?>[] paramTypes = method.getParameterTypes();
            Type[] genericParamTypes = method.getGenericParameterTypes();
            String[] parameterTypes = new String[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                TypeDefinition td = builder.build(genericParamTypes[i], paramTypes[i]);
                parameterTypes[i] = td.getType();
            }
            md.setParameterTypes(parameterTypes);
            TypeDefinition td = builder.build(method.getGenericReturnType(), method.getReturnType());
            md.setReturnType(td.getType());
            sd.getMethods().add(md);
        }
        sd.setTypes(builder.getTypeDefinitions());
    }

    public static String schema(Class<?> clazz) {
        ServiceDefinition sd = ServiceDefinitionBuilder.build(clazz);
        Gson gson = new Gson();
        return gson.toJson(sd);
    }

    private ServiceDefinitionBuilder() {
    }
}

