/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.etcd;

import com.google.protobuf.ByteString;
import io.etcd.jetcd.api.Event;
import io.etcd.jetcd.api.WatchCancelRequest;
import io.etcd.jetcd.api.WatchCreateRequest;
import io.etcd.jetcd.api.WatchGrpc;
import io.etcd.jetcd.api.WatchRequest;
import io.etcd.jetcd.api.WatchResponse;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.etcd.jetcd.JEtcdClient;

public class EtcdDynamicConfiguration
implements DynamicConfiguration {
    private String rootPath;
    private final JEtcdClient etcdClient;
    private final ConcurrentMap<ConfigurationListener, EtcdConfigWatcher> watchListenerMap;

    EtcdDynamicConfiguration(URL url) {
        this.rootPath = "/" + url.getParameter("config.namespace", "dubbo") + "/config";
        this.etcdClient = new JEtcdClient(url);
        this.etcdClient.addStateListener(state -> {
            if (state == 1) {
                try {
                    this.recover();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.watchListenerMap = new ConcurrentHashMap<ConfigurationListener, EtcdConfigWatcher>();
    }

    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
        if (this.watchListenerMap.get(listener) == null) {
            EtcdConfigWatcher watcher = new EtcdConfigWatcher(key, group, listener);
            this.watchListenerMap.put(listener, watcher);
            watcher.watch();
        }
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
        EtcdConfigWatcher watcher = (EtcdConfigWatcher)this.watchListenerMap.get(listener);
        watcher.cancelWatch();
    }

    @Override
    public String getConfig(String key, String group, long timeout) throws IllegalStateException {
        return (String)this.getInternalProperty(this.convertKey(group, key));
    }

    @Override
    public Object getInternalProperty(String key) {
        return this.etcdClient.getKVValue(key);
    }

    private String buildPath(String group) {
        String actualGroup = StringUtils.isEmpty(group) ? "dubbo" : group;
        return this.rootPath + "/" + actualGroup;
    }

    private String convertKey(String group, String key) {
        return this.buildPath(group) + "/" + key;
    }

    private void recover() {
        for (EtcdConfigWatcher watcher : this.watchListenerMap.values()) {
            watcher.watch();
        }
    }

    public class EtcdConfigWatcher
    implements StreamObserver<WatchResponse> {
        private ConfigurationListener listener;
        protected WatchGrpc.WatchStub watchStub;
        private StreamObserver<WatchRequest> observer;
        protected long watchId;
        private ManagedChannel channel;
        private final String key;
        private final String group;
        private String normalizedKey;

        public EtcdConfigWatcher(String key, String group, ConfigurationListener listener) {
            this.key = key;
            this.group = group;
            this.normalizedKey = EtcdDynamicConfiguration.this.convertKey(group, key);
            this.listener = listener;
            this.channel = EtcdDynamicConfiguration.this.etcdClient.getChannel();
        }

        public void onNext(WatchResponse watchResponse) {
            this.watchId = watchResponse.getWatchId();
            for (Event etcdEvent : watchResponse.getEventsList()) {
                ConfigChangeType type = ConfigChangeType.MODIFIED;
                if (etcdEvent.getType() == Event.EventType.DELETE) {
                    type = ConfigChangeType.DELETED;
                }
                ConfigChangedEvent event = new ConfigChangedEvent(this.key, this.group, etcdEvent.getKv().getValue().toString(StandardCharsets.UTF_8), type);
                this.listener.process(event);
            }
        }

        public void onError(Throwable throwable) {
        }

        public void onCompleted() {
        }

        public long getWatchId() {
            return this.watchId;
        }

        private void watch() {
            this.watchStub = WatchGrpc.newStub((Channel)this.channel);
            this.observer = this.watchStub.watch((StreamObserver)this);
            WatchCreateRequest.Builder builder = WatchCreateRequest.newBuilder().setKey(ByteString.copyFromUtf8((String)this.normalizedKey)).setProgressNotify(true);
            WatchRequest req = WatchRequest.newBuilder().setCreateRequest(builder).build();
            this.observer.onNext((Object)req);
        }

        private void cancelWatch() {
            WatchCancelRequest watchCancelRequest = WatchCancelRequest.newBuilder().setWatchId(this.watchId).build();
            WatchRequest cancelRequest = WatchRequest.newBuilder().setCancelRequest(watchCancelRequest).build();
            this.observer.onNext((Object)cancelRequest);
        }
    }
}

