/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.schema;

import com.alibaba.spring.util.BeanRegistrar;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractServiceConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.DubboConfigAliasPostProcessor;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DubboBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Logger logger = LoggerFactory.getLogger(DubboBeanDefinitionParser.class);
    private static final Pattern GROUP_AND_VERION = Pattern.compile("^[\\-.0-9_a-zA-Z]+(\\:[\\-.0-9_a-zA-Z]+)?$");
    private static final String ONRETURN = "onreturn";
    private static final String ONTHROW = "onthrow";
    private static final String ONINVOKE = "oninvoke";
    private static final String METHOD = "Method";
    private final Class<?> beanClass;
    private final boolean required;

    public DubboBeanDefinitionParser(Class<?> beanClass, boolean required) {
        this.beanClass = beanClass;
        this.required = required;
    }

    /*
     * WARNING - void declaration
     */
    private static BeanDefinition parse(Element element, ParserContext parserContext, Class<?> beanClass, boolean required) {
        String name;
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(beanClass);
        beanDefinition.setLazyInit(false);
        String id = element.getAttribute("id");
        if (StringUtils.isEmpty(id) && required) {
            void var6_11;
            void var6_9;
            String string = element.getAttribute("name");
            if (StringUtils.isEmpty(string)) {
                if (ProtocolConfig.class.equals(beanClass)) {
                    String string2 = "dubbo";
                } else {
                    String string3 = element.getAttribute("interface");
                }
            }
            if (StringUtils.isEmpty((String)var6_9)) {
                String string4 = beanClass.getName();
            }
            id = var6_11;
            int counter = 2;
            while (parserContext.getRegistry().containsBeanDefinition(id)) {
                id = (String)var6_11 + counter++;
            }
        }
        if (StringUtils.isNotEmpty(id)) {
            if (parserContext.getRegistry().containsBeanDefinition(id)) {
                throw new IllegalStateException("Duplicate spring bean id " + id);
            }
            parserContext.getRegistry().registerBeanDefinition(id, beanDefinition);
            beanDefinition.getPropertyValues().addPropertyValue("id", id);
        }
        if (ProtocolConfig.class.equals(beanClass)) {
            for (String name2 : parserContext.getRegistry().getBeanDefinitionNames()) {
                Object value;
                BeanDefinition definition = parserContext.getRegistry().getBeanDefinition(name2);
                PropertyValue property = definition.getPropertyValues().getPropertyValue("protocol");
                if (property == null || !((value = property.getValue()) instanceof ProtocolConfig) || !id.equals(((ProtocolConfig)value).getName())) continue;
                definition.getPropertyValues().addPropertyValue("protocol", new RuntimeBeanReference(id));
            }
        } else if (ServiceBean.class.equals(beanClass)) {
            String string = element.getAttribute("class");
            if (StringUtils.isNotEmpty(string)) {
                RootBeanDefinition classDefinition = new RootBeanDefinition();
                classDefinition.setBeanClass(ReflectUtils.forName(string));
                classDefinition.setLazyInit(false);
                DubboBeanDefinitionParser.parseProperties(element.getChildNodes(), classDefinition);
                beanDefinition.getPropertyValues().addPropertyValue("ref", new BeanDefinitionHolder(classDefinition, id + "Impl"));
            }
        } else if (ProviderConfig.class.equals(beanClass)) {
            DubboBeanDefinitionParser.parseNested(element, parserContext, ServiceBean.class, true, "service", "provider", id, beanDefinition);
        } else if (ConsumerConfig.class.equals(beanClass)) {
            DubboBeanDefinitionParser.parseNested(element, parserContext, ReferenceBean.class, false, "reference", "consumer", id, beanDefinition);
        }
        HashSet<String> hashSet = new HashSet<String>();
        ManagedMap parameters = null;
        for (Method setter : beanClass.getMethods()) {
            Object reference;
            name = setter.getName();
            if (name.length() <= 3 || !name.startsWith("set") || !Modifier.isPublic(setter.getModifiers()) || setter.getParameterTypes().length != 1) continue;
            Class<?> type = setter.getParameterTypes()[0];
            String beanProperty = name.substring(3, 4).toLowerCase() + name.substring(4);
            String property = StringUtils.camelToSplitName(beanProperty, "-");
            hashSet.add(property);
            Method getter = null;
            try {
                getter = beanClass.getMethod("get" + name.substring(3), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    getter = beanClass.getMethod("is" + name.substring(3), new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (getter == null || !Modifier.isPublic(getter.getModifiers()) || !type.equals(getter.getReturnType())) continue;
            if ("parameters".equals(property)) {
                parameters = DubboBeanDefinitionParser.parseParameters(element.getChildNodes(), beanDefinition);
                continue;
            }
            if ("methods".equals(property)) {
                DubboBeanDefinitionParser.parseMethods(id, element.getChildNodes(), beanDefinition, parserContext);
                continue;
            }
            if ("arguments".equals(property)) {
                DubboBeanDefinitionParser.parseArguments(id, element.getChildNodes(), beanDefinition, parserContext);
                continue;
            }
            String value = element.getAttribute(property);
            if (value == null || (value = value.trim()).length() <= 0) continue;
            if ("registry".equals(property) && "N/A".equalsIgnoreCase(value)) {
                RegistryConfig registryConfig = new RegistryConfig();
                registryConfig.setAddress("N/A");
                beanDefinition.getPropertyValues().addPropertyValue(beanProperty, registryConfig);
                continue;
            }
            if ("provider".equals(property) || "registry".equals(property) || "protocol".equals(property) && AbstractServiceConfig.class.isAssignableFrom(beanClass)) {
                beanDefinition.getPropertyValues().addPropertyValue(beanProperty + "Ids", value);
                continue;
            }
            if (DubboBeanDefinitionParser.isPrimitive(type)) {
                if ("async".equals(property) && "false".equals(value) || "timeout".equals(property) && "0".equals(value) || "delay".equals(property) && "0".equals(value) || "version".equals(property) && "0.0.0".equals(value) || "stat".equals(property) && "-1".equals(value) || "reliable".equals(property) && "false".equals(value)) {
                    value = null;
                }
                reference = value;
            } else if (ONRETURN.equals(property) || ONTHROW.equals(property) || ONINVOKE.equals(property)) {
                int index = value.lastIndexOf(".");
                String ref = value.substring(0, index);
                String method = value.substring(index + 1);
                reference = new RuntimeBeanReference(ref);
                beanDefinition.getPropertyValues().addPropertyValue(property + METHOD, method);
            } else {
                BeanDefinition refBean;
                if ("ref".equals(property) && parserContext.getRegistry().containsBeanDefinition(value) && !(refBean = parserContext.getRegistry().getBeanDefinition(value)).isSingleton()) {
                    throw new IllegalStateException("The exported service ref " + value + " must be singleton! Please set the " + value + " bean scope to singleton, eg: <bean id=\"" + value + "\" scope=\"singleton\" ...>");
                }
                reference = new RuntimeBeanReference(value);
            }
            beanDefinition.getPropertyValues().addPropertyValue(beanProperty, reference);
        }
        NamedNodeMap attributes = element.getAttributes();
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = attributes.item(i);
            name = node.getLocalName();
            if (hashSet.contains(name)) continue;
            if (parameters == null) {
                parameters = new ManagedMap();
            }
            String value = node.getNodeValue();
            parameters.put(name, new TypedStringValue(value, String.class));
        }
        if (parameters != null) {
            beanDefinition.getPropertyValues().addPropertyValue("parameters", parameters);
        }
        return beanDefinition;
    }

    private static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == String.class || cls == Date.class || cls == Class.class;
    }

    private static void parseNested(Element element, ParserContext parserContext, Class<?> beanClass, boolean required, String tag, String property, String ref, BeanDefinition beanDefinition) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList == null) {
            return;
        }
        boolean first = true;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            BeanDefinition subDefinition;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !tag.equals(node.getNodeName()) && !tag.equals(node.getLocalName())) continue;
            if (first) {
                first = false;
                String isDefault = element.getAttribute("default");
                if (StringUtils.isEmpty(isDefault)) {
                    beanDefinition.getPropertyValues().addPropertyValue("default", "false");
                }
            }
            if ((subDefinition = DubboBeanDefinitionParser.parse((Element)node, parserContext, beanClass, required)) == null || !StringUtils.isNotEmpty(ref)) continue;
            subDefinition.getPropertyValues().addPropertyValue(property, new RuntimeBeanReference(ref));
        }
    }

    private static void parseProperties(NodeList nodeList, RootBeanDefinition beanDefinition) {
        if (nodeList == null) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String name;
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !"property".equals((element = (Element)nodeList.item(i)).getNodeName()) && !"property".equals(element.getLocalName()) || !StringUtils.isNotEmpty(name = element.getAttribute("name"))) continue;
            String value = element.getAttribute("value");
            String ref = element.getAttribute("ref");
            if (StringUtils.isNotEmpty(value)) {
                beanDefinition.getPropertyValues().addPropertyValue(name, value);
                continue;
            }
            if (StringUtils.isNotEmpty(ref)) {
                beanDefinition.getPropertyValues().addPropertyValue(name, new RuntimeBeanReference(ref));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported <property name=\"" + name + "\"> sub tag, Only supported <property name=\"" + name + "\" ref=\"...\" /> or <property name=\"" + name + "\" value=\"...\" />");
        }
    }

    private static ManagedMap parseParameters(NodeList nodeList, RootBeanDefinition beanDefinition) {
        if (nodeList == null) {
            return null;
        }
        ManagedMap<String, TypedStringValue> parameters = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !"parameter".equals((element = (Element)nodeList.item(i)).getNodeName()) && !"parameter".equals(element.getLocalName())) continue;
            if (parameters == null) {
                parameters = new ManagedMap<String, TypedStringValue>();
            }
            String key = element.getAttribute("key");
            String value = element.getAttribute("value");
            boolean hide = "true".equals(element.getAttribute("hide"));
            if (hide) {
                key = "." + key;
            }
            parameters.put(key, new TypedStringValue(value, String.class));
        }
        return parameters;
    }

    private static void parseMethods(String id, NodeList nodeList, RootBeanDefinition beanDefinition, ParserContext parserContext) {
        if (nodeList == null) {
            return;
        }
        ManagedList<BeanDefinitionHolder> methods = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !"method".equals((element = (Element)nodeList.item(i)).getNodeName()) && !"method".equals(element.getLocalName())) continue;
            String methodName = element.getAttribute("name");
            if (StringUtils.isEmpty(methodName)) {
                throw new IllegalStateException("<dubbo:method> name attribute == null");
            }
            if (methods == null) {
                methods = new ManagedList<BeanDefinitionHolder>();
            }
            BeanDefinition methodBeanDefinition = DubboBeanDefinitionParser.parse(element, parserContext, MethodConfig.class, false);
            String name = id + "." + methodName;
            BeanDefinitionHolder methodBeanDefinitionHolder = new BeanDefinitionHolder(methodBeanDefinition, name);
            methods.add(methodBeanDefinitionHolder);
        }
        if (methods != null) {
            beanDefinition.getPropertyValues().addPropertyValue("methods", methods);
        }
    }

    private static void parseArguments(String id, NodeList nodeList, RootBeanDefinition beanDefinition, ParserContext parserContext) {
        if (nodeList == null) {
            return;
        }
        ManagedList<BeanDefinitionHolder> arguments = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (!(nodeList.item(i) instanceof Element) || !"argument".equals((element = (Element)nodeList.item(i)).getNodeName()) && !"argument".equals(element.getLocalName())) continue;
            String argumentIndex = element.getAttribute("index");
            if (arguments == null) {
                arguments = new ManagedList<BeanDefinitionHolder>();
            }
            BeanDefinition argumentBeanDefinition = DubboBeanDefinitionParser.parse(element, parserContext, ArgumentConfig.class, false);
            String name = id + "." + argumentIndex;
            BeanDefinitionHolder argumentBeanDefinitionHolder = new BeanDefinitionHolder(argumentBeanDefinition, name);
            arguments.add(argumentBeanDefinitionHolder);
        }
        if (arguments != null) {
            beanDefinition.getPropertyValues().addPropertyValue("arguments", arguments);
        }
    }

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.registerDubboConfigAliasPostProcessor(parserContext.getRegistry());
        return DubboBeanDefinitionParser.parse(element, parserContext, this.beanClass, this.required);
    }

    private void registerDubboConfigAliasPostProcessor(BeanDefinitionRegistry registry) {
        BeanRegistrar.registerInfrastructureBean(registry, "dubboConfigAliasPostProcessor", DubboConfigAliasPostProcessor.class);
    }
}

