/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context.annotation;

import com.alibaba.spring.util.BeanRegistrar;
import com.alibaba.spring.util.PropertySourcesUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.spring.beans.factory.annotation.DubboConfigBindingBeanPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.config.ConfigurableSourceBeanMetadataElement;
import org.apache.dubbo.config.spring.context.annotation.EnableDubboConfigBinding;
import org.apache.dubbo.config.spring.context.config.NamePropertyDefaultValueDubboConfigBeanCustomizer;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Deprecated
public class DubboConfigBindingRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware,
ConfigurableSourceBeanMetadataElement {
    private final Log log = LogFactory.getLog(this.getClass());
    private ConfigurableEnvironment environment;

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap(importingClassMetadata.getAnnotationAttributes(EnableDubboConfigBinding.class.getName()));
        this.registerBeanDefinitions(attributes, registry);
    }

    protected void registerBeanDefinitions(AnnotationAttributes attributes, BeanDefinitionRegistry registry) {
        String prefix = this.environment.resolvePlaceholders(attributes.getString("prefix"));
        Class configClass = attributes.getClass("type");
        boolean multiple = attributes.getBoolean("multiple");
        this.registerDubboConfigBeans(prefix, configClass, multiple, registry);
    }

    private void registerDubboConfigBeans(String prefix, Class<? extends AbstractConfig> configClass, boolean multiple, BeanDefinitionRegistry registry) {
        Map<String, Object> properties = PropertySourcesUtils.getSubProperties(this.environment.getPropertySources(), prefix);
        if (CollectionUtils.isEmpty(properties)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("There is no property for binding to dubbo config class [" + configClass.getName() + "] within prefix [" + prefix + "]");
            }
            return;
        }
        Set<String> beanNames = multiple ? this.resolveMultipleBeanNames(properties) : Collections.singleton(this.resolveSingleBeanName(properties, configClass, registry));
        for (String beanName : beanNames) {
            this.registerDubboConfigBean(beanName, configClass, registry);
            this.registerDubboConfigBindingBeanPostProcessor(prefix, beanName, multiple, registry);
        }
        this.registerDubboConfigBeanCustomizers(registry);
    }

    private void registerDubboConfigBean(String beanName, Class<? extends AbstractConfig> configClass, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(configClass);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        this.setSource(beanDefinition);
        registry.registerBeanDefinition(beanName, beanDefinition);
        if (this.log.isInfoEnabled()) {
            this.log.info("The dubbo config bean definition [name : " + beanName + ", class : " + configClass.getName() + "] has been registered.");
        }
    }

    private void registerDubboConfigBindingBeanPostProcessor(String prefix, String beanName, boolean multiple, BeanDefinitionRegistry registry) {
        Class<DubboConfigBindingBeanPostProcessor> processorClass = DubboConfigBindingBeanPostProcessor.class;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(processorClass);
        String actualPrefix = multiple ? PropertySourcesUtils.normalizePrefix(prefix) + beanName : prefix;
        builder.addConstructorArgValue(actualPrefix).addConstructorArgValue(beanName);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        beanDefinition.setRole(2);
        BeanDefinitionReaderUtils.registerWithGeneratedName(beanDefinition, registry);
        if (this.log.isInfoEnabled()) {
            this.log.info("The BeanPostProcessor bean definition [" + processorClass.getName() + "] for dubbo config bean [name : " + beanName + "] has been registered.");
        }
    }

    private void registerDubboConfigBeanCustomizers(BeanDefinitionRegistry registry) {
        BeanRegistrar.registerInfrastructureBean(registry, "namePropertyDefaultValueDubboConfigBeanCustomizer", NamePropertyDefaultValueDubboConfigBeanCustomizer.class);
    }

    @Override
    public void setEnvironment(Environment environment) {
        Assert.isInstanceOf(ConfigurableEnvironment.class, environment);
        this.environment = (ConfigurableEnvironment)environment;
    }

    private Set<String> resolveMultipleBeanNames(Map<String, Object> properties) {
        LinkedHashSet<String> beanNames = new LinkedHashSet<String>();
        for (String propertyName : properties.keySet()) {
            int index = propertyName.indexOf(".");
            if (index <= 0) continue;
            String beanName = propertyName.substring(0, index);
            beanNames.add(beanName);
        }
        return beanNames;
    }

    private String resolveSingleBeanName(Map<String, Object> properties, Class<? extends AbstractConfig> configClass, BeanDefinitionRegistry registry) {
        String beanName = (String)properties.get("id");
        if (!StringUtils.hasText(beanName)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(configClass);
            beanName = BeanDefinitionReaderUtils.generateBeanName(builder.getRawBeanDefinition(), registry);
        }
        return beanName;
    }
}

