/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.ConfigCenterBean;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.apache.dubbo.config.support.Parameter;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReferenceBean<T>
extends ReferenceConfig<T>
implements FactoryBean,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final long serialVersionUID = 213195494150089726L;
    private transient ApplicationContext applicationContext;

    public ReferenceBean() {
    }

    public ReferenceBean(Reference reference) {
        super(reference);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext(applicationContext);
    }

    public Object getObject() {
        return this.get();
    }

    @Override
    public Class<?> getObjectType() {
        return this.getInterfaceClass();
    }

    @Override
    @Parameter(excluded=true)
    public boolean isSingleton() {
        return true;
    }

    private void prepareDubboConfigBeans() {
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ApplicationConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ModuleConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, RegistryConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ProtocolConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, MonitorConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ProviderConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ConsumerConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, ConfigCenterBean.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, MetadataReportConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, MetricsConfig.class);
        BeanFactoryUtils.beansOfTypeIncludingAncestors(this.applicationContext, SslConfig.class);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.prepareDubboConfigBeans();
        if (this.init == null) {
            this.init = false;
        }
        if (this.shouldInit()) {
            this.getObject();
        }
    }

    @Override
    public void destroy() {
    }
}

