/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.gson;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.dubbo.common.serialize.ObjectOutput;

public class GsonJsonObjectOutput
implements ObjectOutput {
    private final PrintWriter writer;
    private Gson gson = new Gson();

    public GsonJsonObjectOutput(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public GsonJsonObjectOutput(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    @Override
    public void writeBool(boolean v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeObject(Float.valueOf(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeUTF(String v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeBytes(byte[] b) throws IOException {
        this.writer.println(new String(b));
    }

    @Override
    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.writer.println(new String(b, off, len));
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        char[] json = this.gson.toJson(obj).toCharArray();
        this.writer.write(json, 0, json.length);
        this.writer.println();
        this.writer.flush();
        json = null;
    }

    @Override
    public void flushBuffer() throws IOException {
        this.writer.flush();
    }
}

