/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.dubbo.common.config.AbstractPrefixConfiguration;
import org.apache.dubbo.common.config.OrderedPropertiesProvider;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.ConfigUtils;

public class PropertiesConfiguration
extends AbstractPrefixConfiguration {
    public PropertiesConfiguration(String prefix, String id) {
        super(prefix, id);
        ExtensionLoader<OrderedPropertiesProvider> propertiesProviderExtensionLoader = ExtensionLoader.getExtensionLoader(OrderedPropertiesProvider.class);
        Set<String> propertiesProviderNames = propertiesProviderExtensionLoader.getSupportedExtensions();
        if (propertiesProviderNames == null || propertiesProviderNames.isEmpty()) {
            return;
        }
        ArrayList<OrderedPropertiesProvider> orderedPropertiesProviders = new ArrayList<OrderedPropertiesProvider>();
        for (String propertiesProviderName : propertiesProviderNames) {
            orderedPropertiesProviders.add(propertiesProviderExtensionLoader.getExtension(propertiesProviderName));
        }
        orderedPropertiesProviders.sort((a, b) -> b.priority() - a.priority());
        Properties properties = ConfigUtils.getProperties();
        for (OrderedPropertiesProvider orderedPropertiesProvider : orderedPropertiesProviders) {
            properties.putAll((Map<?, ?>)orderedPropertiesProvider.initProperties());
        }
        ConfigUtils.setProperties(properties);
    }

    public PropertiesConfiguration() {
        this(null, null);
    }

    @Override
    public Object getInternalProperty(String key) {
        return ConfigUtils.getProperty(key);
    }
}

