/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.spring.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public abstract class PropertySourcesUtils {
    public static Map<String, Object> getSubProperties(Iterable<PropertySource<?>> propertySources, String prefix) {
        MutablePropertySources mutablePropertySources = new MutablePropertySources();
        for (PropertySource<?> source : propertySources) {
            mutablePropertySources.addLast(source);
        }
        return PropertySourcesUtils.getSubProperties(mutablePropertySources, prefix);
    }

    public static Map<String, Object> getSubProperties(ConfigurableEnvironment environment, String prefix) {
        return PropertySourcesUtils.getSubProperties(environment.getPropertySources(), environment, prefix);
    }

    public static String normalizePrefix(String prefix) {
        return prefix.endsWith(".") ? prefix : prefix + ".";
    }

    public static Map<String, Object> getSubProperties(PropertySources propertySources, String prefix) {
        return PropertySourcesUtils.getSubProperties(propertySources, new PropertySourcesPropertyResolver(propertySources), prefix);
    }

    public static Map<String, Object> getSubProperties(PropertySources propertySources, PropertyResolver propertyResolver, String prefix) {
        LinkedHashMap<String, Object> subProperties = new LinkedHashMap<String, Object>();
        String normalizedPrefix = PropertySourcesUtils.normalizePrefix(prefix);
        for (PropertySource source : propertySources) {
            if (!(source instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)source).getPropertyNames()) {
                String subName;
                if (subProperties.containsKey(name) || !name.startsWith(normalizedPrefix) || subProperties.containsKey(subName = name.substring(normalizedPrefix.length()))) continue;
                Object value = source.getProperty(name);
                if (value instanceof String) {
                    value = propertyResolver.resolvePlaceholders((String)value);
                }
                subProperties.put(subName, value);
            }
        }
        return Collections.unmodifiableMap(subProperties);
    }
}

