#!/bin/bash

DB=sysbench
PORT=3306
CNT=100
SIZE=1000000
USER=root
PASSWORD=123456

while getopts ":h:P:c:d:e:u:p:s:" opt
do
    case $opt in
        h) HOST=$OPTARG;;
        P) PORT=$OPTARG;;
        d) DB=$OPTARG;;
        e) ENGINE=$OPTARG;;
        u) USER=$OPTARG;;
        p) PASSWORD=$OPTARG;;
        c)  CNT=$OPTARG;;
        s)  SIZE=$OPTARG;;
    esac
done

/home/automation/client/soft/sysbench-0.5/sysbench/sysbench --db-driver=mysql  --test=/home/automation/client/soft/sysbench-0.5/sysbench/tests/db/parallel_prepare.lua --oltp-test-mode=complex  --mysql-host=${HOST}  --mysql-db=${DB} --mysql-password=${PASSWORD} --max-time=7200  --max-requests=0  --mysql-user=${USER} --mysql-table-engine=innodb  --oltp-table-size=${SIZE}  --oltp-tables-count=${CNT} --rand-type=special --rand-spec-pct=100 --num-threads=60 prepare

if [ $? -ne 0 ];then
	echo "Data load failed!"
else
	echo "Data load success!"
fi
