#!/bin/bash

TMP_FILE=$1

echo "$TMP_FILE begin"
echo "THD   Transactions  TPS   Requests  RPS   RT"

cat $TMP_FILE | while read line
do
        STR=`echo ${line}| egrep "cat|distinct|order|index|nonindex|point|sum|simple|delete|mix"`
        if [ -n "$STR" ];then
                echo "$STR"
        fi
        STR=`echo ${line}| egrep "cat|Number of threads:"`
        if [ -n "$STR" ];then
                THD=`echo $STR | awk {'print $4'}`
                printf "$THD "
        fi
        STR=`echo ${line}| egrep "cat|transactions:"`
        if [ -n "$STR" ];then
                TPS=`echo $STR | awk {'print $2'}`
                printf "$TPS "
                TPS=`echo $STR | awk {'print $3'} | awk -F\( '{print $2}'`
                printf "$TPS "
        fi
        STR=`echo ${line}| egrep "cat|write requests:"`
        if [ -n "$STR" ];then
                RPS=`echo $STR | awk {'print $3'}`
                printf "$RPS "
                RPS=`echo $STR | awk {'print $4'} | awk -F\( '{print $2}'`
                printf "$RPS "
        fi
        STR=`echo ${line}| egrep "cat|approx."`
        if [ -n "$STR" ];then
                RT=`echo $STR | awk {'print $4'} | sed 's/[A-Za-z]//g'`
                printf "$RT\n"
        fi
done

