#!/bin/bash
#use: ./postgresqlInstall.sh ${conf} ${func} ${filePath}

conf=$1
func=$2
filePath=$3
isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
db_password=`grep "db_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
prefixdir=`grep "prefixdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
datadir=`grep "datadir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
waldir=`grep "waldir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shared_buffers=`grep "shared_buffers" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
version=`grep "version" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`


toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
depDir=${toolPath}/postgresqlDep
cnfPath=""
installLog=${toolPath}/postgresqlInstall.log
touch ${installLog}
chmod 666 ${installLog}

installDepPackage()
{
    mount ${isopath} ${tempDir}
    cd /etc/yum.repos.d
    if [ ! -d /etc/yum.repos.d/backup ];then
        mkdir /etc/yum.repos.d/backup
    fi
    mv *repo ./backup
    touch local.repo
    echo "[local]" >> local.repo
    echo "name=local" >> local.repo
    echo "baseurl=file://${tempDir}" >> local.repo
    echo "gpgcheck=0"  >> local.repo
 
   echo "enabled=1" >> local.repo
    yum -y install expect  net-tools gcc gcc-c++ automake zlib zlib-devel bzip2 bzip2-devel bzip2-libs readline readline-devel bison gmp gmp-devel mpfr mpfr-devel libmpc libmpc-devel
    sleep 2
    umount ${tempDir}
}


installCmake()
{
     local requiredver="3.5.2"
    which cmake
    if [ $? == 0 ];then
      local currentver=`cmake -version |grep "version"|awk '{print $NF}'`
      if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "cmake version match,cmake version is ${currentver}"
        return 0
      fi
    fi


    cd ${depDir}
    local cmaketar_name=`ls |grep -i cmake`
    local temp_cmakedir=${depDir}/tempcmake_src
    mkdir ${temp_cmakedir}
    tar -xzvf ${cmaketar_name} -C ${temp_cmakedir}
    cd ${temp_cmakedir}
    local cmakesrc_dir=`ls |grep -i cmake`
    cd ${cmakesrc_dir}
    ./bootstrap
    make
    make install
    sleep 2
    rm -rf ${temp_cmakedir}
    cd ${depDir}
    local currentver=`cmake -version |grep "version"|awk '{print $NF}'`
    if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "install cmake success,cmake version is ${currentver}"  >> ${installLog}
        echo "install cmake success,cmake version is ${currentver}"
    else
        echo "cmake version error,the min version need ${requiredver},current ver is ${currentver}" >> ${installLog}
        echo "cmake version error,the min version need ${requiredver},current ver is ${currentver}"
        exit 0
    fi


}


installGcc()
{
    local requiredver="7.3.0"
    local currentver=`gcc -dumpversion`
    if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "gcc match ,version:${currentver}"
        return 0
    fi

    cd ${depDir}
    local gcctar_name=`ls |grep -i gcc`
    local temp_gccdir=${depDir}/tempgcc_src
    mkdir ${temp_gccdir}
    tar xzvf ${gcctar_name} -C  ${temp_gccdir}
    cd ${temp_gccdir}
    local gccsrc_dir=`ls |grep -i gcc`
    cd ${gccsrc_dir}
    ./configure --prefix=/usr --mandir=/usr/share/man --infodir=/usr/share/info --enable-bootstrap --enable-shared --enable-threads=posix --enable-checking=release --with-system-zlib --enable-__cxa_atexit --disable-libunwind-exceptions --enable-gnu-unique-object --enable-linker-build-id --with-linker-hash-style=gnu --enable-languages=c,c++,objc,obj-c++,fortran,lto --enable-plugin --enable-initfini-array --disable-libgcj
    make -j 32
    make install
    sleep 2
    rm -rf ${temp_gccdir}
    cd ${depDir}
    local currentver=`gcc -dumpversion`
    if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "install gcc success,gcc version is ${currentver}"  >> ${installLog}
        echo "install gcc success,gcc version is ${currentver}"
    else
        echo "gcc version error,the min version need ${requiredver},current ver is ${currentver}" >> ${installLog}
        echo "gcc version error,the min version need ${requiredver},current ver is ${currentver}"
        exit 0
    fi
}



installPgSrc()
{
    cd ${toolPath}
    local temp_pgdir=${depDir}/temppg_src
    mkdir ${temp_pgdir}
    tar -xzvf ${filePath} -C ${temp_pgdir}
    cd ${temp_pgdir}
    local pgsrc_dir=`ls |grep -i postgresql`
    cd ${pgsrc_dir}
    
    chmod +x configure
    ./configure prefix=${prefixdir}

    make -j 32
    make install
    sleep 2
    rm -rf ${temp_pgdir}
    cd ${depDir}
    if [ -e ${prefixdir}/bin/initdb ];then
        echo "install postgresql success from source code" >> ${installLog}
        echo "install postgresql success"
    else
        echo "install postgresql failed from source code"  >> ${installLog}
        echo "install postgresql failed"
        exit 0
    fi

}

installPgRpm()
{
    rpm -ivh ${filePath}
    prefixdir="/usr/local/pgsql"
    if [ -e ${prefixdir}/bin/initdb ];then
        echo "install postgresql success from rpm package" >> ${installLog}
        echo "install postgresql success"
    else
        echo "install postgresql failed from rpm package"  >> ${installLog}
        echo "install postgresql failed"
        exit 0
    fi
    sleep 2

}

initEnv()
{
   groupadd  postgres
   useradd -g postgres postgres
   chown -R postgres:postgres ${datadir}
   chown -R postgres:postgres ${waldir}
   systemctl stop firewalld
   systemctl disable firewalld
   sed -i 's/SELINUX=enforcing/SELINUX=disable/g' /etc/sysconfig/selinux

}

startPg()
{
    su - postgres <<-EOF
    cd ${prefixdir}/bin
    ./pg_ctl -D ${datadir} -l ${waldir}/pglog start
EOF

    line=`ps -ef |grep "postgres:" |grep -v "grep"|wc -l`
    count=1
    while [ ${count} -le 5 ] && [ ${line} -le 5 ]
    do
        sleep 5
        line=`ps -ef |grep "postgres:" |grep -v "grep"|wc -l`
        count=`expr ${count} + 1`
    done

    if [ ${count} -gt 5 ];then
        echo "postgresql start failed" >> ${installLog}
        echo "postgresql start failed"
        exit  0
    else
        sleep 5
        echo "postgresql start success" >> ${installLog}
        echo "postgresql start success"
    fi

    
}

stopPg()
{
    su - postgres <<-EOF
    cd ${prefixdir}/bin
    ./pg_ctl -D ${datadir} -l ${waldir}/pglog stop
EOF
  
   local line=`ps -ef |grep "postgres:" |grep -v "grep"|wc -l`
   local count=1
    while [ ${count} -le 5 ] && [ ${line} -gt 0 ]
    do
        sleep 5
        line=`ps -ef |grep "postgres:" |grep -v "grep"|wc -l`
        count=`expr ${count} + 1`
    done

    if [ ${count} -gt 5 ];then
        echo "postgresql stop failed" >> ${installLog}
        echo "postgresql stop failed"
        exit  0
    else
        sleep 5
        echo "postgresql stop success" >> ${installLog}
        echo "postgresql stop success"
    fi
    sleep 2

    

}

initPg()
{

    su - postgres <<-EOF
    cd ${prefixdir}/bin
    ./initdb -D ${datadir} -X ${waldir}
EOF

    startPg
    cd ${prefixdir}/bin
    ./psql -c "alter user postgres with password '${db_password}'" -U postgres -h 127.0.0.1
}

createCnf()
{
    cnfPath=${datadir}/postgresql.conf
    touch ${cnfPath}
    sed -i 's/^max_wal_size/#&/' ${cnfPath}
    sed -i 's/^min_wal_size/#&/' ${cnfPath}
    sed -i 's/^shared_buffer/#&/' ${cnfPath}
    sed -i 's/^max_connections/#&/' ${cnfPath}
    echo "shared_buffers=${shared_buffers}" >> ${cnfPath}
    cat >> ${cnfPath} << EOF
listen_addresses='*'
bgwriter_delay=10ms
bgwriter_lru_maxpages=800
max_wal_size=20GB
min_wal_size=1GB
checkpoint_timeout=60min
full_page_writes=off
max_files_per_process=100000
max_prepared_transactions=2048
work_mem=1GB
log_min_messages=FATAL
synchronous_commit=on
fsync=on
maintenance_work_mem=2GB
vacuum_cost_limit=10000
autovacuum=on
autovacuum_max_workers=5
autovacuum_vacuum_scale_factor=0.002
autovacuum_analyze_scale_factor=0.001

EOF

}

rpmBuild()
{
     mkdir -p ${tempDir}/rpmbuild/{BUILD,RPMS,SOURCES,SPECS,SRPMS}
    CPUS=`cat /proc/cpuinfo |grep process |wc -l`
    filename=`echo ${filePath} | awk -F '/' '{print $NF}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    cd ${toolPath}
    cp ${filePath} ${tempDir}/rpmbuild/SOURCES
    
    echo """name:postgresql
Version:${version}
Release:1.el7
License: PostgreSQL
URL:http://www.postgresql.org/
Group: applications/database
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Packager: tsdbtool
Autoreq: no
Source: ${filename}
prefix: /usr/local/pgsql
Summary: The programs needed to create and run a PostgreSQL server
%description
PostgreSQL is an advanced Object-Relational database management
system (DBMS). The postgresql-server package contains the programs
needed to create and run a PostgreSQL server, which will in turn
allow you to create and maintain PostgreSQL databases.
%define POSTGRESQL_USER postgres
%define POSTGRESQL_GROUP postgres
%define _topdir ${tempDir}/rpmbuild
%define __os_install_post %{nil}
%define __debug_install_post %{_rpmconfigdir}/find-debuginfo.sh %{?_find_debuginfo_opts} "%{_builddir}/%{?buildsubdir}" %{nil}

%prep
%setup -q -n %{name}-%{version}
%build

./configure -prefix=%{prefix}

make -j${CPUS}
%install
make DESTDIR=\$RPM_BUILD_ROOT install
cp /usr/lib64/libatomic.so.1.2.0 \$RPM_BUILD_ROOT/usr/local/pgsql/lib
cp /usr/lib64/libstdc++.so.6.0.24 \$RPM_BUILD_ROOT/usr/local/pgsql/lib

%clean
rm -rf \$RPM_BUILD_ROOT
rm -rf \$RPM_BUILD_DIR/*
%files
%defattr(-, %{POSTGRESQL_USER}, %{POSTGRESQL_GROUP})
%attr(755, %{POSTGRESQL_USER}, %{POSTGRESQL_GROUP}) %{prefix}/*

%pre
if ! id %{POSTGRESQL_USER} > /dev/null 2>&1;then
    groupadd postgres
    useradd -g postgres postgres
fi

%post
if [ ! -f /usr/lib64/libatomic.so.1 ];then
        cp -f /usr/local/pgsql/lib/libatomic.so.1.2.0 /usr/lib64/
        ln -s /usr/lib64/libatomic.so.1.2.0  /usr/lib64/libatomic.so.1
else
        ver1=\`ls -l /usr/lib64/libatomic.so.1|awk -F'.' '{print \"\"\$6\".\"\$7\".\"\$8\"\"}'\`
        ver11=\`echo -e \"\${ver1}\\n1.1.99\"|sort -V|tail -1\`
        if [ \"\${ver11}\" = \"1.1.99\" ];then
                cp -f /usr/local/pgsql/lib/libatomic.so.1.2.0 /usr/lib64/
                rm -f /usr/lib64/libatomic.so.1
                ln -s /usr/lib64/libatomic.so.1.2.0  /usr/lib64/libatomic.so.1
        fi
fi
if [ ! -f /usr/lib64/libstdc++.so.6 ];then
        cp -f /usr/local/pgsql/lib/libstdc++.so.6.0.24 /usr/lib64/
        ln -s /usr/lib64/libstdc++.so.6.0.24  /usr/lib64/libstdc++.so.6
else
        ver2=\`ls -l /usr/lib64/libstdc++.so.6|awk -F'.' '{print \"\"\$6\".\"\$7\".\"\$8\"\"}'\`
        ver22=\`echo -e \"\${ver2}\\n6.0.23\"|sort -V|tail -1\`
        if [ \"\${ver22}\" = \"6.0.23\" ];then
                cp -f /usr/local/pgsql/lib/libstdc++.so.6.0.24 /usr/lib64/
                rm -f /usr/lib64/libstdc++.so.6
                ln -s /usr/lib64/libstdc++.so.6.0.24  /usr/lib64/libstdc++.so.6
        fi
fi

%postun
rm -rf %{prefix}
userdel -r %{POSTGRESQL_USER} >/dev/null 2>&1

%changelog""" >  ${tempDir}/rpmbuild/SPECS/mysql.spec
       echo "begin to build rpm,it will takes about 30 min"
        rpmbuild -bb  ${tempDir}/rpmbuild/SPECS/mysql.spec > /tmp/rpm.log 2>&1
        if [ $? -eq 0 ];then
                echo "compiler success"
        else
                echo "compiler failed"
                tail -10 /tmp/rpm.log
                exit 1
        fi
        cp ${tempDir}/rpmbuild/RPMS/aarch64/* ${toolPath}

}

main()
{

    rm -rf ${installLog}
    rm -rf ${tempDir}
    mkdir ${tempDir}
    if [ ${func} == "sourceinstall" ]; then
        installDepPackage
        installCmake
        installGcc
        installPgSrc
        initEnv
        initPg
        createCnf
        stopPg
        startPg

    fi
    if [ ${func} == "rpminstall" ]; then

        installPgRpm
        initEnv
        initPg
        createCnf
        stopPg
        startPg
    fi
    if [ ${func} == "compile" ];then
        installDepPackage
        installCmake
        installGcc
        rpmBuild
    fi

}

main
echo "-------success-------"
echo "postgresqlInstall.sh complete!!" >> ${installLog}









