#!/bin/bash
# use: mysqlCheck conf fileType filePath
conf=$1
fileType=$2
filePath=$3

echo ${conf} ${fileType} ${filePath}

isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
db_password=`grep "db_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
host=`grep "host" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
basedir=`grep "basedir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
datadir=`grep "datadir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
logdir=`grep "logdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
port=`grep "port" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
version=`grep "version" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
compile_flag=`grep "compile_flag" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`


toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
depDir=${toolPath}/mysqlDep

#8.0.16 8.0.17
#RPMMD5=(
#732de50db2505301956c68d737b71456
#7d61ed98364725ba76f9dbb63575b51e
#)
#src md5 value(8.0.16 8.0.17 8.0.18)
SRCMD5=(
6b9b8e7a26789935a491b4d7e53a7145 
7472a25d91973cbba5d8a8f176a3080b
b63e84d8ba2bbd6f82df12fc6dfb8d51
)
#version check
Ver=(
8.0.17
8.0.18
8.0.19
)


# if ok return 0 ,else return 1
md5Check()
{
    cd ${toolPath}
    local value=`md5sum ${filePath} | awk '{print $1}'`
    if [ ${fileType} == "rpmdir" ];then
#       if echo "${RPMMD5[@]}" | grep -w ${value} &>/dev/null; then
#           echo "package md5 check success"
           return 0
#       fi
    fi
   
    if [ ${fileType} == "sourcedir" ];then
       if echo "${SRCMD5[@]}" |grep -w ${value} &>/dev/null; then
           echo "package md5 check success"         
           return 0
       fi
    fi
    return 1

}

confCheck()
{
    if [ ! -e ${isopath} ];then
        echo "can not find iso:${isopath}"
        echo ${#isopath}
        return 1
    fi
    if [ ${fileType} == "sourcedir" ] && [ ! -d ${basedir} ];then
        echo  "can not find basedir:${basedir}"
        return 1
    fi
   
    if [ ! -d ${datadir} ];then
        echo "can not find datadir:${datadir}"
        return 1
    fi

    if [ ! -d ${logdir} ];then
        echo "can not find logdir:${logdir}"
        return 1
    fi
#    echo "lsof -i:${port}"
    local line=`netstat -anp |grep ":${port}" | wc -l`
    if [ ${line} -gt 0 ]; then
        echo "port:${port} is used!!"
        return 1
    fi
    echo "conf check success"
    return 0

}


packageCheck()
{
    cd ${depDir}
   #gcc package check
   local gccpackage=`ls |grep -i gcc | wc -l`
   if [ ${gccpackage} -ne 1 ];then
      echo "can not find gcc package in ${depDir}"
      return 1
   fi
  # cmake package check
   local cmakepackage=`ls |grep -i cmake | wc -l`
   if [ ${cmakepackage} -ne 1 ];then
      echo "can not find cmake package in ${depDir}"
      return 1
   fi
   
   echo "dependency package check success"
   return 0
}

main()
{
    if [ ${compile_flag}x == "1x" ];then
        packageCheck
        if [ $? == 1 ];then
            echo "dependency package check failed"
            exit 0
        fi

        if [ ! -e ${isopath} ];then
            echo "can not find iso:${isopath}"
            exit 0
        fi

        md5Check
        if [ $? -eq 1 ]; then
            echo "package md5 check failed"
            exit 0
        fi
   else


        md5Check
        if [ $? -eq 1 ]; then
            echo "package md5 check failed"
            exit 0
        fi
        confCheck
        if [ $? -eq 1 ]; then
            echo "conf check failed"
            exit 0
        fi
  
    fi    
}

main
echo "mysql check complete!!"

