#!/bin/bash
#use : ./mongodbInstall.sh ${conf} ${func} ${filePath}

conf=$1
func=$2
filePath=$3

echo ${conf} ${func} ${filePath}

isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
prefixdir=`grep "prefixdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

config_server=`grep "config_server," ${conf} | awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
config_server_num=`grep "config_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
config_db_prefix_dir=`grep "config_db_prefix_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
config_db_port=`grep "config_db_port" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

router_server=`grep "router_server," ${conf} | awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
router_server_num=`grep "router_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
router_db_prefix_dir=`grep "router_db_prefix_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
router_db_port=`grep "router_db_port" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`


shard_server=`grep "shard_server," ${conf} | awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_server_num=`grep "shard_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_db_prefix_dir=`grep "shard_db_prefix_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_db_port=`grep "shard_db_port" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_num=`grep "shard_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
replica_num=`grep "replica_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
wiredTigerCacheSizeGB=`grep "wiredTigerCacheSizeGB" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

version=`grep "version" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
depDir=${toolPath}/mongodbDep
cnfPath=""
installLog=${toolPath}/mongodbInstall.log
shard_server_list=(`echo ${shard_server} |tr ';' ' '`)
router_server_list=(`echo ${router_server} |tr ';' ' '`)
config_server_list=(`echo ${config_server} |tr ';' ' '`)
shard_db_port_list=(`echo ${shard_db_port} |tr ';' ' '`)
shard_db_prefix_dir_list=(`echo ${shard_db_prefix_dir} |tr ';' ' '`)

replica_name=db

installDepPackage()
{
    mount ${isopath} ${tempDir}
    cd /etc/yum.repos.d
    if [ ! -d /etc/yum.repos.d/backup ];then
        mkdir /etc/yum.repos.d/backup
    fi
    mv *repo ./backup
    touch local.repo
    echo "[local]" >> local.repo
    echo "name=local" >> local.repo
    echo "baseurl=file://${tempDir}" >> local.repo
    echo "gpgcheck=0"  >> local.repo
    echo "enabled=1" >> local.repo
    yum -y install expect net-tools bison ncurses ncurses-devel libaio libaio-devel openssl-devel gmp gmp-devel mpfr mpfr-devel libmpc libmpc-devel libcurl libcurl-devel libyaml libyaml-devel python-setuptools python-devel
    sleep 2
    umount ${tempDir}
}


installCmake()
{
     local requiredver="3.5.2"
    which cmake
    if [ $? == 0 ];then
      local currentver=`cmake -version |grep "version"|awk '{print $NF}'`
      if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "cmake version match,cmake version is ${currentver}"
        return 0
      fi
    fi

    cd ${depDir}
    local cmaketar_name=`ls |grep -i cmake`
    local temp_cmakedir=${depDir}/tempcmake_src
    mkdir ${temp_cmakedir}
    tar -xzvf ${cmaketar_name} -C ${temp_cmakedir}
    cd ${temp_cmakedir}
    local cmakesrc_dir=`ls |grep -i cmake`
    cd ${cmakesrc_dir}
    ./bootstrap
    make
    make install
    sleep 2
    rm -rf ${temp_cmakedir}
    cd ${depDir}
    local currentver=`cmake -version |grep "version"|awk '{print $NF}'`
    if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "install cmake success,cmake version is ${currentver}"  >> ${installLog}
        echo "install cmake success,cmake version is ${currentver}"
    else
        echo "cmake version error,the min version need ${requiredver},current ver is ${currentver}" >> ${installLog}
        echo "cmake version error,the min version need ${requiredver},current ver is ${currentver}"
        exit 0
    fi


}

installGcc()
{

    local requiredver="7.3.0"
    local currentver=`gcc -dumpversion`
    if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "gcc match ,version:${currentver}"
        return 0
    fi

    cd ${depDir}
    local gcctar_name=`ls |grep -i gcc`
    local temp_gccdir=${depDir}/tempgcc_src
    mkdir ${temp_gccdir}
    tar xzvf ${gcctar_name} -C  ${temp_gccdir}
    cd ${temp_gccdir}
    local gccsrc_dir=`ls |grep -i gcc`
    cd ${gccsrc_dir}
    ./configure --prefix=/usr --mandir=/usr/share/man --infodir=/usr/share/info --enable-bootstrap --enable-shared --enable-threads=posix --enable-checking=release --with-system-zlib --enable-__cxa_atexit --disable-libunwind-exceptions --enable-gnu-unique-object --enable-linker-build-id --with-linker-hash-style=gnu --enable-languages=c,c++,objc,obj-c++ --enable-plugin --enable-initfini-array --disable-libgcj
    make -j 32
    make install
    sleep 2
    rm -rf ${temp_gccdir}
    cd ${depDir}
    local currentver=`gcc -dumpversion`
    if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "install gcc success,gcc version is ${currentver}"  >> ${installLog}
        echo "install gcc success,gcc version is ${currentver}"
    else
        echo "gcc version error,the min version need ${requiredver},current ver is ${currentver}" >> ${installLog}
        echo "gcc version error,the min version need ${requiredver},current ver is ${currentver}"
        exit 0
    fi
}

installPy()
{
    cd ${depDir}
    local cythonzip_name=`ls |grep -i cython`
    local pyyamlzip_name=`ls |grep -i pyyaml`
    local typingzip_name=`ls |grep -i typing`
    local cheetahzip_name=`ls |grep -i cheetah`
    local temp_pydir=${depDir}/temppy_src
    mkdir ${temp_pydir}
    unzip ${cythonzip_name} -d ${temp_pydir}
    unzip ${pyyamlzip_name} -d ${temp_pydir}
    unzip ${typingzip_name} -d ${temp_pydir}
    unzip ${cheetahzip_name} -d ${temp_pydir}

    cd ${temp_pydir}
    local cythonsrc_dir=`ls |grep -i cython`
    local pyyamlsrc_dir=`ls |grep -i pyyaml`
    local typingsrc_dir=`ls |grep -i typing`
    local cheetahsrc_dir=`ls |grep -i cheetah`
    cd ${temp_pydir}/${cythonsrc_dir}
    python setup.py install
    cd ${temp_pydir}/${pyyamlsrc_dir}
    python setup.py install
    cd ${temp_pydir}/${typingsrc_dir}
    python setup.py install
    cd ${temp_pydir}/${cheetahsrc_dir}
    python setup.py install
	sleep 2
	rm -rf ${temp_pydir}

}

installMongoSrc()
{
    echo "prefixdir=${prefixdir}"
    local CPUS=`cat /proc/cpuinfo |grep process |wc -l`
    cd ${toolPath}
    local temp_mongodir=${depDir}/tempmongo_src
    mkdir ${temp_mongodir}
    tar -xzvf ${filePath} -C ${temp_mongodir}
    cd ${temp_mongodir}
    local mongosrc_dir=`ls |grep -i mongo`
    cd ${mongosrc_dir}
    python2 buildscripts/scons.py MONGO_VERSION=4.0.12 all CFLAGS="-march=armv8-a+crc -mtune=generic" -j${CPUS} --disable-warnings-as-errors
    sleep 2
    python2 buildscripts/scons.py MONGO_VERSION=4.0.12 --prefix=${prefixdir} --disable-warnings-as-errors CFLAGS="-march=armv8-a+crc" install -j${CPUS}
    sleep 2
	rm -rf ${temp_mongodir}
	cd ${prefixdir}
    if [ -e ${prefixdir}/bin/mongod ];then
        echo "install mongo success from source code" >> ${installLog}
        echo "install mongo success"
    else
        echo "install mongo failed from source code"  >> ${installLog}
        echo "install mongo failed"
        exit 0
    fi

    cd ${prefixdir}/bin
    strip mongos
    strip mongod
    strip mongo

}


initEnv()
{
    cd ${toolPath}
    echo "args:${os_root_user} ${os_root_password} ${shard_server} for sshkey" >> ${installLog}
    sh sshKey.sh ${os_root_user} ${os_root_password} ${shard_server}
    local libdir="/usr/lib64"
    local hostname=`hostname`
    systemctl stop firewalld
    systemctl disable firewalld
    sed -i 's/SELINUX=enforcing/SELINUX=disable/g' /etc/sysconfig/selinux
    echo "serverlist=${shard_server_list[@]}"
    
    #rpminstall libstdc copy from mongodbDep
    if [ ! -f ${libdir}/libstdc++.so.6.0.24 ];then
       cd ${depDir}
       local libstdc_name=`ls |grep -i libstdc`
       cp ${libstdc_name} /usr/lib64/
       rm -f /usr/lib64/libstdc++.so.6
       ln -s /usr/lib64/${libstdc_name} /usr/lib64/libstdc++.so.6
    fi
    if [ ${func}x == "rpminstallx" ];then
       prefixdir="/usr/local/mongo" 
    fi  
 
    cd ${toolPath}
    for serverip in ${shard_server_list[@]}
    do
       echo "${serverip}"
       local remotehostname=`ssh ${os_root_user}@${serverip} "hostname"`
       if [ ${hostname}x == ${remotehostname}x ];then
            continue
       fi
       
       scp ${libdir}/libstdc++.so.6.0.24 ${os_root_user}@${serverip}:/usr/lib64
       
       ssh -tt ${os_root_user}@${serverip} <<-EOF
       systemctl stop firewalld
       systemctl disable firewalld
       sed -i 's/SELINUX=enforcing/SELINUX=disable/g' /etc/sysconfig/selinux
       rm -f /usr/lib64/libstdc++.so.6
       ln -s /usr/lib64/libstdc++.so.6.0.24 /usr/lib64/libstdc++.so.6
       sleep 1
       if [ ! -d ${prefixdir} ] && [ "${func}x" == "sourceinstallx" ];then
            mkdir ${prefixdir}
       fi
       exit
EOF
       if [ "${func}x" == "sourceinstallx" ];then
           scp -r ${prefixdir}/* ${os_root_user}@${serverip}:${prefixdir}
       fi 
     done

}

routerServer()
{
     rm -f /tmp/mongo*
    local routerconf=/tmp/mongorouter.conf
    touch ${routerconf}
    local configdbstr="config/${config_server_list[0]}:${config_db_port}"
    for serverip in ${config_server_list[@]:1}
    do
          configdbstr="${configdbstr},${serverip}:${config_db_port}"
    done
    echo "configdbstr=${configdbstr}"
    cat >> ${routerconf} << EOF
logpath=${router_db_prefix_dir}/log/mongos.log
port=${router_db_port}
logappend=true
bind_ip=0.0.0.0
fork=true
configdb=${configdbstr}
maxConns=20000

EOF
    echo "router server is ${router_server_list[@]}" >> ${installLog}
    for serverip in ${router_server_list[@]}
    do
        scp ${routerconf} ${os_root_user}@${serverip}:/etc
        ssh -tt ${os_root_user}@${serverip} <<-EOF
        mkdir -p ${router_db_prefix_dir}/log
        ${prefixdir}/bin/mongos -f /etc/mongorouter.conf
        sleep 2
        exit
EOF
done



}
configServer()
{
     rm -f /tmp/mongo*
    local configconf=/tmp/mongoconfig.conf
    touch ${configconf}
    cat  >>  ${configconf} << EOF
dbpath=${config_db_prefix_dir}/data
logpath=${config_db_prefix_dir}/log/mongodb.log
port=${config_db_port}
logappend=true
bind_ip=0.0.0.0
fork=true
configsvr=true
replSet=config
maxConns=20000
EOF
    echo "config server is ${config_server_list[@]}" >> ${installLog}
    for serverip in ${config_server_list[@]}
    do
        scp ${configconf} ${os_root_user}@${serverip}:/etc
        ssh -tt ${os_root_user}@${serverip} <<-EOF
        mkdir -p ${config_db_prefix_dir}/data
        mkdir -p ${config_db_prefix_dir}/log
        ${prefixdir}/bin/mongod -f /etc/mongoconfig.conf
        sleep 2
        exit
EOF
        
    done

}

shardServer()
{
    rm -f /tmp/mongo*
    local shardarray=()
    for ((j=0; j<${shard_num}; j++))
    do
        startnum=`expr ${j} % ${shard_server_num}`
        for ((k=0; k<${replica_num}; k++))
        do
            serverindex=`expr ${startnum} + ${k}`
            serverindex=`expr ${serverindex} % ${shard_server_num}`
            oldvalue=${shardarray[${j}]}
            shardarray[${j}]="${oldvalue};${shard_server_list[${serverindex}]}"
        done

    done
     
    for ((i=0; i<${shard_num}; i++))
    do
        local shardnum=`expr ${i} + 1`  #set shard num from 1
        local shardconf=/tmp/mongoshard${shardnum}.conf
        touch ${shardconf}
        cat  >>  ${shardconf} << EOF
dbpath=${shard_db_prefix_dir_list[${i}]}/datashard${shardnum}
logpath=${shard_db_prefix_dir_list[${i}]}/logshard${shardnum}/mongodb.log
port=${shard_db_port_list[${i}]}
logappend=true
bind_ip=0.0.0.0
fork=true
shardsvr=true
wiredTigerCacheSizeGB=${wiredTigerCacheSizeGB}
replSet=${replica_name}${shardnum}
maxConns=20000
EOF
       local shardlist=(`echo ${shardarray[${i}]} |tr ';' ' '`)
       echo "shard${shardnum} server is ${shardlist[@]}" >> ${installLog}
       for ((j=0; j<${replica_num}; j++))
       do
            scp ${shardconf} ${os_root_user}@${shardlist[${j}]}:/etc
            ssh -tt ${os_root_user}@${shardlist[${j}]} <<-EOF
            mkdir -p ${shard_db_prefix_dir_list[${i}]}/datashard${shardnum}
            mkdir -p ${shard_db_prefix_dir_list[${i}]}/logshard${shardnum}
            ${prefixdir}/bin/mongod -f /etc/mongoshard${shardnum}.conf
            sleep 2
            exit    
EOF
       done

    done


}
initReplica()
{
    local shardarray=()
    for ((j=0; j<${shard_num}; j++))
    do
        startnum=`expr ${j} % ${shard_server_num}`
        for ((k=0; k<${replica_num}; k++))
        do
            serverindex=`expr ${startnum} + ${k}`
            serverindex=`expr ${serverindex} % ${shard_server_num}`
            oldvalue=${shardarray[${j}]}
            shardarray[${j}]="${oldvalue};${shard_server_list[${serverindex}]}"
        done

    done

    for ((i=0; i<${shard_num}; i++))
    do
        local shardlist=(`echo ${shardarray[${i}]} |tr ';' ' '`)
        local shardnum=`expr ${i} + 1`
        local configstr="_id:\"${replica_name}${shardnum}\""
        local members="{_id:0,host:\"${shardlist[0]}:${shard_db_port_list[${i}]}\",priority : 2}"
        for ((j=1; j<${replica_num}; j++))
        do
            members="${members},{_id:${j},host:\"${shardlist[${j}]}:${shard_db_port_list[${i}]}\",priority : 1}"
        done
        configstr="{${configstr},members:[${members}]}"
        echo "configstr=${configstr}" >> ${installLog}
       
        echo "ssh to ${shardlist[0]} to init replica ${replica_name}${shardnum}" >> ${installLog}
        ssh -tt ${os_root_user}@${shardlist[0]} <<-EOFCMD
    
        ${prefixdir}/bin/mongo --port ${shard_db_port_list[${i}]} <<EOF
config=${configstr}
rs.initiate(config)
EOF
exit
EOFCMD

    done
    #config server replica init
    configstr="_id:\"config\""
    members="{_id:0,host:\"${config_server_list[0]}:${config_db_port}\",priority : 2}"
    for ((j=1; j<${config_server_num}; j++))
    do
        members="${members},{_id:${j},host:\"${config_server_list[${j}]}:${config_db_port}\",priority : 1}"
    done
    configstr="{${configstr},members:[${members}]}"
    echo "configstr=${configstr}" >> ${installLog}
    echo "ssh to ${config_server_list[0]} to init  replica config" >> ${installLog}
    ssh -tt ${os_root_user}@${config_server_list[0]} <<-EOFCMD

${prefixdir}/bin/mongo --port ${config_db_port} <<EOF
config=${configstr}
rs.initiate(config)
EOF

exit
EOFCMD


}

initShard()
{
    local  shardarray=()
    for ((j=0; j<${shard_num}; j++))
    do
        startnum=`expr ${j} % ${shard_server_num}`
        for ((k=0; k<${replica_num}; k++))
        do
            serverindex=`expr ${startnum} + ${k}`
            serverindex=`expr ${serverindex} % ${shard_server_num}`
            oldvalue=${shardarray[${j}]}
            shardarray[${j}]="${oldvalue};${shard_server_list[${serverindex}]}"
        done

    done

    for ((i=0; i<${shard_num}; i++))
    do
        local shardlist=(`echo ${shardarray[${i}]} |tr ';' ' '`)
        local shardnum=`expr ${i} + 1`
        shardstr="${replica_name}${shardnum}/${shardlist[0]}:${shard_db_port_list[${i}]}"
        for ((j=1; j<${replica_num}; j++))
        do
            shardstr="${shardstr},${shardlist[${j}]}:${shard_db_port_list[${i}]}"
                    
        done
        shardstr="\"${shardstr}\""
        echo "add shard: ${shardstr} in ${router_server_list[0]}" >> ${installLog}
         ssh -tt ${os_root_user}@${router_server_list[0]} <<-EOFCMD
${prefixdir}/bin/mongo --port ${router_db_port} <<EOF
use admin
sh.addShard(${shardstr})
EOF
exit
EOFCMD

    done
    
     ssh -tt ${os_root_user}@${router_server_list[0]} <<-EOFCMD
${prefixdir}/bin/mongo --port ${router_db_port} <<EOF
use admin
sh.enableSharding("ycsb")
sh.shardCollection("ycsb.usertable",{_id:"hashed"})
EOF
exit
EOFCMD


}


installRpm()
{
    cd ${toolPath}
    for((i=0; i<${shard_server_num}; i++))
    do
        scp ${filePath} ${os_root_user}@${shard_server_list[${i}]}:/tmp
        filename=`echo ${filePath} | awk -F '/' '{print $NF}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
        ssh -tt ${os_root_user}@${shard_server_list[${i}]} <<-EOF
rpm -ivh /tmp/${filename}
sleep 1
exit
EOF

    done


}

rpmBuild()
{
    mkdir -p ${tempDir}/rpmbuild/{BUILD,RPMS,SOURCES,SPECS,SRPMS}
    CPUS=`cat /proc/cpuinfo |grep process |wc -l`
    filename=`echo ${filePath} | awk -F '/' '{print $NF}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    cd ${toolPath}
    cp ${filePath} ${tempDir}/rpmbuild/SOURCES

	echo """name:mongo
Version:${version}
Release:1.el7
License: mongo
URL: https://www.mongodb.com/
Group: applications/database
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Packager: tsdbtool
Autoreq: no
Source: ${filename}
prefix: /usr/local/%{name}
Summary: mongo server
%description
MongoDB is a general purpose, document-based, distributed database
built for modern application developers and for the cloud era.

%define MONGO_USER mongo
%define MONGO_GROUP mongo
%define __os_install_post %{nil}
%define _topdir ${tempDir}/rpmbuild

%define __debug_install_post %{_rpmconfigdir}/find-debuginfo.sh %{?_find_debuginfo_opts} "%{_builddir}/%{?buildsubdir}" %{nil}

%prep
%setup -q -n %{name}-r${version}
%define _topdir ${tempDir}/rpmbuild
%build

python2 buildscripts/scons.py MONGO_VERSION=${version} mongod CFLAGS='-march=armv8-a+crc -mtune=generic' -j${CPUS} --disable-warnings-as-errors

%install
python buildscripts/scons.py MONGO_VERSION=${version} --prefix=\$RPM_BUILD_ROOT/usr/local/mongo/ install --disable-warnings-as-errors CFLAGS='-march=armv8-a+crc' install -j${CPUS}

cd /root/rpmbuild/BUILDROOT/mongo-${version}-%{release}.aarch64/%{prefix}/bin
strip mongos
strip mongod
strip mongo
cp /usr/lib64/libatomic.so.1.2.0 \$RPM_BUILD_ROOT/usr/local/mongo/bin
cp /usr/lib64/libstdc++.so.6.0.24 \$RPM_BUILD_ROOT/usr/local/mongo/bin

%files
%defattr(-, %{MONGO_USER}, %{MONGO_GROUP})
%attr(755, %{MONGO_USER}, %{MONGO_GROUP}) %{prefix}/*

%pre
if ! id %{MONGO_USER} > /dev/null 2>&1;then
useradd -M -s /sbin/nologin %{MONGO_USER}
fi

%post
if [ ! -f /usr/lib64/libatomic.so.1 ];then
        cp -f /usr/local/mongo/bin/libatomic.so.1.2.0 /usr/lib64/
        ln -s /usr/lib64/libatomic.so.1.2.0  /usr/lib64/libatomic.so.1
else
        ver1=\`ls -l /usr/lib64/libatomic.so.1|awk -F'.' '{print \"\"\$6\".\"\$7\".\"\$8\"\"}'\`
        ver11=\`echo -e \"\${ver1}\\n1.1.99\"|sort -V|tail -1\`
        if [ \"\${ver11}\" = \"1.1.99\" ];then
                cp -f /usr/local/mongo/bin/libatomic.so.1.2.0 /usr/lib64/
                rm -f /usr/lib64/libatomic.so.1
                ln -s /usr/lib64/libatomic.so.1.2.0  /usr/lib64/libatomic.so.1
        fi
fi
if [ ! -f /usr/lib64/libstdc++.so.6 ];then
        cp -f /usr/local/mongo/bin/libstdc++.so.6.0.24 /usr/lib64/
        ln -s /usr/lib64/libstdc++.so.6.0.24  /usr/lib64/libstdc++.so.6
else
        ver2=\`ls -l /usr/lib64/libstdc++.so.6|awk -F'.' '{print \"\"\$6\".\"\$7\".\"\$8\"\"}'\`
        ver22=\`echo -e \"\${ver2}\\n6.0.23\"|sort -V|tail -1\`
        if [ \"\${ver22}\" = \"6.0.23\" ];then
                cp -f /usr/local/mongo/bin/libstdc++.so.6.0.24 /usr/lib64/
                rm -f /usr/lib64/libstdc++.so.6
                ln -s /usr/lib64/libstdc++.so.6.0.24  /usr/lib64/libstdc++.so.6
        fi
fi

%postun
rm -rf %{prefix}
userdel -r %{MONGO_USER} >/dev/null 2>&1
%changelog""" > ${tempDir}/rpmbuild/SPECS/mongo.spec
        echo "begin to build rpm,it will takes about 30 min"
        rpmbuild -bb  ${tempDir}/rpmbuild/SPECS/mongo.spec > /tmp/rpm.log 2>&1
        if [ $? -eq 0 ];then
                echo "compiler success"
        else
                echo "compiler failed"
                tail -10 /tmp/rpm.log
                exit 1
        fi
        cp ${tempDir}/rpmbuild/RPMS/aarch64/* ${toolPath}

}
main()
{   
    rm -rf ${installLog}
    rm -rf ${tempDir}
    mkdir ${tempDir}

    if [ ${func} == "sourceinstall" ]; then
        installDepPackage
        installCmake
        installGcc
        installPy
        installMongoSrc
        initEnv
        configServer
        shardServer
        initReplica
        routerServer
        initShard        
        
    fi
    if [ ${func} == "rpminstall" ]; then

        initEnv
        installRpm
        configServer
        shardServer
        initReplica
        routerServer
        initShard
    fi

    if [ ${func} == "compile" ];then
         installDepPackage
        installCmake
        installGcc
        installPy
        rpmBuild
    fi


}

main

echo "--------success-------"




