#!/bin/bash
#use:mongodbCheck conf fileType filePath
conf=$1
fileType=$2
filePath=$3

RPMMD5=(
7e7d4dd2db65f93224f0233da4997ea4
)
#src md5 value(4.0.12（mongo web)   4.0.12--git)
#bfdf7dc714f31f042314ba2d826de2e9-- from github 4.0.12 src tar.gz md5sum
#918aaa412be9213a167a2b03d6841f95-- from mongo web 4.0.12 md5sum
SRCMD5=(
918aaa412be9213a167a2b03d6841f95
bfdf7dc714f31f042314ba2d826de2e9
)
isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
prefixdir=`grep "prefixdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

config_server=`grep "config_server," ${conf} | awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
config_server_num=`grep "config_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
config_db_prefix_dir=`grep "config_db_prefix_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
config_db_port=`grep "config_db_port" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

router_server=`grep "router_server," ${conf} | awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
router_server_num=`grep "router_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
router_db_prefix_dir=`grep "router_db_prefix_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
router_db_port=`grep "router_db_port" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`


shard_server=`grep "shard_server," ${conf} | awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_server_num=`grep "shard_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_db_prefix_dir=`grep "shard_db_prefix_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_db_port=`grep "shard_db_port" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_num=`grep "shard_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
replica_num=`grep "replica_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

compile_flag=`grep "compile_flag" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
#mkdir ${tempDir}
depDir=${toolPath}/mongodbDep
cnfPath=""
installLog=${toolPath}/mongodbInstall.log
shard_server_list=(`echo ${shard_server} |tr ';' ' '`)
router_server_list=(`echo ${router_server} |tr ';' ' '`)
config_server_list=(`echo ${config_server} |tr ';' ' '`)
shard_db_port_list=(`echo ${shard_db_port} |tr ';' ' '`)
shard_db_prefix_dir_list=(`echo ${shard_db_prefix_dir} |tr ';' ' '`)

replica_name=db


# if ok return 0 ,else return 1
md5Check()
{
    cd ${toolPath}
    local value=`md5sum ${filePath} | awk '{print $1}'`
    if [ ${fileType} == "rpmdir" ];then
#       if echo "${RPMMD5[@]}" | grep -w ${value} &>/dev/null; then
#           echo "package md5 check success"
           return 0
#       fi

    fi

    if [ ${fileType} == "sourcedir" ];then
       if echo "${SRCMD5[@]}" |grep -w ${value} &>/dev/null; then
           echo "package md5 check success"
           return 0
       fi
    fi
    return 1

}

sshCheck()
{
    local remotehost=$1
        ping -c2 -W2 ${remotehost} &> /dev/null
        if [ $? -ne 0 ];then
            echo "can not connect host:${remotehost}"
            return 1
        fi
        expect <<-EOF
                set timeout 2
        spawn ssh ${os_root_user}@${remotehost}
        expect {
             "yes/no" {send "yes\r";exp_continue}
             "password:" {send "${os_root_password}\r"}
       }
       expect "password:" {
         exit 1
       }
       expect "#"
       send "exit\r"
       expect eof
       exit 2
EOF

       if [ $? == 2 ];then
           echo "ssh connect ${remotehost} check success"
           return 0
       else
           echo "ssh connect ${remotehost} failed,please check the paasword"
           return 1
       fi

}



confCheck()
{
    if [ ${fileType} == "sourcedir" ] && [ ! -d ${prefixdir} ];then
        echo  "can not find prefixdir:${prefixdir}"
        return 1
    fi
   
    if [ ! -e ${isopath} ];then
        echo "can not find iso:${isopath}"
        return 1
    fi

    for serverip in ${shard_server_list[@]}
    do
        sshCheck ${serverip}
        if [ $? == 1 ]; then
             echo "ssh check to ${serverip} failed"
             return  1
        fi
    done
    cd ${toolPath}
    sh sshKey.sh ${os_root_user} ${os_root_password} ${shard_server}
}

configServerCheck()
{
    if [ ${#config_server_list[@]} -ne ${config_server_num} ];then
        echo "config server num error"
        return 1
    fi
    
     for serverip in ${config_server_list[@]}
     do
         ssh ${os_root_user}@${serverip} /bin/bash << EOF
if [ ! -d ${config_db_prefix_dir} ];then
exit 1
fi
exit
EOF
         if [ $? -eq 1 ];then
             echo "config server check failed,${serverip} can not find the config_db_dir: ${config_db_prefix_dir} "
             return 1
         fi
         local line=`ssh ${os_root_user}@${serverip} netstat -anp |grep ":${config_db_port}" | wc -l `  
         if [ ${line} -gt 0 ];then
             echo "config server check failed,${serverip}:${config_db_port} port is using"
             return 1
         fi
     done

}

routerServerCheck()
{
     if [ ${#router_server_list[@]} -ne ${router_server_num} ];then
        echo "router server num error"
        return 1
    fi

     for serverip in ${router_server_list[@]}
     do
         ssh ${os_root_user}@${serverip} /bin/bash << EOF
if [ ! -d ${router_db_prefix_dir} ];then
exit 1
fi
exit
EOF
         if [ $? -eq 1 ];then
             echo "router server check failed,${serverip} can not find the router_db_dir: ${router_db_prefix_dir} "
             return 1
         fi
         local line=`ssh ${os_root_user}@${serverip} netstat -anp |grep ":${router_db_port}" | wc -l `
         if [ ${line} -gt 0 ];then
             echo "router server check failed,${serverip}:${router_db_port} port is using"
             return 1
         fi
     done

}

shardServerCheck()
{
    if [ ${#shard_server_list[@]} -ne ${shard_server_num} ];then
        echo "shard server num error"
        return 1
    fi

    if [ ${#shard_db_port_list[@]} -ne ${shard_num} ];then
        echo "shard num error"
        return 1
    fi
   
    local shardarray=()
    for ((j=0; j<${shard_num}; j++))
    do
        startnum=`expr ${j} % ${shard_server_num}`
        for ((k=0; k<${replica_num}; k++))
        do
            serverindex=`expr ${startnum} + ${k}`
            serverindex=`expr ${serverindex} % ${shard_server_num}`
            oldvalue=${shardarray[${j}]}
            shardarray[${j}]="${oldvalue};${shard_server_list[${serverindex}]}"
        done

    done


    for ((i=0; i<${shard_num}; i++))
    do
        local shardlist=(`echo ${shardarray[${i}]} |tr ';' ' '`)
        for ((j=0; j<${replica_num}; j++))
        do
           ssh  ${os_root_user}@${shardlist[${j}]} /bin/bash << EOF
if [ ! -d ${shard_db_prefix_dir_list[${i}]} ];then
exit 1
fi
exit
EOF
         if [ $? -eq 1 ];then
            echo "shard server check failed,${shardlist[${j}]} can not find the shard_db_dir: ${shard_db_prefix_dir_list[${i}]} "
             return 1
         fi
         local line=`ssh ${os_root_user}@${shardlist[${j}]} netstat -anp |grep ":${shard_db_port_list[${i}]}" | wc -l `
         if [ ${line} -gt 0 ];then
             echo "shard server check failed,${shardlist[${j}]}:${shard_db_port_list[${i}]} port is using"
             return 1
         fi

        done

    done

}


packageCheck()
{
    cd ${depDir}
   #gcc package check
   local gccpackage=`ls |grep -i gcc | wc -l`
   if [ ${gccpackage} -ne 1 ];then
      echo "can not find gcc package in ${depDir}"
      return 1
   fi
  # cmake package check
   local cmakepackage=`ls |grep -i cmake | wc -l`
   if [ ${cmakepackage} -ne 1 ];then
      echo "can not find cmake package in ${depDir}"
      return 1
   fi

   local depname=(cython pyyaml typing cheetah)
   for name in ${depname[@]}
   do
      local packageNum=`ls |grep -i ${name} |wc -l`
      if [ ${packageNum} -ne 1 ];then
          echo "can not find ${packageNum} package in ${depDir}"
          return 1
      fi
   done

   echo "dependency package check success"
   return 0
}



main()
{
 
   if [ ${compile_flag}x == "1x" ];then
      packageCheck
      if [ $? == 1 ];then
          echo "dependency package check failed"
          exit 0
      fi
      
      if [ ! -e ${isopath} ];then
          echo "can not find iso:${isopath}"
          exit 0
      fi

       md5Check
       if [ $? -eq 1 ]; then
           echo "package md5 check failed"
           exit 0
       fi
   else
        which expect
        if [ $? == 1 ];then
            echo "can not find command:expect,please install,check failed"
            return 1
        fi

        md5Check
        if [ $? -eq 1 ]; then
           echo "package md5 check failed"
           exit 0
        fi

        confCheck
        if [ $? -eq 1 ]; then
            echo "conf check failed"
            exit 0
        fi
        configServerCheck
        if [ $? -eq 1 ]; then
            echo "configServer check failed"
           exit 0
        fi

        routerServerCheck
        if [ $? -eq 1 ]; then
            echo "routerServer check failed"
            exit 0
        fi
        shardServerCheck
        if [ $? -eq 1 ]; then
           echo "shardServer check failed"
           exit 0
        fi
    
    fi

}

main
echo "mongodb env check success"


