#!/bin/bash
#use:sh greenplumInstall.sh ${conf} ${fileType} ${filePath}

conf=$1
func=$2
filePath=$3


isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
prefixdir=`grep "prefixdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

master_server=`grep "master_server" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
master_dir=`grep "master_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

standby_server=`grep "standby_server" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
standby_dir=`grep "standby_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

seg_server=`grep "seg_server," ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_server_num=`grep "seg_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_data_dir=`grep "seg_data_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_mirror_data_dir=`grep "seg_mirror_data" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_dir_num=`grep "seg_dir_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
version=`grep "version" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

seg_server_list=(`echo ${seg_server} |tr ';' ' '`)
seg_data_dir_list=(`echo ${seg_data_dir} |tr ';' ' '`)
seg_mirror_data_dir=(`echo ${seg_mirror_data_dir} |tr ';' ' '`)

toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
rm -rf ${tempDir}
mkdir ${tempDir}
depDir=${toolPath}/greenplumDep
cnfPath=""
installLog=${toolPath}/greenplumInstall.log



installDepPackage()
{
    mount ${isopath} ${tempDir}
    cd /etc/yum.repos.d
    if [ ! -d /etc/yum.repos.d/backup ];then
        mkdir /etc/yum.repos.d/backup
    fi
    mv *repo ./backup
    touch local.repo
    echo "[local]" >> local.repo
    echo "name=local" >> local.repo
    echo "baseurl=file://${tempDir}" >> local.repo
    echo "gpgcheck=0"  >> local.repo
    echo "enabled=1" >> local.repo
    yum -y install expect net-tools curl-devel bzip2-devel python-devel openssl-devel readline-devel perl-ExtUtils-Embed libxml2-devel openldap-devel pam pam-devel perl-devel apr-devel libevent-devel libyaml libyaml-devel libedit-devel libffi-devel 
    sleep 2
    umount ${tempDir}
}

installCmake()
{
      local requiredver="3.5.2"
    which cmake
    if [ $? == 0 ];then
      local currentver=`cmake -version |grep "version"|awk '{print $NF}'`
      if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "cmake version match,cmake version is ${currentver}"
        return 0
      fi
    fi

    cd ${depDir}
    local cmaketar_name=`ls |grep -i cmake`
    local temp_cmakedir=${depDir}/tempcmake_src
    mkdir ${temp_cmakedir}
    tar -xzvf ${cmaketar_name} -C ${temp_cmakedir}
    cd ${temp_cmakedir}
    local cmakesrc_dir=`ls |grep -i cmake`
    cd ${cmakesrc_dir}
    ./bootstrap
    make
    make install
    sleep 2
    rm -rf ${temp_cmakedir}
    cd ${depDir}
    local currentver=`cmake -version |grep "version"|awk '{print $NF}'`
    if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "install cmake success,cmake version is ${currentver}"  >> ${installLog}
        echo "install cmake success,cmake version is ${currentver}"
    else
        echo "cmake version error,the min version need ${requiredver},current ver is ${currentver}" >> ${installLog}
        echo "cmake version error,the min version need ${requiredver},current ver is ${currentver}"
        exit 0
    fi


}

#install python depends package
installPy()
{
    cd ${depDir}
    local pyname=(setuptools psutil pbr lockfile pycparser cffi bcrypt six pynacl cryptography ipaddress enum34 paramiko)
    local temp_pydir=${depDir}/temppy_src
    rm -rf ${temp_pydir}
    mkdir ${temp_pydir}
    
    for name in ${pyname[@]}
    do
        cd ${depDir}
        local packagename=`ls |grep -i ${name}`
        local packagetype=`echo ${packagename} | awk -F '.' '{print $NF}'`
        if [ ${packagetype}x == "gzx" ];then
            tar -xzvf ${packagename} -C ${temp_pydir}
        elif [ ${packagetype}x == "zipx" ];then
            unzip ${packagename} -d ${temp_pydir}
        else
            echo "unsupport package type ${packagename}" >> ${installLog}
        fi
        cd ${temp_pydir}
        local packagesrc_dir=`ls |grep -i ${name}`
        cd ${packagesrc_dir}
        if [ ${name} == "setuptools" ];then
            python bootstrap.py
        fi
        python setup.py install
        echo "package ${packagename} install success" >> ${installLog}
    done
    sleep 2
    rm -rf ${temp_pydir}


}

#install gporca and depends
installDep()
{
    cd ${depDir}
    local zstdzip_name=`ls | grep -i zstd`
    local xerceszip_name=`ls | grep -i xerces`
    local re2czip_name=`ls |grep -i re2c`
    local ninjazip_name=`ls |grep -i ninja`
    local gporcazip_name=`ls | grep -i gporca`

    local temp_depdir=${depDir}/tempdep_src
    rm -rf ${temp_depdir}
    mkdir ${temp_depdir}
    unzip ${zstdzip_name} -d ${temp_depdir}
    unzip ${xerceszip_name} -d ${temp_depdir}
    unzip ${re2czip_name} -d ${temp_depdir}
    unzip ${ninjazip_name} -d ${temp_depdir}
    unzip ${gporcazip_name} -d ${temp_depdir}
   
    cd ${temp_depdir}
    
    local zstdsrc_dir=`ls | grep -i zstd`
    local xercessrc_dir=`ls | grep -i xerces`
    local re2csrc_dir=`ls |grep -i re2c`
    local ninjasrc_dir=`ls |grep -i ninja`
    local gporcasrc_dir=`ls | grep -i gporca`
  
    cd ${temp_depdir}/${zstdsrc_dir}
    make
    make install
    local zstdname=`ls /usr/local/lib/libzstd* |tail -1`
  
    ln -s ${zstdname} /usr/lib64/libzstd.so.1
  
        
    cd ${temp_depdir}/${xercessrc_dir}
    ./configure
    make
    make install
  
    cd  ${temp_depdir}/${re2csrc_dir}
    ./autogen.sh
    ./configure
    make 
    make install

    cd ${temp_depdir}/${ninjasrc_dir}
    ./configure.py --bootstrap
    cp ninja /usr/bin

    cd ${temp_depdir}/${gporcasrc_dir}
    cmake -GNinja -H. -Bbuild
    sed -i 's/GPOS_CPL_ASSERT(!"Backtrace is not supported/\/\/ &/' libgpos/src/common/CStackDescriptor.cpp
    ninja install -C build
    touch /etc/ld.so.conf.d/gplib.conf
    cat >> /etc/ld.so.conf.d/gplib.conf <<EOF
/usr/local
/usr/local/lib
/usr/local/lib64
EOF
    ldconfig
    sleep 2
    echo "install dep package success" >> ${installLog}
    rm -rf ${temp_depdir}
}

installGpSrc()
{
    cd ${toolPath}
    local temp_gpdir=${depDir}/tempgp_src
    rm -rf ${temp_gpdir}
    mkdir ${temp_gpdir}
    tar -xzvf ${filePath} -C ${temp_gpdir}
    cd ${temp_gpdir}
    local gpsrc_dir=`ls |grep -i gpdb`
    cd ${gpsrc_dir}
    chmod +x configure
    ./configure --with-perl --with-python --with-libxml --with-gssapi --prefix=${prefixdir}
     make 
     make install
     sleep 2
     echo "install gp from src success" >> {installLog}
     rm -rf ${temp_gpdir}
   
}

installGPRpm()
{

   rpm -ivh ${filePath}
   prefixdir="/usr/local/gpdb"


}

initEnv()
{
     systemctl stop firewalld
     systemctl disable firewalld
     sed -i 's/SELINUX=enforcing/SELINUX=disable/g' /etc/sysconfig/selinux
     userdel gpadmin
     groupdel gpadmin
     groupadd gpadmin -g 3001
     useradd -m -g gpadmin -u 3001  gpadmin
    passwd gpadmin <<-EOF
${os_root_password}
${os_root_password}
EOF
}

initGpEnv()
{
    su - gpadmin <<-EOFCMD
    cat >>/home/gpadmin/.bash_profile <<-EOF
source ${prefixdir}/greenplum_path.sh
export PGPORT=5432
export MASTER_DATA_DIRECTORY=${master_dir}/gpseg-1
export LD_LIBRARY_PATH=/usr/local/lib:\\\$LD_LIBRARY_PATH
EOF

source /home/gpadmin/.bash_profile
exit
EOFCMD

    if [ ${func}x == "rpminstallx" ];then
    touch /etc/ld.so.conf.d/gplib.conf
    cat >> /etc/ld.so.conf.d/gplib.conf <<EOF
/usr/local
/usr/local/lib
/usr/local/lib64
EOF
    ldconfig
    fi

}

rpmBuild()
{
    mkdir -p ${tempDir}/rpmbuild/{BUILD,RPMS,SOURCES,SPECS,SRPMS}
    CPUS=`cat /proc/cpuinfo |grep process |wc -l`
    filename=`echo ${filePath} | awk -F '/' '{print $NF}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    cd ${toolPath}
    cp ${filePath} ${tempDir}/rpmbuild/SOURCES

   echo """name:gpdb
Version:${version}
Release:1.el7
License: greenplum
URL:https://github.com/greenplum-db/gpdb
Group: applications/database
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Packager: tsdbtool
Autoreq: no
Source: ${filename}
prefix: /usr/local/gpdb
Summary: greenplum server 
%description
Greenplum Database (GPDB) is an advanced, fully featured, open source data warehouse, based on PostgreSQL. It provides powerful and rapid analytics on petabyte scale data volumes. Uniquely geared toward big data analytics, Greenplum Database is powered by the world.s most advanced cost-based query optimizer delivering high analytical query performance on large data volumes.
%define GPDB_USER gpadmin
%define GPDB_GROUP gpadmin
%define __os_install_post %{nil}
%debug_pachage %{nil}
%define _topdir ${tempDir}/rpmbuild

%define __debug_install_post %{_rpmconfigdir}/find-debuginfo.sh %{?_find_debuginfo_opts} "%{_builddir}/%{?buildsubdir}" %{nil}

%prep
%setup -q -n %{name}-%{version}
%build

./configure --with-perl --with-python --with-libxml --with-gssapi --enable-debug --enable-cassert --prefix=%{prefix}

make -j${CPUS}
%install
make  install
mkdir -p \$RPM_BUILD_ROOT/usr/local/lib
mkdir -p \$RPM_BUILD_ROOT/usr/lib64/python2.7/site-packages
mkdir -p \$RPM_BUILD_ROOT/usr/lib/python2.7/site-packages
mv /usr/local/gpdb \$RPM_BUILD_ROOT/usr/local
cp -r /usr/local/lib/* \$RPM_BUILD_ROOT/usr/local/lib
cp -r /usr/lib64/python2.7/site-packages/psutil* \$RPM_BUILD_ROOT/usr/lib64/python2.7/site-packages
cp -r /usr/lib/python2.7/site-packages/lockfile \$RPM_BUILD_ROOT/usr/lib/python2.7/site-packages/lockfile
cp -r /usr/lib/python2.7/site-packages/paramiko* \$RPM_BUILD_ROOT/usr/lib/python2.7/site-packages
cp -r /usr/lib64/python2.7/site-packages/cryptography* \$RPM_BUILD_ROOT/usr/lib64/python2.7/site-packages
cp -r /usr/lib/python2.7/site-packages/six* \$RPM_BUILD_ROOT/usr/lib/python2.7/site-packages
cp -r /usr/lib64/python2.7/site-packages/cffi* \$RPM_BUILD_ROOT/usr/lib64/python2.7/site-packages
cp -r /usr/lib/python2.7/site-packages/ipaddress* \$RPM_BUILD_ROOT/usr/lib/python2.7/site-packages
cp -r /usr/lib/python2.7/site-packages/enum* \$RPM_BUILD_ROOT/usr/lib/python2.7/site-packages
cp -r /usr/lib/python2.7/site-packages/pbr* \$RPM_BUILD_ROOT/usr/lib/python2.7/site-packages
cp -r /usr/lib64/python2.7/site-packages/bcrypt* \$RPM_BUILD_ROOT/usr/lib64/python2.7/site-packages
cp -r /usr/lib64/python2.7/site-packages/PyNaCl* \$RPM_BUILD_ROOT/usr/lib64/python2.7/site-packages
cp -r /usr/lib/python2.7/site-packages/pycparser* \$RPM_BUILD_ROOT/usr/lib/python2.7/site-packages
cp /usr/lib64/libatomic.so.1.2.0 \$RPM_BUILD_ROOT/usr/local/lib
cp /usr/lib64/libstdc++.so.6.0.24 \$RPM_BUILD_ROOT/usr/local/lib
%clean
rm -rf \$RPM_BUILD_ROOT
rm -rf \$RPM_BUILD_DIR/*
%files
%defattr(-, %{GPDB_USER}, %{GPDB_GROUP})
%attr(755, %{GPDB_USER}, %{GPDB_GROUP}) %{prefix}/*
%attr(755, root, root) /usr/local/lib/*
%attr(755, root, root) /usr/lib64/python2.7/site-packages/psutil*
%attr(755, root, root) /usr/lib/python2.7/site-packages/lockfile*
%attr(755, root, root) /usr/lib/python2.7/site-packages/paramiko*
%attr(755, root, root) /usr/lib64/python2.7/site-packages/cryptography*
%attr(755, root, root) /usr/lib/python2.7/site-packages/six*
%attr(755, root, root) /usr/lib64/python2.7/site-packages/cffi*
%attr(755, root, root) /usr/lib/python2.7/site-packages/ipaddress*
%attr(755, root, root) /usr/lib/python2.7/site-packages/enum*
%attr(755, root, root) /usr/lib/python2.7/site-packages/pbr*
%attr(755, root, root) /usr/lib64/python2.7/site-packages/bcrypt*
%attr(755, root, root) /usr/lib64/python2.7/site-packages/PyNaCl*
%attr(755, root, root) /usr/lib/python2.7/site-packages/pycparser*

%pre
if ! id %{GPDB_USER} > /dev/null 2>&1;then
	groupadd %{GPDB_USER}
	useradd -g %{GPDB_USER} %{GPDB_USER}
fi
%post
if [ ! -f /usr/lib64/libatomic.so.1 ];then
        cp -f /usr/local/lib/libatomic.so.1.2.0 /usr/lib64/
        ln -s /usr/lib64/libatomic.so.1.2.0  /usr/lib64/libatomic.so.1
else
        ver1=\`ls -l /usr/lib64/libatomic.so.1|awk -F'.' '{print \"\"\$6\".\"\$7\".\"\$8\"\"}'\`
        ver11=\`echo -e \"\${ver1}\\n1.1.99\"|sort -V|tail -1\`
        if [ \"\${ver11}\" = \"1.1.99\" ];then
                cp -f /usr/local/lib/libatomic.so.1.2.0 /usr/lib64/
                rm -f /usr/lib64/libatomic.so.1
                ln -s /usr/lib64/libatomic.so.1.2.0  /usr/lib64/libatomic.so.1
        fi
fi
if [ ! -f /usr/lib64/libstdc++.so.6 ];then
        cp -f /usr/local/lib/libstdc++.so.6.0.24 /usr/lib64/
        ln -s /usr/lib64/libstdc++.so.6.0.24  /usr/lib64/libstdc++.so.6
else
        ver2=\`ls -l /usr/lib64/libstdc++.so.6|awk -F'.' '{print \"\"\$6\".\"\$7\".\"\$8\"\"}'\`
        ver22=\`echo -e \"\${ver2}\\n6.0.23\"|sort -V|tail -1\`
        if [ \"\${ver22}\" = \"6.0.23\" ];then
                cp -f /usr/local/lib/libstdc++.so.6.0.24 /usr/lib64/
                rm -f /usr/lib64/libstdc++.so.6
                ln -s /usr/lib64/libstdc++.so.6.0.24  /usr/lib64/libstdc++.so.6
        fi
fi

%postun
rm -rf %{prefix}
userdel -r %{GPDB_USER} >/dev/null 2>&1
%changelog""" >  ${tempDir}/rpmbuild/SPECS/gpdb.spec
       echo "begin to build rpm,it will takes about 30 min"
        rpmbuild -bb  ${tempDir}/rpmbuild/SPECS/gpdb.spec > /tmp/rpm.log 2>&1
        if [ $? -eq 0 ];then
                echo "compiler success"
        else
                echo "compiler failed"
                tail -10 /tmp/rpm.log
                exit 1
        fi
        cp ${tempDir}/rpmbuild/RPMS/aarch64/* ${toolPath}



}

main()
{
    cd ${toolPath}
    rm -rf ${installLog}  
    if [ ${func}x == "sourceinstallx" ];then    
    initEnv
    installDepPackage
    installCmake
    installPy
    installDep
    installGpSrc
    initGpEnv      
    fi

    if [ ${func}x == "rpminstallx" ];then
    initEnv
    installGPRpm
    initGpEnv
    fi

    if [ ${func} == "compile" ];then
        installDepPackage
        installCmake
        installPy
        installDep
        rpmBuild
    fi

}

main
echo "---- success--------"
