#!/bin/bash
#use:greenplumInit.sh ${conf}
conf=$1
fileType=$2

isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
prefixdir=`grep "prefixdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

master_server=`grep "master_server" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
master_dir=`grep "master_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

standby_server=`grep "standby_server" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
standby_dir=`grep "standby_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

seg_server=`grep "seg_server," ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_server_num=`grep "seg_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_data_dir=`grep "seg_data_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_mirror_data_dir=`grep "seg_mirror_data" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_dir_num=`grep "seg_dir_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

seg_server_list=(`echo ${seg_server} |tr ';' ' '`)
seg_data_dir_list=(`echo ${seg_data_dir} |tr ';' ' '`)
seg_mirror_data_dir_list=(`echo ${seg_mirror_data_dir} |tr ';' ' '`)

toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
#mkdir ${tempDir}
depDir=${toolPath}/greenplumDep
cnfPath=""
installLog=${toolPath}/greenplumInstall.log

all_server="${seg_server};${master_server};${standby_server}"
all_server_list=(`echo ${all_server} |tr ';' ' '`)
#deduplication
all_server_list=(`echo ${all_server_list[@]} | sed 's/ /\n/g' | sort | uniq`)
all_server=`echo ${all_server_list[@]} | sed 's/ /;/g'`


sethostsfile()
{
    for serverip in ${all_server_list[@]}
    do
        local host_name=`ssh ${os_root_user}@${serverip} "hostname"`
        local hoststr="${serverip} ${host_name}"
        echo ${hoststr} >> /etc/hosts
    done

    for serverip in ${all_server_list[@]}
    do
        scp /etc/hosts ${os_root_user}@${serverip}:/etc   

    done
}

changedirowner()
{
    ssh -tt ${os_root_user}@${master_server}<<-EOF
chown -R gpadmin:gpadmin ${master_dir}
exit
EOF
    ssh -tt ${os_root_user}@${standby_server}<<-EOF
chown -R gpadmin:gpadmin ${standby_dir}
exit
EOF
    local seg_data_dir_str=`echo ${seg_data_dir_list[@]}`
    local seg_mirror_data_dir_str=`echo ${seg_mirror_data_dir_list[@]}`
    for serverip in ${seg_server_list[@]}
    do
         ssh -tt ${os_root_user}@${serverip}<<-EOF
chown -R gpadmin:gpadmin ${seg_data_dir_str}
chown -R gpadmin:gpadmin ${seg_mirror_data_dir_str}
exit
EOF
    done

}
initGp()
{
#     su - gpadmin
     if [ ${fileType}x == "rpmdirx" ];then
        prefixdir="/usr/local/gpdb"
     fi
     cd ${prefixdir}
     rm -f hostfile
     touch hostfile
     for serverip in ${all_server_list[@]}
     do
         local host_name=`ssh ${os_root_user}@${serverip} "hostname"`
         echo ${host_name} >> hostfile
     done
     chown gpadmin:gpadmin hostfile
     echo "begin to exkeys in all servers"
     su - gpadmin <<-EOF
     cd ${prefixdir}    
     gpssh-exkeys -f hostfile
     exit
EOF

     rm -f seghost
     touch seghost
     for serverip in ${seg_server_list[@]}
     do
         local host_name=`ssh ${os_root_user}@${serverip} "hostname"`
         echo ${host_name} >> seghost
     done
     chown gpadmin:gpadmin seghost
     
     local master_hostname=`ssh ${os_root_user}@${master_server} "hostname"`
     local standby_hostname=`ssh ${os_root_user}@${standby_server} "hostname"`

     rm -f init.config
     touch init.config
     local datastr=`echo ${seg_data_dir_list[@]}`
     local mirrorstr=`echo ${seg_mirror_data_dir_list[@]}`
     cat >> init.config <<EOF
ARRAY_NAME="test greenplum"
SEG_PREFIX=gpseg
PORT_BASE=40000
declare -a DATA_DIRECTORY=(${datastr})
MASTER_HOSTNAME=${master_hostname}
MASTER_DIRECTORY=${master_dir}
MASTER_PORT=5432
TRUSTED_SHELL=ssh
CHECK_POINT_SEGMENTS=8
ENCODING=UNICODE
MIRROR_PORT_BASE=7000
REPLICATION_PORT_BASE=8000
MIRROR_REPLICATION_PORT_BASE=9000
declare -a MIRROR_DATA_DIRECTORY=(${mirrorstr})
MACHINE_LIST_FILE=seghost
EOF
    chown gpadmin:gpadmin init.config
    expect <<EOF
    set timeout 1800
    spawn su - gpadmin
    expect -ex "]$"
    send "cd ${prefixdir};gpinitsystem -c init.config -s ${standby_hostname} \r"
    expect "(default=N):"
    sleep 1
    send "y\r"
    expect -ex "]$"
    send "exit\r"
    expect eof
EOF
    sleep 2
   

}

main()
{
   sh sshKey.sh gpadmin ${os_root_password} ${all_server}
   sethostsfile
   changedirowner
   initGp


}

echo "begin to init gpdb"
main
echo "init gpdb success"
