#!/bin/bash
#use:greenplumCheck conf fileType filePath
conf=$1
fileType=$2
filePath=$3

isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
prefixdir=`grep "prefixdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

master_server=`grep "master_server" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
master_dir=`grep "master_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

standby_server=`grep "standby_server" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
standby_dir=`grep "standby_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

seg_server=`grep "seg_server," ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_server_num=`grep "seg_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_data_dir=`grep "seg_data_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_mirror_data_dir=`grep "seg_mirror_data" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_dir_num=`grep "seg_dir_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

compile_flag=`grep "compile_flag" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`


seg_server_list=(`echo ${seg_server} |tr ';' ' '`)
seg_data_dir_list=(`echo ${seg_data_dir} |tr ';' ' '`)
seg_mirror_data_dir_list=(`echo ${seg_mirror_data_dir} |tr ';' ' '`)

toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
#mkdir ${tempDir}
depDir=${toolPath}/greenplumDep
cnfPath=""
installLog=${toolPath}/greenplumInstall.log

all_server="${seg_server};${master_server};${standby_server}"
all_server_list=(`echo ${all_server} |tr ';' ' '`)
#deduplication
all_server_list=(`echo ${all_server_list[@]} | sed 's/ /\n/g' | sort | uniq`)
all_server=`echo ${all_server_list[@]} | sed 's/ /;/g'`

SRCMD5=(
3d0f324b256bca0f86d871bfb1709866
)

RPMMD5=(
224fe19bc3e5cb418cfacab0d35c0d1d
)

# if ok return 0 ,else return 1
md5Check()
{
    cd ${toolPath}
    local value=`md5sum ${filePath} | awk '{print $1}'`
    if [ ${fileType} == "rpmdir" ];then
#       if echo "${RPMMD5[@]}" | grep -w ${value} &>/dev/null; then
#           echo "package md5 check success"
           return 0
#       fi

    fi

    if [ ${fileType} == "sourcedir" ];then
       if echo "${SRCMD5[@]}" |grep -w ${value} &>/dev/null; then
           echo "package md5 check success"
           return 0
       fi
    fi
    return 1

}



sshCheck()
{
    local remotehost=$1
        ping -c2 -W2 ${remotehost} &> /dev/null
        if [ $? -ne 0 ];then
            echo "can not connect host:${remotehost}"
            return 1
        fi
        expect <<-EOF
        set timeout 2
        spawn ssh ${os_root_user}@${remotehost}
        expect {
             "yes/no" {send "yes\r";exp_continue}
             "password:" {send "${os_root_password}\r"}
       }
       expect "password:" {
         exit 1
       }
       expect "]#"
       send "exit\r"
       expect eof
       exit 2
EOF

       if [ $? == 2 ];then
           echo "ssh connect ${remotehost} check success"
           return 0
       else
           echo "ssh connect ${remotehost} failed,please check the paasword"
           return 1
       fi

}

confCheck()
{
#    if [ ${fileType} == "sourcedir" ] && [ ! -d ${prefixdir} ];then
#        echo  "can not find prefixdir:${prefixdir}"
#        return 1
#    fi

    if [ ! -e ${isopath} ];then
        echo "can not find iso:${isopath}"
        return 1
    fi

    #check user and password
    for serverip in ${all_server_list[@]}
    do
        sshCheck ${serverip}
        if [ $? == 1 ]; then
             echo "ssh check to ${serverip} failed"
             return  1
        fi
    done
    cd ${toolPath}
    sh sshKey.sh ${os_root_user} ${os_root_password} ${all_server}
}

masterCheck()
{
    ssh  ${os_root_user}@${master_server} /bin/bash <<-EOF
if [ -d ${master_dir} ];then
exit 0
else
exit 1
fi
EOF
    if [ $? == 1 ];then
        echo "can not find master_dir: ${master_dir} in ${master_server}"
        return 1
    fi

    ssh ${os_root_user}@${master_server} /bin/bash <<-EOF
if [ ${fileType} == "sourcedir" ] && [ -d ${prefixdir} ];then
exit 0
else
exit 1
fi
EOF

    if [ ${fileType} == "sourcedir" ] && [ $? == 1 ];then
        echo "can not find prefixdir:${prefixdir} in ${master_server}"
        return 1
    fi



     ssh  ${os_root_user}@${master_server} /bin/bash <<-EOF
if [ -e ${isopath} ];then
exit 0
else
exit 1
fi
EOF
    if [ $? == 1 ];then
        echo "can not find iso:${isopath} in ${master_server}"
        return 1
    fi

   
}
standbyCheck()
{
    if [ ${master_dir}x != ${standby_dir}x ];then
        echo "master_dir:${master_dir} must be same as standby_dir:${standby_dir}"
        return 1
    fi
    ssh  ${os_root_user}@${standby_server} /bin/bash  <<-EOF
if [ -d ${standby_dir} ];then
exit 0
else
exit 1
fi
EOF
    if [ $? == 1 ];then
        echo "can not find ${standby_dir} in ${standby_server}"
        return 1
    fi

       ssh ${os_root_user}@${standby_server} /bin/bash <<-EOF
if [ ${fileType} == "sourcedir" ] && [ -d ${prefixdir} ];then
exit 0
else
exit 1
fi
EOF

    if [ ${fileType} == "sourcedir" ] && [ $? == 1 ];then
        echo "can not find prefixdir:${prefixdir} in ${standby_server}"
        return 1
    fi



    ssh  ${os_root_user}@${standby_server} /bin/bash <<-EOF
if [ -e ${isopath} ];then
exit 0
else
exit 1
fi
EOF
    if [ $? == 1 ];then
        echo "can not find iso:${isopath} in ${standby_server}"
        return 1
    fi


}
segCheck()
{
    if [ ${#seg_server_list[@]} != ${seg_server_num} ];then
        echo "seg_server_num not equal the total of seg_server ip "
        return 1
    fi

    if [ ${#seg_data_dir_list[@]} != ${seg_dir_num} ];then
        echo "seg_dir_num not equal the total of seg_data_dir"
        return 1
    fi


    if [ ${#seg_mirror_data_dir_list[@]} != ${seg_dir_num} ];then
         echo "seg_dir_num not equal the total of seg_mirror_dir"
         return 1
    fi

    for serverip in ${seg_server_list[@]}
    do
    ssh  ${os_root_user}@${serverip}  /bin/bash <<-EOF
for datadir in ${seg_data_dir_list[@]}
do
if [ ! -d \${datadir} ];then
exit 1
fi
done
for mirrordir in ${seg_mirror_data_dir_list[@]}
do
if [ ! -d \${mirrordir} ];then
exit 1
fi
done
exit 0
EOF
        if [ $? == 1 ];then
            echo "seg dir check failed,please mkdir first in ${serverip}"
            return 1
        fi

   ssh ${os_root_user}@${serverip} /bin/bash <<-EOF
if [ ${fileType} == "sourcedir" ] && [ -d ${prefixdir} ];then
exit 0
else
exit 1
fi
EOF

    if [ ${fileType} == "sourcedir" ] && [ $? == 1 ];then
        echo "can not find prefixdir:${prefixdir} in ${serverip}"
        return 1
    fi


    ssh  ${os_root_user}@${serverip} /bin/bash <<-EOF
if [ -e ${isopath} ];then
exit 0
else
exit 1
fi
EOF
    if [ $? == 1 ];then
        echo "can not find iso:${isopath} in ${serverip}"
        return 1
    fi

    done

}


# all server must set the different hostname
hostnameCheck()
{
   local masterhostname=`hostname`
   local masterhostname2=`ssh ${os_root_user}@${master_server} "hostname"`
   if [ ${masterhostname}x != ${masterhostname2}x ];then
       echo "you must run this install script in master server"
       return 1
   fi

    local hostnamearr=()
    for((i=0; i<${#all_server_list[@]}; i++))
    do
        local serverip=${all_server_list[${i}]}
        local hostname=`ssh ${os_root_user}@${serverip} "hostname"`
        if [ ${hostname}x == "localhostx" ] || [ ${hostname}x == "localhost.localdomainx" ];then
            echo "hostname does not set in server:${serverip}"
            return 1
        fi

        for name in ${hostnamearr[@]}
        do
             if [ ${hostname}x == ${name}x ];then
                 echo "hostname must be different"
                 return 1
             fi
        done
        hostnamearr[${i}]=${hostname}
    done
    return 0

}

packageCheck()
{
    cd ${depDir}
  # cmake package check
   local cmakepackage=`ls |grep -i cmake | wc -l`
   if [ ${cmakepackage} -ne 1 ];then
      echo "can not find cmake package in ${depDir}"
      return 1
   fi

   local depname=(setuptools psutil pbr lockfile pycparser cffi bcrypt six pynacl cryptography ipaddress enum34 paramiko zstd xerces re2c ninja gporca)
   for name in ${depname[@]}
   do
      local packageNum=`ls |grep -i ${name} |wc -l`
      if [ ${packageNum} -ne 1 ];then
          echo "can not find ${packageNum} package in ${depDir}"
          return 1
      fi
   done

   echo "dependency package check success"
   return 0
}


main()
{
    if [ ${compile_flag}x == "1x" ];then
        packageCheck
        if [ $? == 1 ];then
            echo "dependency package check failed"
            exit 0
        fi

        if [ ! -e ${isopath} ];then
            echo "can not find iso:${isopath}"
            exit 0
        fi

        md5Check
        if [ $? -eq 1 ]; then
            echo "package md5 check failed"
            exit 0
        fi
   else

        which expect
        if [ $? == 1 ];then
            echo "can not find command:expect,please install,check failed"
            return 1
        fi
        echo "begin check,please wait"
        md5Check
        if [ $? == 1 ];then
            echo "softpackage md5 check failed"
            return 1
        fi
        echo "md5check success"
    
        confCheck
        if [ $? == 1 ];then
            echo "conf check failed,please check the ip username password"
            return 1
        fi
        echo "conf check success"
    
        hostnameCheck
        if [ $? == 1 ];then
            echo "hostname check failed,please check"
            return 1
        fi
        echo "hostname check success"

        masterCheck
        if [ $? == 1 ];then
            echo "master server check failed"
            return 1
        fi
        echo "master check success"   

        standbyCheck
        if [ $? == 1 ];then
            echo "standby server check failed"
            return 1
        fi
        echo "standby check success"

        segCheck
        if [ $? == 1 ];then
            echo "seg server check failed"
            return 1
        fi
        echo "seg check success"

        echo "greenplum check success"
        return 0
    fi

}

main
