/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.io.InputStream;
import java.util.Properties;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class GDSExceptionHelper {
    private static final Logger log = LoggerFactory.getLogger(GDSExceptionHelper.class, false);
    private static final String MESSAGES = "isc_error_msg";
    private static final String SQLSTATES = "isc_error_sqlstates";
    private static Properties messages = new Properties();
    private static Properties sqlstates = new Properties();
    private static boolean initialized = false;

    private static void init() {
        GDSExceptionHelper.loadResource(MESSAGES, messages);
        GDSExceptionHelper.loadResource(SQLSTATES, sqlstates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadResource(String resource, Properties propeties) {
        try {
            String res = "/" + resource.replace('.', '/') + ".properties";
            InputStream in = GDSException.class.getResourceAsStream(res);
            if (in == null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                in = cl.getResourceAsStream(res);
            }
            if (in != null) {
                propeties.load(in);
            }
        }
        catch (Exception ex) {
            if (log != null) {
                log.info("Exception in init of GDSExceptionHelper", ex);
            }
        }
        finally {
            initialized = true;
        }
    }

    public static GDSMessage getMessage(int code) {
        if (!initialized) {
            GDSExceptionHelper.init();
        }
        return new GDSMessage(messages.getProperty("" + code, "No message for code " + code + " found."));
    }

    public static String getSQLState(int code) {
        String result;
        if (!initialized) {
            GDSExceptionHelper.init();
        }
        if ((result = sqlstates.getProperty(Integer.toString(code))) == null) {
            result = "HY000";
        }
        return result;
    }

    public static class GDSMessage {
        private String template;
        private String[] params;

        public GDSMessage(String template) {
            this.template = template;
            this.params = new String[this.getParamCount()];
        }

        public int getParamCount() {
            int count = 0;
            for (int i = 0; i < this.template.length(); ++i) {
                if (this.template.charAt(i) != '{') continue;
                ++count;
            }
            return count;
        }

        public void setParameter(int position, String text) {
            if (position < this.params.length) {
                this.params[position] = text;
            }
        }

        public String toString() {
            String message = this.template;
            for (int i = 0; i < this.params.length; ++i) {
                String param = "{" + i + "}";
                int pos = message.indexOf(param);
                if (pos <= -1) continue;
                String temp = message.substring(0, pos);
                temp = temp + (this.params[i] == null ? "" : this.params[i]);
                message = temp = temp + message.substring(pos + param.length());
            }
            return message;
        }
    }
}

