/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Formatter;

public class LoadDataWorker
implements Runnable {
    private int worker;
    private Connection dbConn;
    private jTPCCRandom rnd;
    private StringBuffer sb;
    private Formatter fmt;
    private boolean writeCSV = false;
    private String csvNull = null;
    private PreparedStatement stmtConfig = null;
    private PreparedStatement stmtItem = null;
    private PreparedStatement stmtWarehouse = null;
    private PreparedStatement stmtDistrict = null;
    private PreparedStatement stmtStock = null;
    private PreparedStatement stmtCustomer = null;
    private PreparedStatement stmtHistory = null;
    private PreparedStatement stmtOrder = null;
    private PreparedStatement stmtOrderLine = null;
    private PreparedStatement stmtNewOrder = null;
    private StringBuffer sbConfig = null;
    private Formatter fmtConfig = null;
    private StringBuffer sbItem = null;
    private Formatter fmtItem = null;
    private StringBuffer sbWarehouse = null;
    private Formatter fmtWarehouse = null;
    private StringBuffer sbDistrict = null;
    private Formatter fmtDistrict = null;
    private StringBuffer sbStock = null;
    private Formatter fmtStock = null;
    private StringBuffer sbCustomer = null;
    private Formatter fmtCustomer = null;
    private StringBuffer sbHistory = null;
    private Formatter fmtHistory = null;
    private StringBuffer sbOrder = null;
    private Formatter fmtOrder = null;
    private StringBuffer sbOrderLine = null;
    private Formatter fmtOrderLine = null;
    private StringBuffer sbNewOrder = null;
    private Formatter fmtNewOrder = null;

    LoadDataWorker(int worker, String csvNull, jTPCCRandom rnd) {
        this.worker = worker;
        this.csvNull = csvNull;
        this.rnd = rnd;
        this.sb = new StringBuffer();
        this.fmt = new Formatter(this.sb);
        this.writeCSV = true;
        this.sbConfig = new StringBuffer();
        this.fmtConfig = new Formatter(this.sbConfig);
        this.sbItem = new StringBuffer();
        this.fmtItem = new Formatter(this.sbItem);
        this.sbWarehouse = new StringBuffer();
        this.fmtWarehouse = new Formatter(this.sbWarehouse);
        this.sbDistrict = new StringBuffer();
        this.fmtDistrict = new Formatter(this.sbDistrict);
        this.sbStock = new StringBuffer();
        this.fmtStock = new Formatter(this.sbStock);
        this.sbCustomer = new StringBuffer();
        this.fmtCustomer = new Formatter(this.sbCustomer);
        this.sbHistory = new StringBuffer();
        this.fmtHistory = new Formatter(this.sbHistory);
        this.sbOrder = new StringBuffer();
        this.fmtOrder = new Formatter(this.sbOrder);
        this.sbOrderLine = new StringBuffer();
        this.fmtOrderLine = new Formatter(this.sbOrderLine);
        this.sbNewOrder = new StringBuffer();
        this.fmtNewOrder = new Formatter(this.sbNewOrder);
    }

    LoadDataWorker(int worker, Connection dbConn, jTPCCRandom rnd) throws SQLException {
        this.worker = worker;
        this.dbConn = dbConn;
        this.rnd = rnd;
        this.sb = new StringBuffer();
        this.fmt = new Formatter(this.sb);
        this.stmtConfig = dbConn.prepareStatement("INSERT INTO bmsql_config (  cfg_name, cfg_value) VALUES (?, ?)");
        this.stmtItem = dbConn.prepareStatement("INSERT INTO bmsql_item (  i_id, i_im_id, i_name, i_price, i_data) VALUES (?, ?, ?, ?, ?)");
        this.stmtWarehouse = dbConn.prepareStatement("INSERT INTO bmsql_warehouse (  w_id, w_name, w_street_1, w_street_2, w_city,   w_state, w_zip, w_tax, w_ytd) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.stmtStock = dbConn.prepareStatement("INSERT INTO bmsql_stock (  s_i_id, s_w_id, s_quantity, s_dist_01, s_dist_02,   s_dist_03, s_dist_04, s_dist_05, s_dist_06,   s_dist_07, s_dist_08, s_dist_09, s_dist_10,   s_ytd, s_order_cnt, s_remote_cnt, s_data) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.stmtDistrict = dbConn.prepareStatement("INSERT INTO bmsql_district (  d_id, d_w_id, d_name, d_street_1, d_street_2,   d_city, d_state, d_zip, d_tax, d_ytd, d_next_o_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.stmtCustomer = dbConn.prepareStatement("INSERT INTO bmsql_customer (  c_id, c_d_id, c_w_id, c_first, c_middle, c_last,   c_street_1, c_street_2, c_city, c_state, c_zip,   c_phone, c_since, c_credit, c_credit_lim, c_discount,   c_balance, c_ytd_payment, c_payment_cnt,   c_delivery_cnt, c_data) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,         ?, ?, ?, ?, ?, ?)");
        this.stmtHistory = dbConn.prepareStatement("INSERT INTO bmsql_history (  hist_id, h_c_id, h_c_d_id, h_c_w_id, h_d_id, h_w_id,   h_date, h_amount, h_data) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.stmtOrder = dbConn.prepareStatement("INSERT INTO bmsql_oorder (  o_id, o_d_id, o_w_id, o_c_id, o_entry_d,   o_carrier_id, o_ol_cnt, o_all_local) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        this.stmtOrderLine = dbConn.prepareStatement("INSERT INTO bmsql_order_line (  ol_o_id, ol_d_id, ol_w_id, ol_number, ol_i_id,   ol_supply_w_id, ol_delivery_d, ol_quantity,   ol_amount, ol_dist_info) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.stmtNewOrder = dbConn.prepareStatement("INSERT INTO bmsql_new_order (  no_o_id, no_d_id, no_w_id) VALUES (?, ?, ?)");
    }

    @Override
    public void run() {
        try {
            int job;
            while ((job = LoadData.getNextJob()) >= 0) {
                if (job == 0) {
                    this.fmt.format("Worker %03d: Loading ITEM", this.worker);
                    System.out.println(this.sb.toString());
                    this.sb.setLength(0);
                    this.loadItem();
                    this.fmt.format("Worker %03d: Loading ITEM done", this.worker);
                    System.out.println(this.sb.toString());
                    this.sb.setLength(0);
                    continue;
                }
                this.fmt.format("Worker %03d: Loading Warehouse %6d", this.worker, job);
                System.out.println(this.sb.toString());
                this.sb.setLength(0);
                this.loadWarehouse(job);
                this.fmt.format("Worker %03d: Loading Warehouse %6d done", this.worker, job);
                System.out.println(this.sb.toString());
                this.sb.setLength(0);
            }
            if (!this.writeCSV) {
                this.dbConn.close();
            }
        }
        catch (SQLException se) {
            while (se != null) {
                this.fmt.format("Worker %03d: ERROR: %s", this.worker, se.getMessage());
                System.err.println(this.sb.toString());
                this.sb.setLength(0);
                se = se.getNextException();
            }
        }
        catch (Exception e) {
            this.fmt.format("Worker %03d: ERROR: %s", this.worker, e.getMessage());
            System.err.println(this.sb.toString());
            this.sb.setLength(0);
            e.printStackTrace();
            return;
        }
    }

    private void loadItem() throws SQLException, IOException {
        if (this.writeCSV) {
            this.fmtConfig.format("warehouses,%d\n", LoadData.getNumWarehouses());
            this.fmtConfig.format("nURandCLast,%d\n", this.rnd.getNURandCLast());
            this.fmtConfig.format("nURandCC_ID,%d\n", this.rnd.getNURandCC_ID());
            this.fmtConfig.format("nURandCI_ID,%d\n", this.rnd.getNURandCI_ID());
            LoadData.configAppend(this.sbConfig);
        } else {
            this.stmtConfig.setString(1, "warehouses");
            this.stmtConfig.setString(2, "" + LoadData.getNumWarehouses());
            this.stmtConfig.execute();
            this.stmtConfig.setString(1, "nURandCLast");
            this.stmtConfig.setString(2, "" + this.rnd.getNURandCLast());
            this.stmtConfig.execute();
            this.stmtConfig.setString(1, "nURandCC_ID");
            this.stmtConfig.setString(2, "" + this.rnd.getNURandCC_ID());
            this.stmtConfig.execute();
            this.stmtConfig.setString(1, "nURandCI_ID");
            this.stmtConfig.setString(2, "" + this.rnd.getNURandCI_ID());
            this.stmtConfig.execute();
        }
        for (int i_id = 1; i_id <= 100000; ++i_id) {
            String iData;
            if (i_id != 1 && (i_id - 1) % 1000 == 0) {
                if (this.writeCSV) {
                    LoadData.itemAppend(this.sbItem);
                } else {
                    this.stmtItem.executeBatch();
                    this.stmtItem.clearBatch();
                }
            }
            if (this.rnd.nextInt(1, 100) <= 10) {
                int len = this.rnd.nextInt(26, 50);
                int off = this.rnd.nextInt(0, len - 8);
                iData = this.rnd.getAString(off, off) + "ORIGINAL" + this.rnd.getAString(len - off - 8, len - off - 8);
            } else {
                iData = this.rnd.getAString(26L, 50L);
            }
            if (this.writeCSV) {
                this.fmtItem.format("%d,%s,%.2f,%s,%d\n", i_id, this.rnd.getAString(14L, 24L), (double)this.rnd.nextLong(100L, 10000L) / 100.0, iData, this.rnd.nextInt(1, 10000));
                continue;
            }
            this.stmtItem.setInt(1, i_id);
            this.stmtItem.setInt(2, this.rnd.nextInt(1, 10000));
            this.stmtItem.setString(3, this.rnd.getAString(14L, 24L));
            this.stmtItem.setDouble(4, (double)this.rnd.nextLong(100L, 10000L) / 100.0);
            this.stmtItem.setString(5, iData);
            this.stmtItem.addBatch();
        }
        if (this.writeCSV) {
            LoadData.itemAppend(this.sbItem);
        } else {
            this.stmtItem.executeBatch();
            this.stmtItem.clearBatch();
            this.stmtItem.close();
            this.dbConn.commit();
        }
    }

    private void loadWarehouse(int w_id) throws SQLException, IOException {
        if (this.writeCSV) {
            this.fmtWarehouse.format("%d,%.2f,%.4f,%s,%s,%s,%s,%s,%s\n", w_id, 300000.0, (double)this.rnd.nextLong(0L, 2000L) / 10000.0, this.rnd.getAString(6L, 10L), this.rnd.getAString(10L, 20L), this.rnd.getAString(10L, 20L), this.rnd.getAString(10L, 20L), this.rnd.getState(), this.rnd.getNString(4L, 4L) + "11111");
            LoadData.warehouseAppend(this.sbWarehouse);
        } else {
            this.stmtWarehouse.setInt(1, w_id);
            this.stmtWarehouse.setString(2, this.rnd.getAString(6L, 10L));
            this.stmtWarehouse.setString(3, this.rnd.getAString(10L, 20L));
            this.stmtWarehouse.setString(4, this.rnd.getAString(10L, 20L));
            this.stmtWarehouse.setString(5, this.rnd.getAString(10L, 20L));
            this.stmtWarehouse.setString(6, this.rnd.getState());
            this.stmtWarehouse.setString(7, this.rnd.getNString(4L, 4L) + "11111");
            this.stmtWarehouse.setDouble(8, (double)this.rnd.nextLong(0L, 2000L) / 10000.0);
            this.stmtWarehouse.setDouble(9, 300000.0);
            this.stmtWarehouse.execute();
        }
        for (int s_i_id = 1; s_i_id <= 100000; ++s_i_id) {
            String sData;
            if (s_i_id != 1 && (s_i_id - 1) % 10000 == 0) {
                if (this.writeCSV) {
                    LoadData.warehouseAppend(this.sbWarehouse);
                } else {
                    this.stmtStock.executeBatch();
                    this.stmtStock.clearBatch();
                }
            }
            if (this.rnd.nextInt(1, 100) <= 10) {
                int len = this.rnd.nextInt(26, 50);
                int off = this.rnd.nextInt(0, len - 8);
                sData = this.rnd.getAString(off, off) + "ORIGINAL" + this.rnd.getAString(len - off - 8, len - off - 8);
            } else {
                sData = this.rnd.getAString(26L, 50L);
            }
            if (this.writeCSV) {
                this.fmtStock.format("%d,%d,%d,%d,%d,%d,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n", s_i_id, w_id, this.rnd.nextInt(10, 100), 0, 0, 0, sData, this.rnd.getAString(24L, 24L), this.rnd.getAString(24L, 24L), this.rnd.getAString(24L, 24L), this.rnd.getAString(24L, 24L), this.rnd.getAString(24L, 24L), this.rnd.getAString(24L, 24L), this.rnd.getAString(24L, 24L), this.rnd.getAString(24L, 24L), this.rnd.getAString(24L, 24L), this.rnd.getAString(24L, 24L));
                continue;
            }
            this.stmtStock.setInt(1, s_i_id);
            this.stmtStock.setInt(2, w_id);
            this.stmtStock.setInt(3, this.rnd.nextInt(10, 100));
            this.stmtStock.setString(4, this.rnd.getAString(24L, 24L));
            this.stmtStock.setString(5, this.rnd.getAString(24L, 24L));
            this.stmtStock.setString(6, this.rnd.getAString(24L, 24L));
            this.stmtStock.setString(7, this.rnd.getAString(24L, 24L));
            this.stmtStock.setString(8, this.rnd.getAString(24L, 24L));
            this.stmtStock.setString(9, this.rnd.getAString(24L, 24L));
            this.stmtStock.setString(10, this.rnd.getAString(24L, 24L));
            this.stmtStock.setString(11, this.rnd.getAString(24L, 24L));
            this.stmtStock.setString(12, this.rnd.getAString(24L, 24L));
            this.stmtStock.setString(13, this.rnd.getAString(24L, 24L));
            this.stmtStock.setInt(14, 0);
            this.stmtStock.setInt(15, 0);
            this.stmtStock.setInt(16, 0);
            this.stmtStock.setString(17, sData);
            this.stmtStock.addBatch();
        }
        if (this.writeCSV) {
            LoadData.stockAppend(this.sbStock);
        } else {
            this.stmtStock.executeBatch();
            this.stmtStock.clearBatch();
        }
        for (int d_id = 1; d_id <= 10; ++d_id) {
            int i;
            if (this.writeCSV) {
                this.fmtDistrict.format("%d,%d,%.2f,%.4f,%d,%s,%s,%s,%s,%s,%s\n", d_id, w_id, 30000.0, (double)this.rnd.nextLong(0L, 2000L) / 10000.0, 3001, this.rnd.getAString(6L, 10L), this.rnd.getAString(10L, 20L), this.rnd.getAString(10L, 20L), this.rnd.getAString(10L, 20L), this.rnd.getState(), this.rnd.getNString(4L, 4L) + "11111");
                LoadData.districtAppend(this.sbDistrict);
            } else {
                this.stmtDistrict.setInt(1, d_id);
                this.stmtDistrict.setInt(2, w_id);
                this.stmtDistrict.setString(3, this.rnd.getAString(6L, 10L));
                this.stmtDistrict.setString(4, this.rnd.getAString(10L, 20L));
                this.stmtDistrict.setString(5, this.rnd.getAString(10L, 20L));
                this.stmtDistrict.setString(6, this.rnd.getAString(10L, 20L));
                this.stmtDistrict.setString(7, this.rnd.getState());
                this.stmtDistrict.setString(8, this.rnd.getNString(4L, 4L) + "11111");
                this.stmtDistrict.setDouble(9, (double)this.rnd.nextLong(0L, 2000L) / 10000.0);
                this.stmtDistrict.setDouble(10, 30000.0);
                this.stmtDistrict.setInt(11, 3001);
                this.stmtDistrict.execute();
            }
            for (int c_id = 1; c_id <= 3000; ++c_id) {
                if (this.writeCSV) {
                    this.fmtCustomer.format("%d,%d,%d,%.4f,%s,%s,%s,%.2f,%.2f,%.2f,%d,%d,%s,%s,%s,%s,%s,%s,%s,%s,%s\n", c_id, d_id, w_id, (double)this.rnd.nextLong(0L, 5000L) / 10000.0, this.rnd.nextInt(1, 100) <= 90 ? "GC" : "BC", c_id <= 1000 ? this.rnd.getCLast(c_id - 1) : this.rnd.getCLast(), this.rnd.getAString(8L, 16L), 50000.0, -10.0, 10.0, 1, 0, this.rnd.getAString(10L, 20L), this.rnd.getAString(10L, 20L), this.rnd.getAString(10L, 20L), this.rnd.getState(), this.rnd.getNString(4L, 4L) + "11111", this.rnd.getNString(16L, 16L), new Timestamp(System.currentTimeMillis()).toString(), "OE", this.rnd.getAString(300L, 500L));
                } else {
                    this.stmtCustomer.setInt(1, c_id);
                    this.stmtCustomer.setInt(2, d_id);
                    this.stmtCustomer.setInt(3, w_id);
                    this.stmtCustomer.setString(4, this.rnd.getAString(8L, 16L));
                    this.stmtCustomer.setString(5, "OE");
                    if (c_id <= 1000) {
                        this.stmtCustomer.setString(6, this.rnd.getCLast(c_id - 1));
                    } else {
                        this.stmtCustomer.setString(6, this.rnd.getCLast());
                    }
                    this.stmtCustomer.setString(7, this.rnd.getAString(10L, 20L));
                    this.stmtCustomer.setString(8, this.rnd.getAString(10L, 20L));
                    this.stmtCustomer.setString(9, this.rnd.getAString(10L, 20L));
                    this.stmtCustomer.setString(10, this.rnd.getState());
                    this.stmtCustomer.setString(11, this.rnd.getNString(4L, 4L) + "11111");
                    this.stmtCustomer.setString(12, this.rnd.getNString(16L, 16L));
                    this.stmtCustomer.setTimestamp(13, new Timestamp(System.currentTimeMillis()));
                    if (this.rnd.nextInt(1, 100) <= 90) {
                        this.stmtCustomer.setString(14, "GC");
                    } else {
                        this.stmtCustomer.setString(14, "BC");
                    }
                    this.stmtCustomer.setDouble(15, 50000.0);
                    this.stmtCustomer.setDouble(16, (double)this.rnd.nextLong(0L, 5000L) / 10000.0);
                    this.stmtCustomer.setDouble(17, -10.0);
                    this.stmtCustomer.setDouble(18, 10.0);
                    this.stmtCustomer.setInt(19, 1);
                    this.stmtCustomer.setInt(20, 1);
                    this.stmtCustomer.setString(21, this.rnd.getAString(300L, 500L));
                    this.stmtCustomer.addBatch();
                }
                if (this.writeCSV) {
                    this.fmtHistory.format("%d,%d,%d,%d,%d,%d,%s,%.2f,%s\n", (w_id - 1) * 30000 + (d_id - 1) * 3000 + c_id, c_id, d_id, w_id, d_id, w_id, new Timestamp(System.currentTimeMillis()).toString(), 10.0, this.rnd.getAString(12L, 24L));
                    continue;
                }
                this.stmtHistory.setInt(1, (w_id - 1) * 30000 + (d_id - 1) * 3000 + c_id);
                this.stmtHistory.setInt(2, c_id);
                this.stmtHistory.setInt(3, d_id);
                this.stmtHistory.setInt(4, w_id);
                this.stmtHistory.setInt(5, d_id);
                this.stmtHistory.setInt(6, w_id);
                this.stmtHistory.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
                this.stmtHistory.setDouble(8, 10.0);
                this.stmtHistory.setString(9, this.rnd.getAString(12L, 24L));
                this.stmtHistory.addBatch();
            }
            if (this.writeCSV) {
                LoadData.customerAppend(this.sbCustomer);
                LoadData.historyAppend(this.sbHistory);
            } else {
                this.stmtCustomer.executeBatch();
                this.stmtCustomer.clearBatch();
                this.stmtHistory.executeBatch();
                this.stmtHistory.clearBatch();
            }
            int[] randomCID = new int[3000];
            for (i = 0; i < 3000; ++i) {
                randomCID[i] = i + 1;
            }
            for (i = 0; i < 3000; ++i) {
                int x = this.rnd.nextInt(0, 2999);
                int y = this.rnd.nextInt(0, 2999);
                int tmp = randomCID[x];
                randomCID[x] = randomCID[y];
                randomCID[y] = tmp;
            }
            for (int o_id = 1; o_id <= 3000; ++o_id) {
                int o_ol_cnt = this.rnd.nextInt(5, 15);
                if (this.writeCSV) {
                    this.fmtOrder.format("%d,%d,%d,%d,%s,%d,%d,%s\n", o_id, w_id, d_id, randomCID[o_id - 1], o_id < 2101 ? Integer.valueOf(this.rnd.nextInt(1, 10)) : this.csvNull, o_ol_cnt, 1, new Timestamp(System.currentTimeMillis()).toString());
                } else {
                    this.stmtOrder.setInt(1, o_id);
                    this.stmtOrder.setInt(2, d_id);
                    this.stmtOrder.setInt(3, w_id);
                    this.stmtOrder.setInt(4, randomCID[o_id - 1]);
                    this.stmtOrder.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                    if (o_id < 2101) {
                        this.stmtOrder.setInt(6, this.rnd.nextInt(1, 10));
                    } else {
                        this.stmtOrder.setNull(6, 4);
                    }
                    this.stmtOrder.setInt(7, o_ol_cnt);
                    this.stmtOrder.setInt(8, 1);
                    this.stmtOrder.addBatch();
                }
                for (int ol_number = 1; ol_number <= o_ol_cnt; ++ol_number) {
                    long now = System.currentTimeMillis();
                    if (this.writeCSV) {
                        this.fmtOrderLine.format("%d,%d,%d,%d,%d,%s,%.2f,%d,%d,%s\n", w_id, d_id, o_id, ol_number, this.rnd.nextInt(1, 100000), o_id < 2101 ? new Timestamp(now).toString() : this.csvNull, o_id < 2101 ? 0.0 : (double)this.rnd.nextLong(1L, 999999L) / 100.0, w_id, 5, this.rnd.getAString(24L, 24L));
                        continue;
                    }
                    this.stmtOrderLine.setInt(1, o_id);
                    this.stmtOrderLine.setInt(2, d_id);
                    this.stmtOrderLine.setInt(3, w_id);
                    this.stmtOrderLine.setInt(4, ol_number);
                    this.stmtOrderLine.setInt(5, this.rnd.nextInt(1, 100000));
                    this.stmtOrderLine.setInt(6, w_id);
                    if (o_id < 2101) {
                        this.stmtOrderLine.setTimestamp(7, new Timestamp(now));
                    } else {
                        this.stmtOrderLine.setNull(7, 93);
                    }
                    this.stmtOrderLine.setInt(8, 5);
                    if (o_id < 2101) {
                        this.stmtOrderLine.setDouble(9, 0.0);
                    } else {
                        this.stmtOrderLine.setDouble(9, (double)this.rnd.nextLong(1L, 999999L) / 100.0);
                    }
                    this.stmtOrderLine.setString(10, this.rnd.getAString(24L, 24L));
                    this.stmtOrderLine.addBatch();
                }
                if (o_id < 2101) continue;
                if (this.writeCSV) {
                    this.fmtNewOrder.format("%d,%d,%d\n", w_id, d_id, o_id);
                    continue;
                }
                this.stmtNewOrder.setInt(1, o_id);
                this.stmtNewOrder.setInt(2, d_id);
                this.stmtNewOrder.setInt(3, w_id);
                this.stmtNewOrder.addBatch();
            }
            if (this.writeCSV) {
                LoadData.orderAppend(this.sbOrder);
                LoadData.orderLineAppend(this.sbOrderLine);
                LoadData.newOrderAppend(this.sbNewOrder);
                continue;
            }
            this.stmtOrder.executeBatch();
            this.stmtOrder.clearBatch();
            this.stmtOrderLine.executeBatch();
            this.stmtOrderLine.clearBatch();
            this.stmtNewOrder.executeBatch();
            this.stmtNewOrder.clearBatch();
        }
        if (!this.writeCSV) {
            this.dbConn.commit();
        }
    }
}

