/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.firebirdsql.jdbc.FBCachedBlob;
import org.firebirdsql.jdbc.FBSQLException;

public class FBCachedClob
implements Clob {
    private FBCachedBlob wrappedBlob;
    private String javaEncoding;

    public FBCachedClob(FBCachedBlob blob, String javaEncoding) {
        this.wrappedBlob = blob;
        this.javaEncoding = javaEncoding;
    }

    @Override
    public void free() throws SQLException {
        this.wrappedBlob.free();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.wrappedBlob.getBinaryStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        InputStream inputStream = this.wrappedBlob.getBinaryStream();
        if (this.javaEncoding == null) {
            return new InputStreamReader(inputStream);
        }
        try {
            return new InputStreamReader(this.wrappedBlob.getBinaryStream(), this.javaEncoding);
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        InputStream inputStream = this.wrappedBlob.getBinaryStream(pos, length);
        if (this.javaEncoding == null) {
            return new InputStreamReader(inputStream);
        }
        try {
            return new InputStreamReader(inputStream, this.javaEncoding);
        }
        catch (IOException ioe) {
            throw new FBSQLException(ioe);
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        throw new FBSQLException("Not implemented");
    }

    @Override
    public long length() throws SQLException {
        throw new FBSQLException("Not implemented");
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw new FBSQLException("Not implemented");
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw new FBSQLException("Not implemented");
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new FBSQLException("Clob in auto-commit mode is read-only.");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw new FBSQLException("Clob in auto-commit mode is read-only.");
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        throw new FBSQLException("Clob in auto-commit mode is read-only.");
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new FBSQLException("Clob in auto-commit mode is read-only.");
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.wrappedBlob.truncate(len);
    }
}

