#!/bin/bash

#Download Docker pack
echo "/****Download install pack docker-18.09.8.tgz as default.****/"
#echo -e "/****\033[33mfunc name:PackDownload para:          \033[0m****/"

prefix="https://download.docker.com/linux/static/stable/aarch64/"
DOCKERPACK="docker-18.09.8.tgz"


kubeversion="1.15.2"
cniversion="0.7.5"
corednsversion="1.3.1"
etcdversion="3.3.10"
pauseversion="3.1"
flannelversion="v0.11.0-arm64"
# download install
OPTION="download"



if [ $# -eq 1 ]; then
  OPTION="$1"
elif [ $# -eq 2 ]; then
  DOCKERPACK="$2"
  OPTION="$1"
fi

wget "$prefix$DOCKERPACK"

mkdir $PWD/docker
mv -f  $DOCKERPACK $PWD/docker/$DOCKERPACK

if [ $OPTION = "install" ]; then
	chmod 777 docker-installer.sh
	./docker-installer.sh $PWD/docker/$DOCKERPACK
fi

cp docker-installer.sh $PWD/docker/docker-installer.sh


###
###
###yum repo for K8S###

YumRepo(){
cat <<EOF > /etc/yum.repos.d/kubernetes.repo  
[kubernetes] 
name=Kubernetes  
baseurl=https://mirrors.aliyun.com/kubernetes/yum/repos/kubernetes-el7-aarch64 
enabled=1  
gpgcheck=1  
repo_gpgcheck=1  
gpgkey=http://mirrors.aliyun.com/kubernetes/yum/doc/yum-key.gpg 
        http://mirrors.aliyun.com/kubernetes/yum/doc/rpm-package-key.gpg 
EOF
}


####download basic component###

YumDownload(){
	mkdir K8Srpm
	yum install --downloadonly --downloaddir=$PWD/K8Srpm kubelet-$kubeversion kubeadm-$kubeversion kubectl-$kubeversion kubernetes-cni-$cniversion 
}




#####infra component download#####

DockerPull(){
	docker pull docker.io/mirrorgooglecontainers/kube-apiserver-arm64:v$kubeversion
	docker pull docker.io/mirrorgooglecontainers/kube-controller-manager-arm64:v$kubeversion
	docker pull docker.io/mirrorgooglecontainers/kube-scheduler-arm64:v$kubeversion
	docker pull docker.io/mirrorgooglecontainers/kube-proxy-arm64:v$kubeversion
	docker pull docker.io/mirrorgooglecontainers/pause-arm64:$pauseversion  
	docker pull docker.io/mirrorgooglecontainers/etcd-arm64:$etcdversion  
	docker pull docker.io/coredns/coredns:$corednsversion
	docker tag docker.io/mirrorgooglecontainers/kube-apiserver-arm64:v$kubeversion k8s.gcr.io/kube-apiserver:v$kubeversion
	docker tag docker.io/mirrorgooglecontainers/kube-controller-manager-arm64:v$kubeversion k8s.gcr.io/kube-controller-manager:v$kubeversion
	docker tag docker.io/mirrorgooglecontainers/kube-scheduler-arm64:v$kubeversion k8s.gcr.io/kube-scheduler:v$kubeversion
	docker tag docker.io/mirrorgooglecontainers/kube-proxy-arm64:v$kubeversion k8s.gcr.io/kube-proxy:v$kubeversion
	docker tag docker.io/mirrorgooglecontainers/pause-arm64:$pauseversion k8s.gcr.io/pause:$pauseversion  
	docker tag docker.io/mirrorgooglecontainers/etcd-arm64:$etcdversion k8s.gcr.io/etcd:$etcdversion  
	docker tag docker.io/coredns/coredns:$corednsversion k8s.gcr.io/coredns:$corednsversion
	docker rmi docker.io/mirrorgooglecontainers/kube-apiserver-arm64:v$kubeversion
	docker rmi docker.io/mirrorgooglecontainers/kube-controller-manager-arm64:v$kubeversion
	docker rmi docker.io/mirrorgooglecontainers/kube-scheduler-arm64:v$kubeversion
	docker rmi docker.io/mirrorgooglecontainers/kube-proxy-arm64:v$kubeversion
	docker rmi docker.io/mirrorgooglecontainers/pause-arm64:$pauseversion  
	docker rmi docker.io/mirrorgooglecontainers/etcd-arm64:$etcdversion  
	docker rmi docker.io/coredns/coredns:$corednsversion
	docker pull quay.io/coreos/flannel:$flannelversion
	mkdir K8Simages
	docker save -o $PWD/K8Simages/kube-api.rar k8s.gcr.io/kube-apiserver:v$kubeversion  
	docker save -o $PWD/K8Simages/kube-controller.rar k8s.gcr.io/kube-controller-manager:v$kubeversion
	docker save -o $PWD/K8Simages/kube-scheduler.rar k8s.gcr.io/kube-scheduler:v$kubeversion
	docker save -o $PWD/K8Simages/kube-proxy.rar k8s.gcr.io/kube-proxy:v$kubeversion
	docker save -o $PWD/K8Simages/pause.rar k8s.gcr.io/pause:$pauseversion  
	docker save -o $PWD/K8Simages/etcd.rar k8s.gcr.io/etcd:$etcdversion  
	docker save -o $PWD/K8Simages/coredns.rar k8s.gcr.io/coredns:$corednsversion
	docker save -o $PWD/K8Simages/flannel.rar quay.io/coreos/flannel:$flannelversion 
}


####env files####




####network####
NetproGet(){
	wget https://raw.githubusercontent.com/coreos/flannel/master/Documentation/kube-flannel.yml
}




####bitty main####
BittyK8S(){
	YumRepo
	YumDownload
	DockerPull
	#NetproGet
}


BittyK8S
