#!/bin/sh

function killproc()
{
    awk '{printf "%s %s\n",$2,$8}' |
    while read psId psCmd
    do    
        printf "Kill(%s) %s\n" $psId $psCmd    
        kill -9 $psId &
    done
}

function get_ambari_agents()
{
	curl -u admin:admin -H "X-Requested-By: ambari" -X GET http://${AMBARI_MASTER}:8080/api/v1/hosts
}

#-------------------------------------------------------------------
# replace(source, which, to)
# In POSIX sh, string replacement ${VB//,/ } is not supported . 
# Returns replaced string.
#-------------------------------------------------------------------
replace() {
    string="$1"
    which="$2"
    to="$3"
    result=$(echo $string | sed -e "s/${which}/${to}/g")
	echo ${result}
}

function uninstall_ambari_server()
{
	ambari-server stop
	yum erase -y ambari-server
	rm -rf /opt/ibm/ambari
	rm -rf /etc/ambari-server
	
	rm -rf /var/log/ambari-server
	
	rm -rf /var/lib/pgsql*
	rm -rf /var/lib/ambari-server
	rm -rf /usr/lib/ambari-server
	rm -rf /var/run/ambari-server
	
	unlink /usr/lib/python2.6/site-packages/ambari_commons
	unlink /usr/lib/python2.6/site-packages/resource_management
	unlink /usr/lib/python2.6/site-packages/ambari_jinja2
	unlink /usr/lib/python2.6/site-packages/ambari_simplejson
	rm -rf /usr/lib/python2.6/site-packages/ambari_agent
	rm -rf /usr/lib/python2.6/site-packages/ambari_server
	rm -rf /usr/lib/python2.6/site-packages/resource_monitoring
	
}

function uninstall_ambari_agent()
{
	ambari-agent stop
	ps -ef | grep Ambari | killproc
	ps -ef | grep ambari | killproc
        ps -ef | grep /usr/hdp | killproc
	ps -ef | grep resource_monitoring/main.py | killproc
	#python /usr/lib/python2.6/site-packages/ambari_agent/HostCleanup.py --silent --skip=users -f /etc/ambari-agent/conf/HostCleanup.ini,/etc/ambari-agent/conf/HostCleanup_Custom_Actions.ini -o /tmp/cleanup.log
	python /usr/lib/python2.6/site-packages/ambari_agent/HostCleanup.py --silent --skip=users
	
#yum erase -y ambari-metrics* bigtop* extjs* flume* hadoop* hbase* hive* iop-select* knox* oozie* perl-Crypt-DES* perl-Net-SNMP* perl-rrdtool* python-rrdtool* pig* rrdtool* slider* solr* spark* sqoop* storm* zookeeper* kafka* fping* libconfuse* --setopt=tsflags=noscripts
	
	rpms=ambari,hadoop,hbase,hive,spark,zookeeper,pig,sqoop,oozie,kafka,slider,knox,flume,solr,falcon,accumulo,mahout,storm,tez,atlas
	#for _rpm in ${rpms//,/ }; 
	for _rpm in $(replace "${rpms}" "," " ")
	do
		yum erase -y  ${_rpm}*
	done
        
        RPM_NAME="ambari|hadoop|hbase|hive|spark|zookeeper|pig|sqoop|oozie|kafka|slider|knox|flume|solr|falcon|accumulo|mahout|storm|tez|atlas"
	#call rpm erase to ensure the package will be removed
	RPMLIST=$(rpm -qa|grep -E "$RPM_NAME"|awk '{ print $1 }')
	if [[ -z "$RPMLIST" ]];then
		echo "No $RPM_NAME regex installed"
	else
		for RPML in $RPMLIST
		do
			sudo rpm -e $RPML --noscripts > /dev/null 2>&1
		done
	fi
	
	#utils
	utils_rpms=phoenix,ranger,bigtop,extjs,snappy,hdp-select,postgresql
	for _rpm in $(replace "${utils_rpms}" "," " ") 
	do
		yum erase -y  ${_rpm}*
	done
	yum erase -y mysql* mysql-devl mysql-server
	yum erase -y ambari-agent
	yum remove -y smartsense-hst
	
	#rm
	servers=ambari-metrics,ambari-agent,ambari,hadoop,hadoop-hdfs,hadoop-mapreduce,hadoop-yarn,hbase,spark,zookeeper,hive,oozie,pig,sqoop,kafka,slider,knox,flume,falcon,solr,accumulo,accumulo,mahout,tez
	#for _server in ${servers//,/ }; 
	for _server in $(replace "${servers}" "," " ")
	do
			#eval "rm -rf /var/lib/${_server}*"
			rm -rf /var/lib/${_server}*
			rm -rf /var/log/${_server}*
			rm -rf /var/run/${_server}*
			rm -rf /etc/${_server}*
	done
	rm -rf /tmp/*
	#full clean
	rm -rf /etc/rc.d/init.d/ambari-agent
	
	rm -rf /usr/lib/ambari-agent
	rm -rf /usr/lib/python2.6/site-packages/ambari_agent
	rm -rf /usr/lib/python2.6/site-packages/resource_monitoring
	rm -rf /usr/sbin/ambari-agent
        rm -rf /usr/lib/ambari*	
	rm -rf /usr/hdp
    #####################klh################
        rm -rf /var/lib/smartsense/
        rm -rf /var/log/hst
        rm -fr /etc/hst/
        rm -fr /usr/lib/flume
        rm -fr /usr/lib/storm
        
        rm -rf /data1/hadoop
        rm -rf /data2/hadoop
        rm -f /usr/bin/ranger-*        	
	unlink /usr/lib/python2.6/site-packages/ambari_commons
	unlink /usr/lib/python2.6/site-packages/resource_management
	unlink /usr/lib/python2.6/site-packages/ambari_jinja2
	unlink /usr/lib/python2.6/site-packages/ambari_simplejson
	
	#user bin
	for lns in $(ls -all /usr/bin | grep "/usr/iop" | awk '{print $9}') ;
	do 
		if [ ! -z ${lns} ]; then 
			echo "rm -rf /usr/bin/$lns"; 
			rm -rf /usr/bin/$lns
		fi 
	done
	
}

function uninstall_ambari()
{
	ambari-server stop
	#for agent in ${AMBARI_AGENTS//,/ } ; 

	#for agent in $(replace "${AMBARI_AGENTS}" "," " ")
	#do
	##	gLog 3 Info "uninstall_ambari_agent on agent $agent ..."
	#	ssh $agent "${TEST_WORKDIR}/framework/ambari/${CLUSTER_TYPE}/main.s uninstall_ambari_agent"	
	#)&
	#done
	#wait
	uninstall_ambari_agent
	uninstall_ambari_server
	removeServiceAccounts
	rm -fr /hadoop/
}

function removeServiceAccounts()
{
	users=hbase,ambari-qa,ams,hcat,hdfs,hive,kafka,mapred,oozie,spark,sqoop,tez,yarn,zookeeper,accumulo,atlas,falcon,flume,knox,mahout,storm,livy,yarn-ats
	for _user in $(replace "${users}" "," " ")
	do
			userdel -r -f ${_user}
			rm -fr /etc/security/limits.d/${_user}.conf
	done
}

function removeRepo()
{
	#rm repo
	rm -rf /etc/yum.repos.d/HDP*
	rm -rf /etc/yum.repos.d/ambari*
	
	yum clean metadata
	yum clean all
}


uninstall_ambari
