#!/usr/bin/bash

set -e

systemctl stop firewalld
yum install vconfig net-tools -y
nmcli conn add type vlan con-name $1.1011 dev $1 id 1011 ipv4.method manual ipv4.address 9.88.14.6/24 gw4 9.88.14.1 autoconnect yes
nmcli conn add type vlan con-name $1.1012 dev $1 id 1012 ipv4.method manual ipv4.address 9.88.15.6/24 gw4 9.88.15.1 autoconnect yes

yum install -y librados2 ceph
pip install prettytable ceph-deploy
pip3 install iniparse
sed -i "/distributions = {/s/$/\n        'openeuler': fedora,/g" /lib/python2.7/site-packages/ceph_deploy/hosts/__init__.py
crudini --set /etc/yum.repos.d/openEuler.repo update enabled 1
ceph-deploy new storager
crudini --set /etc/ceph/ceph.conf global public_network 9.88.15.0/24
crudini --set /etc/ceph/ceph.conf global public_network 9.88.15.0/24
crudini --set /etc/ceph/ceph.conf mon mon_allow_pool_delete true

ceph-deploy mon create-initial
ceph-deploy --overwrite-conf admin storager controller compute01 compute02
ceph-deploy mgr create storager

ceph-volume lvm zap /dev/$2 --destroy
ceph-volume lvm zap /dev/$3 --destroy
ceph-volume lvm zap /dev/$4 --destroy

ceph-deploy osd create storager --data /dev/$2
ceph-deploy osd create storager --data /dev/$3
ceph-deploy osd create storager --data /dev/$4

ceph osd pool create volumes 32
ceph osd pool create images 32
ceph osd pool create backups 32
ceph osd pool create vms 32

ceph osd getcrushmap -o /etc/ceph/crushmap
crushtool -d /etc/ceph/crushmap -o /etc/ceph/crushmap.txt
sed -i 's/step chooseleaf firstn 0 type host/step chooseleaf firstn 0 type osd/' /etc/ceph/crushmap.txt
grep 'step chooseleaf' /etc/ceph/crushmap.txt
crushtool -c /etc/ceph/crushmap.txt -o /etc/ceph/crushmap-new
ceph osd setcrushmap -i /etc/ceph/crushmap-new

ceph osd pool application enable volumes rbd
ceph osd pool application enable images rbd
ceph osd pool application enable backups rbd
ceph osd pool application enable vms rbd

ceph auth get-or-create client.cinder mon 'allow r' osd 'allow class-read object_prefix rbd_children, allow rwx pool=volumes, allow rwx pool=vms, allow rx pool=images'
ceph auth get-or-create client.glance mon 'allow r' osd 'allow class-read object_prefix rbd_children, allow rwx pool=images'
ceph auth get-or-create client.cinder-backup mon 'profile rbd' osd 'profile rbd pool=backups'
ceph auth get-or-create client.glance | ssh controller tee /etc/ceph/ceph.client.glance.keyring
ssh controller chown glance:glance /etc/ceph/ceph.client.glance.keyring

ceph auth get-or-create client.cinder | ssh compute01 tee /etc/ceph/ceph.client.cinder.keyring
ssh compute01 chown cinder:cinder /etc/ceph/ceph.client.cinder.keyring
ceph auth get-or-create client.cinder-backup | ssh compute01 tee /etc/ceph/ceph.client.cinder-backup.keyring
ssh compute01 chown cinder:cinder /etc/ceph/ceph.client.cinder-backup.keyring
ceph auth get-key client.cinder | ssh compute01 tee client.cinder.key

ceph auth get-or-create client.cinder | ssh compute02 tee /etc/ceph/ceph.client.cinder.keyring
ssh compute02 chown cinder:cinder /etc/ceph/ceph.client.cinder.keyring
ceph auth get-or-create client.cinder-backup | ssh compute02 tee /etc/ceph/ceph.client.cinder-backup.keyring
ssh compute02 chown cinder:cinder /etc/ceph/ceph.client.cinder-backup.keyring
ceph auth get-key client.cinder | ssh compute02 tee client.cinder.key
