let pc;                // PeerConnection
let remoteStream;      // RemoteMedia Stream
let turnReady;         // Turn Server
let dataWebSocket;     // WebSocket Objective
let remoteVideo;       // RemoteVideo Track
let remoteAudio;
let candidateDone = false;
let dataChannel = null;
let intervalID = null;
let first = true;

let pcConfig = {
    'iceServers': [
        {'urls': 'stun:stun.stunprotocol.org:3478'},
        {'urls': 'stun:stun.l.google.com:19302'},
    ]
};

window.onload = layoutInit;                // 网页完毕 自动触发该函数
window.onbeforeunload = uninit;      // 刷新/关闭网页的时候触发，提示用户

function layoutInit() {
    let css = document.getElementById("cssId");
    css.setAttribute("href", "../css/login.css");
    if (localStorage.getItem("ip")){
        $("ip").value =(localStorage.getItem("ip"));
    }
    if (localStorage.getItem("ip")){
        $("port").value =(localStorage.getItem("port"));
    }
}

function init(ip, port) {
    console.log('Main: init.');
    remoteVideo = document.querySelector('video#video');
    remoteAudio = document.querySelector('audio#Audio');
    const isMobile = () => {
        return /(iPhone|iPad|iPod|iOS|Android|Linux armv8l|Linux armv7l|Linux aarch64)/i.test(navigator.platform);
    };
    if (isMobile()) {
        remoteAudio.controls = false;
    }
    webSocketInit(ip, port);
    // turnInit();      // 什么都没干
}

// body自动缩放
function bodySize() {
    let body = document.getElementById("body");
    let size = window.screen.height / 1080;
    // console.log("size: " + size);
    // console.log("window.screen.height: " + window.screen.height);
    let computedSize = 100 / size + '%';
    // console.log("computedSize: " + computedSize);
    body.setAttribute('transform', 'scale(' + size + ')');
    body.setAttribute('transform-origin', '0 0');
    body.setAttribute('width', computedSize);
    body.setAttribute('height', computedSize);
}

function getStats() {
    bodySize();
    if (pc == null)
        return;
    if (first) {
        performClick(remoteVideo)
    }
    pc.getStats().then(stats => {
        stats.forEach(report => {
            let statsOutput = "";
            // console.log("report.frameWidth: " + report.frameWidth)
            if (report.type === "inbound-rtp" && report.kind === "video") {
                if (report.frameWidth === 1080 && first) {
                    let scale = document.getElementById("body");
                    let statBox = document.getElementById("stats-box");
                    let resolution = document.getElementById("resolution");
                    statBox.style.fontSize = '34px';
                    resolution.style.fontSize = '34px';
                    scale.style.transform = "scale(" + 0.55 + ")";
                    first = false;
                }
                statsOutput = `fps: ${report.framesPerSecond}`;
                document.getElementById('stats-box').innerHTML = statsOutput;
            }
        });
    });
}

function getScaleValue() {
    let body = document.getElementById("body");
    let bodySt = window.getComputedStyle(body, null);
    let bodyTr = bodySt.getPropertyValue("-webkit-transform") ||
        bodySt.getPropertyValue("-moz-transform") ||
        bodySt.getPropertyValue("-ms-transform") ||
        bodySt.getPropertyValue("-o-transform") ||
        bodySt.getPropertyValue("transform") ||
        "FAIL";
    let values = bodyTr.split('(')[1].split(')')[0].split(',');
    let a = values[0];
    let b = values[1];
    let c = values[2];
    let d = values[3];
    let scale = Math.sqrt(a * a + b * b);
    scaleValue = scale;
}


function uninit() {
    console.log('Main: uninit');
    webSocketUninit();
    varUninit();
    document.getElementById("btn").removeAttribute("disabled");
    if (pc == null) {
        pc = null;
    }
}

function varUninit() {
    remoteStream = null;
}

// 初始化一个websocker对应，绑定对应方法 并且升级为websocket网络协议
function webSocketInit(ipValue, portValue) {
    console.log('WebSocket: init.');
    console.log('WebSocket: init.ip:' + ipValue);
    console.log('WebSocket: init.port:' + portValue);
    dataWebSocket = new WebSocket("ws://" + ipValue + ":" + portValue + "/cloudPhone");
    dataWebSocket.onopen = onWsOpen;
    dataWebSocket.onclose = onWsClose;
    dataWebSocket.onerror = onWsError;
    dataWebSocket.onmessage = onWsMessage;
}

// 销毁websocket
function webSocketUninit() {
    console.log('WebSocket: uninit.');

    sendMessage('{"type":"bye"}');
    dataWebSocket.close();

    dataChannel.close();
    dataChannel = null;

    remoteStream = null;
    dataWebSocket = null;
    remoteVideo = null;
    // remoteAudio = null;
}

// 打开websocket通道，同时发送join信号给server
function onWsOpen(event) {
    console.log("WebSocket: opened");
    sendMessage('{"type":"join"}');
    dataWebSocket.interval = setInterval(sendHeartBeat, 500);
}

function sendHeartBeat() {
    sendMessage('{"type":"heartbeat"}');
}

// 关闭websocket
function onWsClose(event) {
    clearInterval(dataWebSocket.interval);
    console.log('WebSocket: closed.');
    destroyPeerConnection();
}

// 打印错误信息
function onWsError(error) {
    console.log("WebSocket: error: " + error.message);
    let css = document.getElementById("cssId");
    css.setAttribute("href", "../css/main.css");
    alert("websocket 连接失败");
}

// websocket 接收到数据,根据不同的type找不同的函数进行处理
function onWsMessage(event) {
    console.log('WebSocket: received message:', event);

    let message = JSON.parse(event.data);
    console.log('type:', message.type);
    if (message.type === 'sdp') {
        handleSdpMessage(message);
    } else if (message.type === 'ice') {
        handleIceMessage(message);
    } else if (message.type === 'bye') {
        handleRemoteHangup();
    }
}

// 处理来自Server端的SDP
function handleSdpMessage(message) {
    if (message.sdp.type === 'offer') {
        createPeerConnection();
        pc.setRemoteDescription(new RTCSessionDescription(message.sdp));
        console.log('do answer');
        doAnswer();
    }
    if (message.sdp.type === 'answer') {
        pc.setRemoteDescription(new RTCSessionDescription(message.sdp));
    }
}

// 创建RTPPeerConnection对象
function createPeerConnection() {
    console.log('WebRTC: create RTCPeerConnnection.');

    try {
        pc = new RTCPeerConnection(pcConfig);
        // 添加三个处理candidate、接收新的stream、移除stream的回调函数
        pc.onicecandidate = handleIceCandidate;
        pc.ontrack = handleRemoteTrack;
        pc.onremovestream = handleRemoteStreamRemoved;
        pc.onconnectionstatechange = handleConnectionStateChange;
        pc.onnegotiationneeded = handleNegotiationneeded;
        dataChannel = pc.createDataChannel("control stream");
        dataChannel.onopen = onDataChannelOpen;
        dataChannel.onclose = onDataChannelClose;
        intervalID = setInterval(getStats, 500);
    } catch (e) {
        console.log('WebRTC: Failed to create PeerConnection, exception: ' + e.message);
        return;
    }
}

// 销毁p2p连接
function destroyPeerConnection() {
    console.log('WebRTC: destroy RTCPeerConnnection.');
    if (pc == null)
        return;
    pc.close();
    pc = null;
    intervalID = null;
}

// 创建answer
function doAnswer() {
    console.log('WebRTC: create answer.');
    // 创建自身answer，设置localDescription并发送answer给server
    pc.createAnswer().then(
        setLocalAndSendMessage,
        onCreateSessionDescriptionError
    );
}

function doCall() {
    console.log('WebRTC: create offer.');
    pc.createOffer().then(
        setLocalAndSendMessage,
        onCreateSessionDescriptionError
    );
}

function onDataChannelOpen(event) {
    console.log('WebRTC: datachannel open');
    mouseInit(dataChannel, pc);
    // keyboardInit(dataChannel);
}

function onDataChannelClose(event) {
    console.log('WebRTC: datachannel close');
    mouseUninit();
    // keyboardUninit();
}

// 设置LocalDescription和发送answer
function setLocalAndSendMessage(sessionDescription) {
    pc.setLocalDescription(sessionDescription);
    sendSdpMessage(sessionDescription);
}

// 发送自身的SDP
function sendSdpMessage(message) {
    console.log('WebSocket: client sending message: ', message);
    sendMessage(JSON.stringify(message));
}

//创建answer失败的回调函数
function onCreateSessionDescriptionError(error) {
    console.log('WebRTC: failed to create session description: ' + error.toString());
}

function handleNegotiationneeded(event) {
    console.log('WebRTC: handleNegotiationneeded');
    doCall();
}

function handleConnectionStateChange(event) {
    console.log(dataChannel);
    switch (pc.connectionState) {
        case "new":
        case "connecting":
            console.log("WebRTC: Connecting…");
            break;
        case "connected":
            console.log("WebRTC: Online");
            break;
        case "disconnected":
            console.log("WebRTC: Disconnecting…");
            break;
        case "closed":
            console.log("WebRTC: Offline");
            break;
        case "failed":
            console.log("WebRTC: Error");
            break;
        default:
            console.log("WebRTC: Unknown");
            break;
    }
}

function performClick(element) {
    let evt1 = new MouseEvent("initStatus", {
        view: window,
        bubbles: true,
        cancelable: false,
        clientX: 475,
        clientY: 475,
        screenX: -1676,
        screenY: 444
        /* whatever properties you want to give it */
    });
    let b = element.dispatchEvent(evt1);
    let evt2 = new MouseEvent("initStatus", {
        view: window,
        bubbles: true,
        cancelable: false,
        clientX: 475,
        clientY: 475,
        screenX: -1676,
        screenY: 444
        /* whatever properties you want to give it */
    });
    element.dispatchEvent(evt2);
}


// 接收来自Server的IceCandidate，往PeerConnection对象加入Candidate
function handleIceMessage(message) {
    // if (candidateDone) {
    //     return;
    // }
    if (message.ice.type === 'candidate') {
        console.log("WebRTC: recived candidate");
        let candidate = new RTCIceCandidate({
            sdpMLineIndex: message.ice.label,
            candidate: message.ice.candidate
        });
        // 注入candidate成功/失败的回调函数
        pc.addIceCandidate(candidate).then(onAddIceCandidateSuccess, onAddIceCandidateError);
        candidateDone = true;
    }
}

function onAddIceCandidateSuccess() {
    console.log('WebRTC: Ice candidate successfully added.');
}

function onAddIceCandidateError(error) {
    console.log('WebRTC: failed to add ice candidate: ' + error.toString());
}

// 发送自身的IceCandidate给Server
function sendIceMessage(message) {
    console.log('WebSocket: client sending message: ', message);
    sendMessage(JSON.stringify(message))
}

// 回调 webrtc会收集candidate，如果有新的就会触发这个回调函数
function handleIceCandidate(event) {
    console.log('WebRTC: icecandidate event: ', event);
    if (event.candidate) {
        sendIceMessage({
            // type: 'candidate',
            label: event.candidate.sdpMLineIndex,
            id: event.candidate.sdpMid,
            candidate: event.candidate.candidate
        });
    } else {
        console.log('WebRTC: end of candidates.');
    }
}

function turnInit() {
//TODO
//    if (location.hostname !== 'localhost') {
//        requestTurn(
//            'https://computeengineondemand.appspot.com/turn?username=41784574&key=4080218913'
//        );
//    }
}

// function requestTurn(turnURL) {
//     let turnExists = false;
//     for (let i in pcConfig.iceServers) {
//         if (pcConfig.iceServers[i].urls.substr(0, 5) === 'turn:') {
//             turnExists = true;
//             turnReady = true;
//             break;
//         }
//     }
//     if (!turnExists) {
//         console.log('WebRTC: getting TURN server from ', turnURL);
//         // No TURN server. Get one from computeengineondemand.appspot.com:
//         let xhr = new XMLHttpRequest();
//         xhr.onreadystatechange = function() {
//             if (xhr.readyState === 4 && xhr.status === 200) {
//                 let turnServer = JSON.parse(xhr.responseText);
//                 console.log('Got TURN server: ', turnServer);
//                 pcConfig.iceServers.push({
//                     'urls': 'turn:' + turnServer.username + '@' + turnServer.turn,
//                     'credential': turnServer.password
//                 });
//                 turnReady = true;
//             }
//         };
//         xhr.open('GET', turnURL, true);
//         xhr.send();
//     }
// }
// 处理新来的视频数据源
function handleRemoteTrack(event) {
    console.log('WebRTC: remote stream added.');
    console.log(event);
    // 获取视频流对象

    if (event.streams && event.streams[0]) {
        console.log('WebRTC: remote stream exits.');
        remoteVideo.srcObject = event.streams[0];
        remoteAudio.srcObject = event.streams[0];
    } else {
        if (!inboundStream) {
            inboundStream = new MediaStream();
            remoteVideo.srcObject = inboundStream;
            remoteAudio.srcObject = inboundStream;
        }
        inboundStream.addTrack(event.track);
    }
}

// 移除外来数据源
function handleRemoteStreamRemoved(event) {
    console.log('WebRTC: Remote stream removed. Event: ', event);
}

// Server发起断开连接
function handleRemoteHangup() {
    console.log('WebSocket: session terminated by remote party.');
    destroyPeerConnection();
}

// 调用WebSocket发送消息
function sendMessage(message) {
    if (dataWebSocket == null)
        return;
    console.log('WebSocket: client sending message: ', message);
    dataWebSocket.send(message);
}
