let mouseDown = false;      // 记录鼠标是否按下
let mouseWebSocket = null;  // websocket
let remoteVideoRect;   // <video> 标签
let mouseDataChannel = null;
let pc1 = null;
let scaleValue = null;

function initStatus(e) {
    getPosition(e);
}

function mouseInit(dc, pc) {
    // mouseWebSocket = ws;
    mouseDataChannel = dc;
    pc1 = pc;
    remoteVideoRect = document.getElementById('video');
    remoteVideoRect.addEventListener('mousedown', mouseDownHandler); // 下压事件
    remoteVideoRect.addEventListener('mousemove', mouseMoveHandler); // 移动事件
    remoteVideoRect.addEventListener('mouseup', mouseUpHandler);     // 上移动事件
    remoteVideoRect.addEventListener('wheel', mouseWheelHandler);    // 滚轮事件？
    remoteVideoRect.addEventListener('ondragstart', onDragStart);
    remoteVideoRect.addEventListener('initStatus', initStatus);
    remoteVideoRect.addEventListener("touchstart", function (ev) {
        ev = ev || event;
        ev.preventDefault();
        remoteAudio.play()
        touchHandler(ev, 'down');
    })
    remoteVideoRect.addEventListener("touchmove", function (ev) {
        ev = ev || event;
        ev.preventDefault();
        touchHandler(ev, 'move');
    })
    remoteVideoRect.addEventListener("touchend", function (ev) {
        ev = ev || event;
        ev.preventDefault();
        touchHandler(ev, 'up');
    })
    setTimeout(function () {
        getScaleValue();
    }, 2000);
}

function mouseUninit() {
    remoteVideoRect.removeEventListener('ondragstart', onDragStart);
    remoteVideoRect.removeEventListener('wheel', mouseWheelHandler);
    remoteVideoRect.removeEventListener('mouseup', mouseUpHandler);
    remoteVideoRect.removeEventListener('mousemove', mouseMoveHandler);
    remoteVideoRect.removeEventListener('mousedown', mouseDownHandler);
    remoteVideoRect = null;
}

function onDragStart() {
    return false;
}

function mouseDownHandler(e) {
    if (!isMouseLeftButtonPressed(e))
        return;
    remoteAudio.play();
    mouseDown = true;
    mouseHandler(e, 'down');
}

function mouseMoveHandler(e) {
    if (!mouseDown)
        return;
    if (!isMouseLeftButtonPressed(e)) {
        mouseDown = false;
        mouseHandler(e, 'up');
        return;
    }
    mouseHandler(e, 'move');
}

function mouseUpHandler(e) {
    // pc不需要自动出声
    // remoteAudio.play()
    if (!mouseDown)
        return;
    if (isMouseLeftButtonPressed(e))
        return;
    mouseDown = false;
    mouseHandler(e, 'up');
}

function mouseWheelHandler(e) {
    if (!e.ctrlKey)
        return;
    if (e.deltaY > 0)
        mouseHandler(e, 'zoom_out');
    else if (e.deltaY < 0)
        mouseHandler(e, 'zoom_in');
    e.preventDefault();
}

function isMouseLeftButtonPressed(e) {
    let MOUSE_LEFT_BUTTON_NUMBER = 1;

    return e.buttons === undefined ? e.which === MOUSE_LEFT_BUTTON_NUMBER :
        e.buttons === MOUSE_LEFT_BUTTON_NUMBER;
}

function mouseHandler(e, action) {
    change(0);
    let position = getPosition(e);
    let nowOrientation = 0;
    if (e.target.clientWidth > e.target.clientHeight) {
        nowOrientation = 1;
    }
    let params = '{"type":"mouse",' + '"action":"' + action + '","x":' + Math.floor(position.comptutedX) + ',"y":' + Math.floor(position.comptutedY) + ',"uiwidth":' + e.target.clientWidth + ',"uiheight":' + e.target.clientHeight + ',"orientation":' + nowOrientation + '}';
    console.log(params);
    sendMouseMessage(params);
    setTimeout(function() { flushResolution(e); }, 2000);
    setTimeout(function() { flushResolution(e); }, 5000);
}

function touchHandler(e, action) {
    let position = getTouchPosition(e);
    let nowOrientation = 0;
    if (e.target.clientWidth > e.target.clientHeight) {
        nowOrientation = 1;
        change(1);
        let params1 = '{"type":"touch",' + '"action":"' + action + '","x":' + Math.floor(position.y) + ',"y":' + Math.floor(e.target.clientHeight - position.x) + ',"uiwidth":' + e.target.clientWidth + ',"uiheight":' + e.target.clientHeight + ',"orientation":' + nowOrientation + '}';
        console.log(params1);
        sendMouseMessage(params1);
        return;
    }
    change(0)
    let params2 = '{"type":"touch",' + '"action":"' + action + '","x":' + Math.floor(position.x) + ',"y":' + Math.floor(position.y) + ',"uiwidth":' + e.target.clientWidth + ',"uiheight":' + e.target.clientHeight + ',"orientation":' + nowOrientation + '}';
    console.log(params2);
    sendMouseMessage(params2);
}


function change(phoneOrientation) {
    let css = document.getElementById("cssId");
    if (phoneOrientation === 0) {
        if (css.getAttribute("href") === "../css/main.css") {
            return;
        }
        css.setAttribute("href", "../css/main.css");
    }

    if (phoneOrientation === 1) {
        if (css.getAttribute("href") === "../css/phoneVideoLand.css") {
            return;
        }
        css.setAttribute("href", "../css/phoneVideoLand.css");
    }
}

function getTouchPosition(e) {
    let rect = e.target.getBoundingClientRect();
    let TouchC = e.changedTouches[0];//可能触屏的有多根手指，只拿其中的第一根
    let startX = TouchC.clientX;//手指一开始的横坐标
    let startY = TouchC.clientY;//手指一开始的横坐标
    let x = startX - rect.left;
    let y = startY - rect.top;
    document.getElementById("resolution").innerText = "分辨率:\n"+e.target.clientWidth+"X"+e.target.clientHeight
    let selector = pc1.getRemoteStreams()[0].getVideoTracks()[0]
    // 获取视频流通信信息
    pc1.getStats(selector).then(report => {
        report.forEach(stats => {
            if (stats.type == 'inbound-rtp') {
                console.log('******************video status*********')
                console.log('type: ', stats.type);
                console.log('status: ', stats);
            }
        });
    }).catch(err => {
        console.error(err);
    });
    return {x, y};
}

function flushResolution(e) {
    document.getElementById("resolution").innerText = "分辨率:\n"+e.target.clientWidth+"X"+e.target.clientHeight
}

function getPosition(e) {
    let rect = e.target.getBoundingClientRect();
    let x = e.clientX - rect.left;
    let y = e.clientY - rect.top;
    document.getElementById("resolution").innerText = "分辨率:\n"+e.target.clientWidth+"X"+e.target.clientHeight
    let selector = pc1.getRemoteStreams()[0].getVideoTracks()[0]
    let comptutedX = x / scaleValue;
    let comptutedY = y / scaleValue;
    return {comptutedX, comptutedY};
}

function sendMouseMessage(message) {
    if (mouseDataChannel == null)
        return;
    mouseDataChannel.send(message);
}


