WITH_EXAGEAR ?= true
ifeq ($(WITH_EXAGEAR),true)

################
# Configuration options
################

# Fine-grained control over build-time pre-translation
EXAGEAR_PRETRANSLATE ?= true
ifeq ($(EXAGEAR_PRETRANSLATE),true)
EXAGEAR_PRETRANSLATE_ODEX ?= true
EXAGEAR_PRETRANSLATE_BOOT_OAT ?= true
EXAGEAR_PRETRANSLATE_BINARY ?= true
EXAGEAR_PRETRANSLATE_APK ?= true

# Whitelist of paths to pre-translate in the system image. This allows limiting
# the set of pre-translated libraries to reduce the system image size.
EXAGEAR_PRETRANSLATE_WHITELIST ?=
endif

# Fine-grained control over on-device pre-translation
EXAGEAR_PRETRANSLATE_ON_DEVICE ?= true
ifeq ($(EXAGEAR_PRETRANSLATE_ON_DEVICE),true)
# Currently disabled due to neverallow sepolicy rules
EXAGEAR_PRETRANSLATE_ON_DEVICE_ODEX ?= false
EXAGEAR_PRETRANSLATE_ON_DEVICE_BINARY ?= true
EXAGEAR_PRETRANSLATE_ON_DEVICE_APK ?= true

# Whether to force pre-translation on app installation. Otherwise it runs in
# the background like dexopt.
EXAGEAR_PRETRANS_ON_INSTALL ?= true
endif

################
# Core functionality
################

PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.enabled=1

ifeq ($(TARGET_BUILD_VARIANT),user)
PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.debug=off
else
PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.debug=info \
    exagear.log_dir="/data/exagear/log"
PRODUCT_COPY_FILES += \
    vendor/huawei/exagear/init/exagear-debug.rc:system_ext/etc/init/exagear-debug.rc:huawei
endif

PRODUCT_COPY_FILES += \
    vendor/huawei/exagear/init/exagear-binfmt.rc:system_ext/etc/init/exagear-binfmt.rc:huawei

PRODUCT_PACKAGES += ubt_a32a64

# Force any prefer32 targets to be compiled as 64 bit.
IGNORE_PREFER32_ON_DEVICE := true

# Use 64-bit dex2oat for better dexopt time.
PRODUCT_PROPERTY_OVERRIDES += \
    dalvik.vm.dex2oat64.enabled=true

SYSTEM_EXT_PUBLIC_SEPOLICY_DIRS += vendor/huawei/exagear/sepolicy/system/public
SYSTEM_EXT_PRIVATE_SEPOLICY_DIRS += vendor/huawei/exagear/sepolicy/system/private

################
# System image pre-translation
################

# Build-time pre-translation definitions
EXAGEAR_PRETRANSLATOR := vendor/huawei/exagear/prebuilts/preubt_a32a64_x64
define exagear-pretranslate
$(hide) $(EXAGEAR_PRETRANSLATOR) -j 2 --input-file-name=$(1) --output-file-name=$(2)
endef
define exagear-pretranslate-apk
$(hide) $(EXAGEAR_PRETRANSLATOR) -j 2 --apk --input-file-name=$(1) --output-file-name=$(2)
endef
define exagear-pretranslate-sym
$(hide) $(EXAGEAR_PRETRANSLATOR) -j 2 --input-file-name=$(1) --extra-symbols=$(2) --output-file-name=$(3)
endef

# Only pre-translate a whitelisted set of file to reduce system image size.
ifneq ($(EXAGEAR_PRETRANSLATE_WHITELIST),)
EXAGEAR_PRETRANSLATE_WHITELIST_RULES := $(shell grep -o '^[^#]*' $(EXAGEAR_PRETRANSLATE_WHITELIST))
define exagear-pretranslate-whitelisted
$(filter $(EXAGEAR_PRETRANSLATE_WHITELIST_RULES),$(notdir $(1)))
endef
else
define exagear-pretranslate-whitelisted
$(1)
endef
endif

################
# On-device pre-translation
################

ifeq ($(EXAGEAR_PRETRANSLATE_ON_DEVICE),true)

SYSTEM_EXT_PRIVATE_SEPOLICY_DIRS += vendor/huawei/exagear/sepolicy/pretranslator

PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.pretrans.max_size=67108864

ifeq ($(EXAGEAR_PRETRANS_ON_INSTALL),true)
PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.pretrans_on_install=true
else
PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.pretrans_on_install=false
endif

ifeq ($(TARGET_BUILD_VARIANT),user)
PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.pretrans.debug=off
else
PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.pretrans.debug=info \
    exagear.pretrans.log_dir="/data/exagear/pretrans_log"
endif

PRODUCT_PACKAGES += preubt_a32a64

ifeq ($(EXAGEAR_PRETRANSLATE_ON_DEVICE_ODEX),true)
PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.pretrans.odex=true
endif
ifeq ($(EXAGEAR_PRETRANSLATE_ON_DEVICE_BINARY),true)
PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.pretrans.lib=true
endif
ifeq ($(EXAGEAR_PRETRANSLATE_ON_DEVICE_APK),true)
PRODUCT_SYSTEM_EXT_PROPERTIES += \
    exagear.pretrans.apk=true
endif

endif # EXAGEAR_PRETRANSLATE_ON_DEVICE

endif # WITH_EXAGEAR
