let keyboardDown = false;document
let keyboardWebSocket = null;
let keyDataChannel = null;

function keyboardInit(dc) {
    // mouseWebSocket = ws;
    keyDataChannel = dc;
    // document = document.getElementById('screen');
    console.log("keyboard init");
    document.addEventListener('keydown', keyDownHandler);
    document.addEventListener('keyup', keyUpHandler);
}

function keyboardUninit() {
    document.removeEventListener('keydown', onDragStart);
    document.removeEventListener('keyup', onDragStart);
    // document = null;
}

function keyDownHandler(event) {
    switch (event.key) {
        case "ArrowDown":
            sendKeyMessage("down", "ArrowDown");
            break;
        case "ArrowUp":
            sendKeyMessage("down", "ArrowUp");
            break;
        case "ArrowLeft":
            sendKeyMessage("down", "ArrowLeft");
            break;
        case "ArrowRight":
            sendKeyMessage("down", "ArrowRight");
            break;
        default:
            sendKeyMessage("down", event.key);
            // console.log(event.key, event.keyCode);
            return; 
    }
    keyboardDown = true;
    event.preventDefault();
}

function keyUpHandler(event) {
    switch (event.key) {
        case "ArrowDown":
            sendKeyMessage("up", "ArrowDown");
            break;
        case "ArrowUp":
            sendKeyMessage("up", "ArrowUp");
            break;
        case "ArrowLeft":
            sendKeyMessage("up", "ArrowLeft");
            break;
        case "ArrowRight":
            sendKeyMessage("up", "ArrowRight");
            break;
        default:
            sendKeyMessage("up", event.key);
            // console.log(event.key, event.keyCode);
            return; 
    }
    keyboardDown = false;
    event.preventDefault();
}

function sendKeyMessage(action, key) {
    let message = '{"type":"keyboard",' + '"action":"' + action + '","key":"' + key + '"}';
    if (keyDataChannel == null)
        return;
    // console.log(message);
    keyDataChannel.send(message);
}