# Netint Transcoder Release Package
This release package contains Firmware, Software, Documents, and supporting files for the 
Netint Quadra video transcoder.

## Components
| File                                               | Description                                                       |
| -------------------------------------------------- | ----------------------------------------------------------------- |
| Android_quick_installer/                           | Scripts for installing Netint SW on Android emulator              |
| clamscan.log                                       | Clam AV scan log                                                  |
| InstallationGuideQuadra_V\*.pdf                    | Netint SW installation guide for various systems                  |
| IntegrationProgrammingGuideQuadra_V\*.pdf          | Netint FW/SW primary usage guide including list of xcoder-params  |
| libxcoder_API_Integration_guideQuadra_V\*.pdf      | Libxcoder API integration guide                                   |
| md5sum                                             | MD5 checksum of files                                             |
| Performance_Test_Report_V\*.pdf                    | FW/SW performance test results                                    |
| Quadra_FW_V\*.\*.\*/                               | FW release folder                                                 |
| Quadra_FW_V\*.\*.\*_release_notes.txt              | FW release notes                                                  |
| quadra_quick_installer.sh                          | FW/SW guided installation script for linux                        |
| Quadra_SW_V\*.\*.\*/                               | SW release folder                                                 |
| Quadra_SW_V\*.\*.\*_release_notes.txt              | SW release notes                                                  |
| Quadra_Video_Quality_Report_V\*.pdf                | FW/SW encoding quality test results                               |
| QuickStartGuideQuadra_V\*.pdf                      | FW/SW installation and introduction guide                         |
| README.md                                          | This file                                                         |
| sentinelscan.log                                   | SentinelOne AV scan log                                           |

Note, scripts typically have help text which can be accessed with the `-h` param.

## Installation
For typical linux environments the `quadra_quick_installer.sh` can be used. Refer to 
`QuickStartGuideQuadra_V*.pdf` for detailed usage instructions.

If installing Netint SW on special environments (eg. Windows, Android, etc.) see 
`InstallationGuideQuadra_V*.pdf`.

## Version Numbers Schema
### Release Version Number
Netint _release version numbers_ (eg. 4.1.0) consists of 3 characters: major, minor, and 
micro. Major milestone releases will increment major character. Periodic releases from 
development trunk will increment minor number. All other types of releases (eg. hot-fix) will 
increment micro number.

The _release version number_ characters may be 0-9 and A-Z.

A release of greater _release version number_ superseeds releases of lesser _release version 
number_. It is preferable to use release of greatest available release version number to have 
access to latest features and fixes.

Netint release packages have a _release version number_, but FW and SW releases also have their 
own 3 character FW/SW _release version number_. FW and SW releases in a release package does not 
always share the same _release version number_. If FW and SW releases in a release package are 
of different _release version numbers_, the release package's _release version number_ will be 
the larger _release version number_ between FW and SW releases.

### Full Version Number
Within FW and SW applications there is the 8 character _full version number_ (eg. 41058rc4).

FW _full version number_ can be read from `sudo nvme list`, `./quadra_fw_info FL_BIN/*.bin`.  
SW _full version number_ can be read libxcoder applications with `-v` arg (eg. `ni_rsrc_mon -v`
) or from code in `libxcoder/source/ni_defs.h`.

The first 3 characters of the _full version number_ is the _release version number_.

The last 3 characters of the _full version number_ are for Netint to track release development. 
For external users, these last 3 characters of the _full version number_ may be ignored as 
there will not be published releases with same _release version number_ but different release 
tracking number.

### FW API Version Number
Within the _full version number_ (eg. 4706r5r1) of FW and SW applications the 4th, 5th, and 6th
characters contain the _FW API version number_. This is a semantic major and two semantic minor 
version numbers that track API compatibility between FW and libxcoder. The major _FW API version 
number_ must match between FW and libxcoder for basic interoperability. The minor _FW API 
version number_ should match to access full/new feature set of FW/libxcoder.

The _FW API version number_ characters will be alphanumeric from 0-9, A-Z, and a-z. Their value
is determined by their binary value in ASCII table.

Netint endeavours to maintain backward compatibility between FW and libxcoder in all releases.

### Libxcoder API Version Number
The _libxcoder API version number_ is semantic major and minor version number pair that tracks 
libxcoder public API compatibility with linked APIs (eg. libavcodec) and applications (eg. 
xcoder-util). It can be read from code in `libxcoder/source/ni_defs.h`.

The _libxcoder API version number_ characters will be strictly numeric. The individual major 
and minor portions may have more than one digit.

The major _libxcoder API version number_ will be incremented when the API changes in a backward 
incompatible manner. The minor _libxcoder API version number_ will be incremented when new 
features are added that require updating application code to access. Regardless of any 
_libxcoder API version number changes_, it is recommended to recompile applications linked to 
libxcoder when updating to a new SW _release version_.

## Further Information
Special topics, such as low latency modes or HDR usage, has supporting documentation describing 
their use. Please contact Netint engineering support for the topic's application notes.
