#!/bin/bash

ARCH=$1
PCI_ID1=$2
PCI_ID2=$3
PCI_ID3=$4
PCI_ID4=$5
PCI_ID5=$6
PCI_ID6=$7
PCI_ID7=$8
PCI_ID8=$9

if [ $ARCH = '64' ]
then
    WORK_DIR='android_work'
    LUNCH_CMD='aosp_x86_64-eng'
else
    WORK_DIR='android_work32'
    LUNCH_CMD='aosp_x86-eng'
fi
#sudo -s -E << BASH

#BASH
#use none root
usernow=$USER && echo OK || echo Error
variable=$(ls  /dev/vfio/ |grep -E '[0-9]') && echo OK || echo Error
for i in $variable; do
  echo $i && echo OK || echo Error
	sudo chown $usernow:$usernow /dev/vfio/$i && echo OK || echo Error
done
sudo chown $usernow:$usernow /dev/kvm && echo OK || echo Error

cd /home/$USER/$WORK_DIR && echo OK || echo Error
source build/envsetup.sh && echo OK || echo Error
lunch $LUNCH_CMD && echo OK || echo Error
#emulator -memory 4096 -partition-size 4096 -writable-system -verbose -netdelay none -netspeed full -gpu off -no-window -qemu -enable-kvm $PCI_ID1 $PCI_ID2 $PCI_ID3 $PCI_ID4 $PCI_ID5 $PCI_ID6 $PCI_ID7 $PCI_ID8 -kernel goldfish/arch/x86/boot/bzImage
if [ -n "$2" ];then
# normal run
    emulator -memory 8192 -partition-size 8192 -writable-system -verbose -netdelay none -netspeed full -gpu off -no-window -qemu -enable-kvm $PCI_ID1 $PCI_ID2 $PCI_ID3 $PCI_ID4 $PCI_ID5 $PCI_ID6 $PCI_ID7 $PCI_ID8 -kernel goldfish/arch/x86/boot/bzImage
else
# if the device is not passed on we start a wipe
    emulator -memory 8192 -partition-size 8192 -wipe-data -writable-system -verbose -netdelay none -netspeed full -gpu off -no-window -qemu -kernel goldfish/arch/x86/boot/bzImage
fi

