#!/bin/bash

# ******************************************************************************** #
# Copyright Kbox Technologies Co., Ltd. 2020-2022. All rights reserved.
# File Name: create-package.sh
# Description: android镜像打tar包.
# Usage: create-package_aosp14.sh
# ******************************************************************************** #

set -ex

system=$1
destdir=$PWD

if [ -z "$system" ]; then
    echo "Usage: $0 <system image>"
    exit 1
fi

workdir=$(mktemp -d)
rootfs=$workdir/rootfs

mkdir -p "$rootfs"

mkdir "$workdir"/system
sudo mount -o loop,ro "$system" "$workdir"/system
sudo cp -ar "$workdir"/system/* "$rootfs"/
sudo umount "$workdir"/system

apexlist=($(ls "$rootfs"/system/apex | grep apex))
apexworkdir=$(mktemp -d)
for((i=0;i<${#apexlist[@]};i++)) do
    mkdir -p "$apexworkdir"/mnt
    sudo cp -anr "$rootfs"/system/apex/"${apexlist[$i]}" "$apexworkdir"
    basename=$(basename "${apexlist[$i]}" .apex)
    sudo unzip "$apexworkdir"/"${apexlist[$i]}" -d "$apexworkdir"
    sudo mount -o loop,ro "$apexworkdir"/apex_payload.img "$apexworkdir"/mnt
    sudo mkdir -p "$rootfs"/apex/"$basename"
    sudo cp -anr "$apexworkdir"/mnt/* "$rootfs"/apex/"$basename"
    sudo rm -rf "$rootfs"/apex/"$basename"/'lost+found'
    sudo cp -anr "$apexworkdir"/apex_pubkey "$rootfs"/apex/"$basename"
    sudo umount "$apexworkdir"/mnt
    sudo rm -rf "$apexworkdir"/*
done
sudo rm -rf "$apexworkdir"
sudo mv "$rootfs"/apex/com.android.vndk.current "$rootfs"/apex/com.android.vndk.v34

# FIXME
sudo chmod +x "$rootfs"/kbox-init.sh

if [ -e android.tar ]; then
    DATE=$(date +%F_%R)
    SAVETO=android-old-$DATE.tar

    echo "#########################################################"
    echo "# WARNING: Old android.tar still exists.                 "
    echo "#          Moving it to $SAVETO.                         "
    echo "#########################################################"

    mv android.tar "$SAVETO"
fi

#sudo mksquashfs $rootfs $destdir/android.tar -comp xz -no-xattrs
cd "$rootfs"
sudo tar --numeric-owner -cf "$destdir"/android.tar ./
sudo chown "$USER":"$USER" "$destdir"/android.tar

cd "$destdir"
sudo rm -rf "$workdir"
