LOCAL_PATH := $(call my-dir)

define install-va-shared-libs
include $$(CLEAR_VARS)
LOCAL_MODULE := $1
LOCAL_VENDOR_MODULE := true
LOCAL_SRC_FILES_arm64 := $2
ifneq ($3,)
LOCAL_SRC_FILES_arm := $3
endif
LOCAL_MODULE_CLASS := SHARED_LIBRARIES
ifneq ($4,)
LOCAL_MODULE_RELATIVE_PATH := $4
endif
LOCAL_MODULE_SUFFIX := .so
LOCAL_CHECK_ELF_FILES := false
ifneq ($5,)
LOCAL_MULTILIB := both
endif
include $$(BUILD_PREBUILT)
endef 

define install-va-video-libs
include $$(CLEAR_VARS)
LOCAL_MODULE := $1
LOCAL_VENDOR_MODULE := true
LOCAL_SRC_FILES_arm64 := $2
ifneq ($3,)
LOCAL_SRC_FILES_arm := $3
endif
LOCAL_MODULE_CLASS := SHARED_LIBRARIES
ifneq ($4,)
LOCAL_MODULE_RELATIVE_PATH := $4
endif
LOCAL_CHECK_ELF_FILES := false
ifneq ($5,)
LOCAL_MULTILIB := both
endif
include $$(BUILD_PREBUILT)
endef 

define install-va-configs
include $$(CLEAR_VARS)
LOCAL_MODULE := $1
LOCAL_VENDOR_MODULE := true
LOCAL_SRC_FILES_arm64 := $2
ifneq ($3,)
LOCAL_SRC_FILES_arm := $3
endif
ifneq ($4,)
LOCAL_MODULE_PATH := $4
endif
LOCAL_MODULE_CLASS := ETC
LOCAL_CHECK_ELF_FILES := false
include $$(BUILD_PREBUILT)
endef 

define install-va-bins
include $$(CLEAR_VARS)
LOCAL_MODULE := $1
LOCAL_SRC_FILES_arm64 := $2
ifneq ($3,)
LOCAL_SRC_FILES_arm := $3
endif
LOCAL_MODULE_CLASS := EXECUTABLES
LOCAL_CHECK_ELF_FILES := false
LOCAL_PROPRIETARY_MODULE = true
include $$(BUILD_PREBUILT)
endef 

define override-va-syslibs
include $$(CLEAR_VARS)
LOCAL_MODULE := $1
LOCAL_SRC_FILES_arm64 := $2
ifneq ($3,)
LOCAL_SRC_FILES_arm := $3
endif
LOCAL_MODULE_PATH := $(TARGET_OUT_SYSTEM_LIB64)
LOCAL_MODULE_CLASS := SHARED_LIBRARIES
LOCAL_CHECK_ELF_FILES := false
LOCAL_MODULE_TAGS := optional
LOCAL_MODULE_SUFFIX := .so
LOCAL_OVERRIDES_PACKAGES := $1
include $$(BUILD_PREBUILT)
endef 

# GFX

egl_libs := \
libEGL_va \
libGLESv2_va \
libGLESv1_CM_va \

$(foreach lib, $(egl_libs), \
	$(eval $(call install-va-shared-libs, \
		$(lib), \
		vendor/lib64/egl/$(lib).so, \
		vendor/lib/egl/$(lib).so, \
		egl, \
		1)))

hw_libs := \
gralloc.sgpu100 \
vulkan.va \

$(foreach lib, $(hw_libs), \
	$(eval $(call install-va-shared-libs, \
		$(lib), \
		vendor/lib64/hw/$(lib).so, \
		vendor/lib/hw/$(lib).so, \
		hw, \
		1)))

um_libs := \
libVAegl \
libVAOCL \
libsrv_um \
libusc \
libufwriter \
libsutu_display \
libcreatesurface \
libvaANDROID_WSEGL \

$(foreach lib, $(um_libs), \
	$(eval $(call install-va-shared-libs, \
		$(lib), \
		vendor/lib64/$(lib).so, \
		vendor/lib/$(lib).so, \
		, \
		1)))

gpu_bins := \
gpu_config.sh \

$(foreach bin, $(gpu_bins), \
	$(eval $(call install-va-bins, \
		$(bin), \
		vendor/bin/$(bin), \
		, \
		)))

va_config := \
va_gfx.ini \

$(foreach config, $(va_config), \
	$(eval $(call install-va-configs, \
		$(config), \
		vendor/etc/$(config), \
		, \
		$(TARGET_OUT_VENDOR_ETC))))

# SDK

hwc_libs := \
hwcomposer.sgpu100

$(foreach lib, $(hwc_libs), \
	$(eval $(call install-va-shared-libs, \
		hwcomposer.redroid, \
		vendor/lib64/hw/$(lib).so, \
		, \
		hw, \
		)))


disp_libs := \
libDisplayServer \

$(foreach lib, $(disp_libs), \
	$(eval $(call install-va-shared-libs, \
		$(lib), \
		vendor/lib64/$(lib).so, \
		, \
		, \
		)))

# VIDEO

ffmpeg_libs := \
libavdevice \
libavfilter \
libswscale \
libavutil \
libswresample \
libavformat \
libavcodec \
libpostproc \
libvaccrt \

$(foreach lib, $(ffmpeg_libs), \
	$(eval $(call install-va-shared-libs, \
		$(lib), \
		vendor/lib64/$(lib).so, \
		, \
		, \
		)))

video_libs := \
libvastdrm_hantro.so \
libvastdrm_hantro.so.1 \
libvastdrm.so \
libvastdrm.so.2 \
libvastva-drm.so \
libvastva-drm.so.2 \
libvastva.so \
libvastva.so.2 \

$(foreach lib, $(video_libs), \
	$(eval $(call install-va-video-libs, \
		$(lib), \
		vendor/lib64/$(lib), \
		, \
		, \
		)))


video_drv_libs := \
va_drv_video \

$(foreach lib, $(video_drv_libs), \
	$(eval $(call install-va-shared-libs, \
		$(lib), \
		vendor/lib64/$(lib).so, \
		, \
		, \
		)))

vame_libs := \
libfn-log \
libvacm \
libvame \
libvaml \
libvmpp-enc \

$(foreach lib, $(vame_libs), \
	$(eval $(call install-va-shared-libs, \
		$(lib), \
		vendor/lib64/vame/lib/$(lib).so, \
		, \
		vame/lib, \
		)))

vame_config_1 := \
vslog.cfg \

$(foreach config, $(vame_config_1), \
	$(eval $(call install-va-configs, \
		$(config), \
		vendor/etc/$(config), \
		, \
		$(TARGET_OUT_VENDOR_ETC))))

# OMX

omx_libs := \
libstagefrighthw_va \
libVa_OMX_VideoDec_HW \
va_omx_component \

$(foreach lib, $(omx_libs), \
	$(eval $(call install-va-shared-libs, \
		$(lib), \
		vendor/lib64/$(lib).so, \
		vendor/lib/$(lib).so, \
		, \
		)))

sys_libs := \
libstagefright_omx \
libstagefright \

$(foreach lib, $(sys_libs), \
	$(eval $(call install-va-syslibs, \
		$(lib), \
		lib64/$(lib).so, \
		lib/$(lib).so, \
		)))
