#!/bin/bash
##################################
#功能描述: 使用ClamAV进行防病毒扫描测试
#版本信息: 华为技术有限公司，版权所有（C） 2020-2022
#修改记录：2022-02-10 修改
##################################

source ~/.bashrc
shopt -s expand_aliases
if [ ! -d "./log" ]; then
    mkdir ./log
fi
CURRENT_PATH=$(pwd)
current_time=$(date "+%Y%m%d")
log_file=info.log_${current_time}
error_file=error.log_${current_time}
clam_log_file=clam.log_${current_time}


write_messages() {
    # 日志输出函数
    # 参数1：输出日志级别
    # 参数2：输出颜色，0-默认，31-红色，32-绿色，33-黄色，34-蓝色，35-紫色，36-天蓝色，3-白色。
    # 参数3：执行步骤。
    # 参数4：输出的日志内容。
    DATE=$(date "+%Y-%m-%d %H:%M:%S")
    messages=$4
    step=$3
    level_info=$1
    colors=$2
    case $level_info in
    i) echo "#${DATE}#info#${step}#${messages}" >> "${CURRENT_PATH}"/log/"${log_file}"
        ;;
    e) echo "#${DATE}#error#${step}#${messages}" >> "${CURRENT_PATH}"/log/"${log_file}"
       echo -e "\033[1;31m${messages}\033[0m"
        ;;
    m) echo "#${DATE}#value#${step}#${messages}" >> "${CURRENT_PATH}"/log/"${log_file}" ;;
    s) echo "#${DATE}#serious#${step}#${messages}" >> "${CURRENT_PATH}"/log/"${error_file}"
       echo -e "\033[1;31m${messages}\033[0m"
        ;;
    c) echo -e "\033[1;34m${messages}\033[0m"
       echo "#${DATE}#info#${step}#${messages}" >> "${CURRENT_PATH}"/log/"${log_file}"
        ;;
    esac
}

clam_scan(){
    scan_path=$1
    file_path="data/test/safety/"
    if [ ! -d "${file_path}" ]; then
        mkdir -p "${file_path}"
    fi
    # 更新病毒库
    freshclam
    # 扫描目录
    if [ -f ${file_path}${clam_log_file} ];then
        cat /dev/null > ${file_path}${clam_log_file}
    fi
    OLD_IFS="${IFS}"
    IFS=','

    for spath in "${scan_path[@]}"; do
        if ! clamscan -r ${spath}  --log=${file_path}${clam_log_file} 2>&1; then
            write_messages  c 34 6 "防病毒扫描测试扫描出错"
        fi
    done
    IFS="${OLD_IFS}"
}

clamav_install(){
    # 病毒扫描软件安装
    if  hash yum  2>/dev/null && ! hash clamscan 2>/dev/null; then
        if ! yum install -y clamav clamav-update; then
            write_messages  e 0 1 "安装病毒扫描软件clamAV失败，请检查网络环境和yum源配置，并安装clamav的RPM包。"
            exit 1
        fi
    fi
    if hash apt-get 2>/dev/null && ! hash clamscan 2>/dev/null; then
        if ! apt-get install -y clamav; then
            write_messages  e 0 1 "安装病毒扫描软件clamAV失败，请检查网络环境和yum源配置，并安装clamav的RPM包。"
            exit 1
        fi
    fi
}

clamav_install
clam_scan $1