/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbStruct;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Struct;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.DmWkb;
import org.geolatte.geom.codec.db.Encoder;

public class DmStructEncoder
implements Encoder<Struct> {
    public <P extends Position, G extends Geometry<P>> Struct encode(G geom, Connection connection) {
        if (geom == null) {
            return null;
        }
        try {
            byte[] wkb = DmWkb.toWkb(geom).toByteArray();
            int srid = geom.getSRID();
            int type = this.geoType(geom.getGeometryType().getCamelCased());
            DmdbConnection dmConn = null;
            dmConn = connection instanceof DmdbConnection ? (DmdbConnection)connection : connection.unwrap(DmdbConnection.class);
            Blob wkbObj = dmConn.createBlob();
            wkbObj.setBytes(1L, wkb);
            if (geom.isEmpty()) {
                wkbObj = null;
            }
            return dmConn.createStruct("SYSGEO.ST_GEOMETRY", new Object[]{srid, wkbObj, type});
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't parse outcoming Dameng Spatial data.", e);
        }
    }

    public <P extends Position, G extends Geometry<P>> DmdbStruct encode(G geom) {
        throw new RuntimeException("Couldn't parse outcoming Dameng Spatial data.(No Connection)");
    }

    public <P extends Position> boolean accepts(Geometry<P> geom) {
        return false;
    }

    private int geoType(String geometryType) {
        if ("POINT".equalsIgnoreCase(geometryType)) {
            return 0;
        }
        if ("LINESTRING".equalsIgnoreCase(geometryType)) {
            return 1;
        }
        if ("LINEARRING".equalsIgnoreCase(geometryType)) {
            return 2;
        }
        if ("POLYGON".equalsIgnoreCase(geometryType)) {
            return 3;
        }
        if ("MULTIPOINT".equalsIgnoreCase(geometryType)) {
            return 4;
        }
        if ("MULTILINESTRING".equalsIgnoreCase(geometryType)) {
            return 5;
        }
        if ("MULTIPOLYGON".equalsIgnoreCase(geometryType)) {
            return 6;
        }
        if ("GEOMETRYCOLLECTION".equalsIgnoreCase(geometryType)) {
            return 7;
        }
        return -1;
    }
}

