/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.schema.internal.StandardTableExporter;

public class DmTableExporter
extends StandardTableExporter {
    public DmTableExporter(Dialect dialect) {
        super(dialect);
    }

    public String[] getSqlCreateStrings(Table table, Metadata metadata, SqlStringGenerationContext context) {
        QualifiedName tableName = DmTableExporter.getTableName(table);
        try {
            String formattedTableName = context.format(tableName);
            StringBuilder createTable = new StringBuilder();
            String viewQuery = table.getViewQuery();
            if (viewQuery != null) {
                createTable.append("create view ").append(formattedTableName).append(" as ").append(viewQuery);
            } else {
                String rowIdColumn;
                StringBuilder extra = new StringBuilder();
                createTable.append(this.tableCreateString(table.hasPrimaryKey())).append(' ').append(formattedTableName).append(" (");
                boolean isFirst = true;
                for (Column column : table.getColumns()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        createTable.append(", ");
                    }
                    DmTableExporter.appendColumn(createTable, column, table, metadata, this.dialect, context);
                    extra.append(column.getValue().getExtraCreateTableInfo());
                }
                if (table.getRowId() != null && (rowIdColumn = this.dialect.getRowIdColumnString(table.getRowId())) != null) {
                    createTable.append(", ").append(rowIdColumn);
                }
                if (table.hasPrimaryKey()) {
                    createTable.append(", ").append(table.getPrimaryKey().sqlConstraintString(this.dialect));
                }
                createTable.append(this.dialect.getUniqueDelegate().getTableCreationUniqueConstraintsFragment(table, context));
                this.applyTableCheck(table, createTable);
                createTable.append(')');
                createTable.append((CharSequence)extra);
                if (table.getComment() != null) {
                    createTable.append(this.dialect.getTableComment(table.getComment()));
                }
                this.applyTableTypeString(createTable);
            }
            ArrayList<String> sqlStrings = new ArrayList<String>();
            sqlStrings.add(createTable.toString());
            this.applyComments(table, formattedTableName, sqlStrings);
            this.applyInitCommands(table, sqlStrings, context);
            return sqlStrings.toArray(StringHelper.EMPTY_STRINGS);
        }
        catch (Exception var12) {
            Exception e = var12;
            throw new MappingException("Error creating SQL 'create' commands for table '" + table.getName() + "' [" + e.getMessage() + "]", (Throwable)e);
        }
    }

    private static QualifiedName getTableName(Table table) {
        return new QualifiedNameParser.NameParts(Identifier.toIdentifier((String)table.getCatalog(), (boolean)table.isCatalogQuoted()), Identifier.toIdentifier((String)table.getSchema(), (boolean)table.isSchemaQuoted()), table.getNameIdentifier());
    }

    private static void appendColumn(StringBuilder statement, Column column, Table table, Metadata metadata, Dialect dialect, SqlStringGenerationContext context) {
        statement.append(column.getQuotedName(dialect));
        DmTableExporter.appendColumnDefinition(statement, column, metadata, dialect);
        DmTableExporter.appendComment(statement, column, dialect);
        DmTableExporter.appendConstraints(statement, column, table, dialect, context);
    }

    private static void appendColumnDefinition(StringBuilder definition, Column column, Metadata metadata, Dialect dialect) {
        if (column.isIdentity()) {
            if (dialect.getIdentityColumnSupport().hasDataTypeInIdentityColumn()) {
                definition.append(' ').append(column.getSqlType(metadata));
            }
            String columnType = DmTableExporter.processColumnType(dialect.getIdentityColumnSupport().getIdentityColumnString(column.getSqlTypeCode((Mapping)metadata)));
            definition.append(' ').append(columnType);
        } else {
            String generatedAs;
            String defaultValue;
            String collation;
            String columnType = DmTableExporter.processColumnType(column.getSqlType(metadata));
            if (column.getGeneratedAs() == null || dialect.hasDataTypeBeforeGeneratedAs()) {
                definition.append(' ').append(columnType);
            }
            if ((collation = column.getCollation()) != null) {
                definition.append(" collate ").append(dialect.quoteCollation(collation));
            }
            if ((defaultValue = column.getDefaultValue()) != null) {
                definition.append(" default ").append(defaultValue);
            }
            if ((generatedAs = column.getGeneratedAs()) != null) {
                definition.append(dialect.generatedAs(generatedAs));
            }
            if (column.isNullable()) {
                definition.append(dialect.getNullColumnString(columnType));
            } else {
                definition.append(" not null");
            }
        }
    }

    private static String processColumnType(String type) {
        if ((type = type.toUpperCase()).contains("BLOB")) {
            type = "BLOB";
        } else if (type.contains("CLOB")) {
            type = "CLOB";
        } else if (type.contains("TEXT") || type.contains("JSON") || type.contains("XML")) {
            type = "TEXT";
        }
        return type;
    }

    private static void appendComment(StringBuilder definition, Column column, Dialect dialect) {
        String columnComment = column.getComment();
        if (columnComment != null) {
            definition.append(dialect.getColumnComment(columnComment));
        }
    }

    private static void appendConstraints(StringBuilder definition, Column column, Table table, Dialect dialect, SqlStringGenerationContext context) {
        block9: {
            if (column.isUnique() && !table.isPrimaryKey(column)) {
                String uniqueKeyName = column.getUniqueKeyName();
                String keyName = uniqueKeyName == null ? Constraint.generateName((String)"UK_", (Table)table, (Column[])new Column[]{column}) : uniqueKeyName;
                UniqueKey uniqueKey = table.getOrCreateUniqueKey(keyName);
                uniqueKey.addColumn(column);
                definition.append(dialect.getUniqueDelegate().getColumnDefinitionUniquenessFragment(column, context));
            }
            if (!dialect.supportsColumnCheck()) break block9;
            List checkConstraints = column.getCheckConstraints();
            long anonConstraints = checkConstraints.stream().filter(CheckConstraint::isAnonymous).count();
            if (anonConstraints == 1L) {
                for (CheckConstraint constraint : checkConstraints) {
                    definition.append(constraint.constraintString());
                }
            } else {
                boolean first = true;
                for (CheckConstraint constraint : checkConstraints) {
                    if (!constraint.isAnonymous()) continue;
                    if (first) {
                        definition.append(" check (");
                        first = false;
                    } else {
                        definition.append(" and ");
                    }
                    definition.append(constraint.getConstraintInParens());
                }
                if (!first) {
                    definition.append(")");
                }
                for (CheckConstraint constraint : checkConstraints) {
                    if (!constraint.isNamed()) continue;
                    definition.append(constraint.constraintString());
                }
            }
        }
    }
}

