/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.HashMap;
import java.util.Map;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.DmWkbDecoder;
import org.geolatte.geom.codec.DmWkbEncoder;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;

public class DmWkb
extends Wkb {
    protected static final Wkb.Dialect DEFAULT_DIALECT = Wkb.Dialect.POSTGIS_EWKB_1;
    protected static final Map<Wkb.Dialect, Class<?>> DECODERS = new HashMap();
    protected static final Map<Wkb.Dialect, Class<?>> ENCODERS = new HashMap();

    static {
        DECODERS.put(Wkb.Dialect.POSTGIS_EWKB_1, DmWkbDecoder.class);
        ENCODERS.put(Wkb.Dialect.POSTGIS_EWKB_1, DmWkbEncoder.class);
    }

    public static ByteBuffer toWkb(Geometry geometry) {
        return DmWkb.toWkb(geometry, ByteOrder.NDR);
    }

    public static ByteBuffer toWkb(Geometry<?> geometry, ByteOrder byteOrder) {
        WkbEncoder encoder = DmWkb.newEncoder(DEFAULT_DIALECT);
        return encoder.encode(geometry, byteOrder);
    }

    public static Geometry<?> fromWkb(ByteBuffer byteBuffer, int srid) {
        DmWkbDecoder decoder = new DmWkbDecoder(srid);
        return decoder.decode(byteBuffer);
    }

    public static WkbDecoder newDecoder(Wkb.Dialect dialect) {
        Class<?> decoderClass = DECODERS.get(dialect);
        assert (decoderClass != null) : "A variant declared, but no encoder/decoder registered.";
        return (WkbDecoder)DmWkb.createInstance(decoderClass);
    }

    public static WkbDecoder newDecoder() {
        Class<?> decoderClass = DECODERS.get(DEFAULT_DIALECT);
        assert (decoderClass != null) : "A variant declared, but no encoder/decoder registered.";
        return (WkbDecoder)DmWkb.createInstance(decoderClass);
    }

    public static WkbEncoder newEncoder(Wkb.Dialect dialect) {
        Class<?> decoderClass = ENCODERS.get(dialect);
        assert (decoderClass != null) : "A variant declared, but no encoder/decoder registered.";
        return (WkbEncoder)DmWkb.createInstance(decoderClass);
    }

    public static WkbEncoder newEncoder() {
        Class<?> decoderClass = ENCODERS.get(DEFAULT_DIALECT);
        assert (decoderClass != null) : "A variant declared, but no encoder/decoder registered.";
        return (WkbEncoder)DmWkb.createInstance(decoderClass);
    }

    private static Object createInstance(Class<?> codecClass) {
        if (codecClass == null) {
            throw new IllegalArgumentException("Null WKB codec class argument not allowed.");
        }
        try {
            return codecClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

