/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm.dmgeo2;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;
import org.geotools.geometry.jts.WKTWriter2;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;

public class DmJdbcLiteralFormatter<T>
implements JdbcLiteralFormatter<T> {
    private static final long serialVersionUID = -8356108950802128304L;
    private final JavaType<T> javaType;
    private final String formatterString;

    DmJdbcLiteralFormatter(JavaType<T> javaType) {
        this.javaType = javaType;
        this.formatterString = "dmgeo2.ST_GeomFromText";
    }

    public void appendJdbcLiteral(SqlAppender appender, T value, Dialect dialect, WrapperOptions wrapperOptions) {
        if (value instanceof org.locationtech.jts.geom.Geometry) {
            org.locationtech.jts.geom.Geometry geom = (org.locationtech.jts.geom.Geometry)this.javaType.unwrap(value, org.locationtech.jts.geom.Geometry.class, wrapperOptions);
            appender.appendSql(this.formatterString);
            appender.appendSql("('");
            appender.appendSql(new WKTWriter2().write(geom));
            appender.appendSql("',");
            appender.appendSql(Math.max(geom.getSRID(), 0));
            appender.appendSql(")");
        } else {
            Geometry geom = (Geometry)this.javaType.unwrap(value, Geometry.class, wrapperOptions);
            appender.appendSql(this.formatterString);
            appender.appendSql("('");
            appender.appendSql(Wkt.toWkt((Geometry)geom, (Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1));
            appender.appendSql("',");
            appender.appendSql(Math.max(geom.getSRID(), 0));
            appender.appendSql(")");
        }
    }
}

