/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm.dmgeo2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import org.geolatte.geom.Geometry;
import org.hibernate.spatial.dialect.dm.dmgeo2.DmStructDecoder;
import org.hibernate.spatial.dialect.dm.dmgeo2.DmStructEncoder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public abstract class AbstractDmJdbcType
implements JdbcType {
    private static final long serialVersionUID = -1665257527151594637L;
    private String geoModelType;
    private int defaultSqlTypeCode;

    public AbstractDmJdbcType(int defaultSqlTypeCode, String geoModelType) {
        this.defaultSqlTypeCode = defaultSqlTypeCode;
        this.geoModelType = geoModelType;
    }

    public int getJdbcTypeCode() {
        return 2002;
    }

    public int getDefaultSqlTypeCode() {
        return this.defaultSqlTypeCode;
    }

    public abstract int getSpatialType();

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){
            private static final long serialVersionUID = 4353221814133054721L;

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, this.toStruct(value, options, st.getConnection()));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, (Object)this.toStruct(value, options, st.getConnection()));
            }

            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                if (AbstractDmJdbcType.this.getJdbcTypeCode() == 2002) {
                    st.setNull(index, 12);
                    return;
                }
                st.setNull(index, AbstractDmJdbcType.this.getJdbcTypeCode());
            }

            private Struct toStruct(X value, WrapperOptions options, Connection connection) {
                Struct encoded = null;
                DmStructEncoder encoder = new DmStructEncoder(AbstractDmJdbcType.this.getSpatialType());
                if (value instanceof org.locationtech.jts.geom.Geometry) {
                    org.locationtech.jts.geom.Geometry geometry = (org.locationtech.jts.geom.Geometry)this.getJavaType().unwrap(value, org.locationtech.jts.geom.Geometry.class, options);
                    encoded = encoder.encodeJts(geometry, connection);
                } else {
                    Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                    encoded = encoder.encodeGeolatte(geometry, connection);
                }
                return encoded;
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){
            private static final long serialVersionUID = -6906223685778641517L;

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                Object result = this.toGeometry(rs.getObject(paramIndex));
                if (AbstractDmJdbcType.this.defaultSqlTypeCode == 2002) {
                    return result;
                }
                return this.getJavaType().wrap(result, options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                Object result = this.toGeometry(statement.getObject(index));
                if (AbstractDmJdbcType.this.defaultSqlTypeCode == 2002) {
                    return result;
                }
                return this.getJavaType().wrap(result, options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                Object result = this.toGeometry(statement.getObject(name));
                if (AbstractDmJdbcType.this.defaultSqlTypeCode == 2002) {
                    return result;
                }
                return this.getJavaType().wrap(result, options);
            }

            private <T> T toGeometry(Object object) {
                if (object == null) {
                    return null;
                }
                if (object instanceof Struct) {
                    DmStructDecoder decoder = new DmStructDecoder();
                    if (AbstractDmJdbcType.this.geoModelType.equals("jts_geometry")) {
                        return (T)decoder.decodeJts((Struct)object);
                    }
                    return (T)decoder.decodeGeolatte((Struct)object);
                }
                throw new IllegalStateException("Object of type " + object.getClass().getCanonicalName() + " could not be handled as spatial value by Dameng");
            }
        };
    }
}

