/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.PostgisWkbParser;
import org.geolatte.geom.codec.WkbDialect;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.crs.LinearUnit;
import org.geolatte.geom.crs.Unit;

public class DmWkbParser<P extends Position>
extends PostgisWkbParser<P> {
    DmWkbParser(WkbDialect dialect, ByteBuffer buffer, CoordinateReferenceSystem<P> crs) {
        super(dialect, buffer, crs);
    }

    public void setSrid(int srid) {
    }

    protected void readCrs(ByteBuffer byteBuffer, int typeCode) {
        this.hasM = (typeCode & 0x40000000) == 0x40000000;
        this.hasZ = (typeCode & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        int srid = 0;
        if (this.hasSrid(typeCode)) {
            srid = byteBuffer.getInt();
        }
        CoordinateReferenceSystem crsDeclared = CrsRegistry.ifAbsentReturnProjected2D((int)srid);
        if (this.hasZ) {
            crsDeclared = CoordinateReferenceSystems.addVerticalSystem((CoordinateReferenceSystem)crsDeclared, (LinearUnit)Unit.METER);
        }
        if (this.hasM) {
            crsDeclared = CoordinateReferenceSystems.addLinearSystem((CoordinateReferenceSystem)crsDeclared, (LinearUnit)Unit.METER);
        }
        this.embeddedCRS = crsDeclared;
    }
}

