/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm.dmgeo2;

import com.dameng.geotools.util.dm.DmGeo2Util;
import com.dameng.geotools.util.dm.StructType;
import dm.jdbc.driver.DmdbConnection;
import java.sql.Connection;
import java.sql.Struct;
import org.geolatte.geom.Geometry;

public class DmStructEncoder {
    private final int targetSpatialType;

    public DmStructEncoder(int targetSpatialType) {
        this.targetSpatialType = targetSpatialType;
    }

    public Struct encodeJts(org.locationtech.jts.geom.Geometry geom, Connection connection) {
        if (geom == null) {
            return null;
        }
        try {
            DmdbConnection dmConn = null;
            dmConn = connection instanceof DmdbConnection ? (DmdbConnection)connection : connection.unwrap(DmdbConnection.class);
            switch (this.targetSpatialType) {
                case 101: {
                    return DmGeo2Util.dmGeometry((org.locationtech.jts.geom.Geometry)geom, (Connection)dmConn).toDmStruct(StructType.GEOM);
                }
                case 102: {
                    return DmGeo2Util.dmGeometry((org.locationtech.jts.geom.Geometry)geom, (Connection)dmConn).toDmStruct(StructType.GEOG);
                }
            }
            throw new RuntimeException("An internal error occurred when an invalidate DmSpatialType code " + this.targetSpatialType + " was given in encodeJts().");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Struct encodeGeolatte(Geometry<?> geom, Connection connection) {
        if (geom == null) {
            return null;
        }
        try {
            DmdbConnection dmConn = null;
            dmConn = connection instanceof DmdbConnection ? (DmdbConnection)connection : connection.unwrap(DmdbConnection.class);
            switch (this.targetSpatialType) {
                case 101: {
                    return DmGeo2Util.dmGeometry(geom, (Connection)dmConn).toDmStruct(StructType.GEOM);
                }
                case 102: {
                    return DmGeo2Util.dmGeometry(geom, (Connection)dmConn).toDmStruct(StructType.GEOG);
                }
            }
            throw new RuntimeException("An internal error occurred when an invalidate DmSpatialType code " + this.targetSpatialType + " was given in encodeGeolatte().");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

